/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.system.convert.SysDataRoleConvert;
import com.elitesland.yst.system.model.entity.SysDataRoleAuthCustomizeDO;
import com.elitesland.yst.system.model.entity.SysDataRoleAuthDO;
import com.elitesland.yst.system.repo.SysDataRoleAuthCustomizeRepo;
import com.elitesland.yst.system.repo.SysDataRoleAuthRepo;
import com.elitesland.yst.system.repo.SysDataRoleAuthRepoProc;
import com.elitesland.yst.system.service.ISysDataRoleAuthService;
import com.elitesland.yst.system.service.param.SysDataRoleAuthCustomizeSaveParam;
import com.elitesland.yst.system.service.param.SysDataRoleAuthSaveParam;
import com.elitesland.yst.system.service.vo.SysDataRoleAuthCustomizeVO;
import com.elitesland.yst.system.service.vo.SysDataRoleAuthVO;
import com.elitesland.yst.system.util.SysDataRoleAuthCustomizeTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ISysDataRoleAuthServiceImpl
implements ISysDataRoleAuthService {
    private final SysDataRoleAuthRepo sysDataRoleAuthRepo;
    private final SysDataRoleAuthCustomizeRepo sysDataRoleAuthCustomizeRepo;
    private final SysDataRoleAuthRepoProc sysDataRoleAuthRepoProc;

    public List<SysDataRoleAuthVO> findAuthsVoByDataRoleId(Long dataRoleId) {
        List<Long> dataRoleAuthIds;
        List<SysDataRoleAuthCustomizeVO> customizeInfos;
        List<SysDataRoleAuthVO> authVos = this.sysDataRoleAuthRepoProc.findAuthByDataRoleId(dataRoleId);
        if (CollectionUtils.isNotEmpty(authVos) && CollectionUtils.isNotEmpty(customizeInfos = this.sysDataRoleAuthRepoProc.findCustomizeInfoByAuthIds(dataRoleAuthIds = authVos.stream().map(SysDataRoleAuthVO::getId).collect(Collectors.toList())))) {
            Map<Long, List<SysDataRoleAuthCustomizeVO>> customizeVosMap = customizeInfos.stream().collect(Collectors.groupingBy(SysDataRoleAuthCustomizeVO::getDataRoleAuthId));
            authVos.forEach(auth -> {
                if (customizeVosMap.containsKey(auth.getId())) {
                    Map<String, List<SysDataRoleAuthCustomizeVO>> customizeMap = ((List)customizeVosMap.get(auth.getId())).stream().collect(Collectors.groupingBy(SysDataRoleAuthCustomizeVO::getCustomizeType));
                    auth.setEmpCustomize((List)customizeMap.getOrDefault(SysDataRoleAuthCustomizeTypeEnum.EMP.name(), null));
                    auth.setBuCustomize((List)customizeMap.getOrDefault(SysDataRoleAuthCustomizeTypeEnum.BU.name(), null));
                    auth.setOuCustomize((List)customizeMap.getOrDefault(SysDataRoleAuthCustomizeTypeEnum.OU.name(), null));
                }
            });
        }
        return authVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void dataRoleAuthHardSave(Long dataRoleId, List<SysDataRoleAuthSaveParam> sysDataRoleAuthSaveParams) {
        ArrayList<Long> dataRoleAuthIds = new ArrayList<Long>();
        HashMap<Integer, SysDataRoleAuthDO> authDOMap = new HashMap<Integer, SysDataRoleAuthDO>();
        HashMap authCustomizeDOMap = new HashMap();
        for (int i = 0; i < sysDataRoleAuthSaveParams.size(); ++i) {
            List ouCustomizeSaveParams;
            List buCustomizeSaveParams;
            List<SysDataRoleAuthCustomizeSaveParam> customizeSaveParams;
            List empCustomizeSaveParams;
            SysDataRoleAuthSaveParam authSaveParam = sysDataRoleAuthSaveParams.get(i);
            ArrayList customizeDos = new ArrayList();
            if (authSaveParam.getId() != null) {
                dataRoleAuthIds.add(authSaveParam.getId());
            }
            this.defaultValueInit(authSaveParam);
            SysDataRoleAuthDO authDo = SysDataRoleConvert.INSTANCE.authSaveParamToDo(authSaveParam);
            authDo.setDataRoleId(dataRoleId);
            authDOMap.put(i, authDo);
            if (authSaveParam.getEmpCustomizeEnable().booleanValue() && CollectionUtils.isNotEmpty((Collection)(empCustomizeSaveParams = authSaveParam.getEmpCustomize())) && CollectionUtils.isNotEmpty(customizeSaveParams = empCustomizeSaveParams.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
                customizeSaveParams.forEach(empCustomize -> {
                    SysDataRoleAuthCustomizeDO empCustomizeDo = SysDataRoleConvert.INSTANCE.authCustomizeSaveParamToDo((SysDataRoleAuthCustomizeSaveParam)empCustomize);
                    empCustomizeDo.setCustomizeType(SysDataRoleAuthCustomizeTypeEnum.EMP.name());
                    customizeDos.add(empCustomizeDo);
                });
            }
            if (authSaveParam.getBuCustomizeEnable().booleanValue() && CollectionUtils.isNotEmpty((Collection)(buCustomizeSaveParams = authSaveParam.getBuCustomize())) && CollectionUtils.isNotEmpty(customizeSaveParams = buCustomizeSaveParams.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
                customizeSaveParams.forEach(buCustomize -> {
                    SysDataRoleAuthCustomizeDO buCustomizeDo = SysDataRoleConvert.INSTANCE.authCustomizeSaveParamToDo((SysDataRoleAuthCustomizeSaveParam)buCustomize);
                    buCustomizeDo.setCustomizeType(SysDataRoleAuthCustomizeTypeEnum.BU.name());
                    customizeDos.add(buCustomizeDo);
                });
            }
            if (authSaveParam.getOuCustomizeEnable().booleanValue() && CollectionUtils.isNotEmpty((Collection)(ouCustomizeSaveParams = authSaveParam.getOuCustomize())) && CollectionUtils.isNotEmpty(customizeSaveParams = ouCustomizeSaveParams.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
                customizeSaveParams.forEach(buCustomize -> {
                    SysDataRoleAuthCustomizeDO ouCustomizeDo = SysDataRoleConvert.INSTANCE.authCustomizeSaveParamToDo((SysDataRoleAuthCustomizeSaveParam)buCustomize);
                    ouCustomizeDo.setCustomizeType(SysDataRoleAuthCustomizeTypeEnum.OU.name());
                    customizeDos.add(ouCustomizeDo);
                });
            }
            authCustomizeDOMap.put(i, customizeDos);
        }
        this.sysDataRoleAuthRepo.deleteByDataRoleId(dataRoleId);
        this.sysDataRoleAuthRepo.saveAll(authDOMap.values());
        ArrayList customizeSaveDos = new ArrayList();
        authDOMap.forEach((index, auth) -> {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)authCustomizeDOMap.get(index)))) {
                List saveDos = (List)authCustomizeDOMap.get(index);
                saveDos.forEach(customizeDO -> customizeDO.setDataRoleAuthId(auth.getId()));
                customizeSaveDos.addAll(saveDos);
            }
        });
        this.sysDataRoleAuthCustomizeRepo.deleteByDataRoleAuthIdIn(dataRoleAuthIds);
        this.sysDataRoleAuthCustomizeRepo.saveAll(customizeSaveDos);
    }

    private void defaultValueInit(SysDataRoleAuthSaveParam authSaveParam) {
        if (authSaveParam.getIsPermitAll() == null) {
            authSaveParam.setIsPermitAll(Boolean.valueOf(false));
        }
        if (authSaveParam.getEmpAuthEnable() == null) {
            authSaveParam.setEmpAuthEnable(Boolean.valueOf(false));
        }
        if (authSaveParam.getEmpCustomizeEnable() == null) {
            authSaveParam.setEmpCustomizeEnable(Boolean.valueOf(false));
        }
        if (authSaveParam.getBuAuthEnable() == null) {
            authSaveParam.setBuAuthEnable(Boolean.valueOf(false));
        }
        if (authSaveParam.getBuCustomizeEnable() == null) {
            authSaveParam.setBuCustomizeEnable(Boolean.valueOf(false));
        }
        if (authSaveParam.getOuAuthEnable() == null) {
            authSaveParam.setOuAuthEnable(Boolean.valueOf(false));
            authSaveParam.setOuCustomizeEnable(Boolean.valueOf(false));
        } else {
            authSaveParam.setOuCustomizeEnable(authSaveParam.getOuAuthEnable());
        }
    }

    public ISysDataRoleAuthServiceImpl(SysDataRoleAuthRepo sysDataRoleAuthRepo, SysDataRoleAuthCustomizeRepo sysDataRoleAuthCustomizeRepo, SysDataRoleAuthRepoProc sysDataRoleAuthRepoProc) {
        this.sysDataRoleAuthRepo = sysDataRoleAuthRepo;
        this.sysDataRoleAuthCustomizeRepo = sysDataRoleAuthCustomizeRepo;
        this.sysDataRoleAuthRepoProc = sysDataRoleAuthRepoProc;
    }
}

