/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.common.RoleWhiteListEnum;
import com.elitesland.yst.security.config.CustomSecurityProperties;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysDataRoleConvert;
import com.elitesland.yst.system.model.entity.SysDataRoleDO;
import com.elitesland.yst.system.repo.SysDataRoleRepo;
import com.elitesland.yst.system.repo.SysDataRoleRepoProc;
import com.elitesland.yst.system.service.ISysDataRoleAuthService;
import com.elitesland.yst.system.service.ISysDataRoleService;
import com.elitesland.yst.system.service.SysBizDataConstraintService;
import com.elitesland.yst.system.service.param.SysDataRoleAuthSaveParam;
import com.elitesland.yst.system.service.param.SysDataRoleBatchSwitchParam;
import com.elitesland.yst.system.service.param.SysDataRolePagingParam;
import com.elitesland.yst.system.service.param.SysDataRoleSaveParam;
import com.elitesland.yst.system.service.vo.SysDataRoleAuthVO;
import com.elitesland.yst.system.service.vo.SysDataRoleDetailsVO;
import com.elitesland.yst.system.service.vo.SysDataRolePagingVO;
import com.elitesland.yst.system.service.vo.SysDataRoleSelectVO;
import com.elitesland.yst.system.vo.SysDataRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class ISysDataRoleServiceImpl
implements ISysDataRoleService {
    private static final Logger log = LogManager.getLogger(ISysDataRoleServiceImpl.class);
    private final ISysDataRoleAuthService sysDataRoleAuthService;
    private final SysDataRoleRepo sysDataRoleRepo;
    private final SysDataRoleRepoProc sysDataRoleRepoProc;
    private final CustomSecurityProperties customSecurityProperties;
    private SysBizDataConstraintService sysBizDataConstraintService;

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public PagingVO<SysDataRolePagingVO> sysDataRolePagingSearch(SysDataRolePagingParam param) {
        return this.sysDataRoleRepoProc.findPaging(param);
    }

    @Autowired
    public void setSysBizDataConstraintService(SysBizDataConstraintService sysBizDataConstraintService) {
        this.sysBizDataConstraintService = sysBizDataConstraintService;
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public SysDataRoleDetailsVO findDetailsById(Long id) {
        SysDataRoleDetailsVO details = this.sysDataRoleRepoProc.findDetailsById(id);
        if (details == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0cID\u4e0d\u5b58\u5728");
        }
        List dataRoleAuthVos = this.sysDataRoleAuthService.findAuthsVoByDataRoleId(id);
        if (CollectionUtils.isNotEmpty((Collection)dataRoleAuthVos)) {
            Iterator iterator = dataRoleAuthVos.iterator();
            while (iterator.hasNext()) {
                SysDataRoleAuthVO authVo = (SysDataRoleAuthVO)iterator.next();
                if (!authVo.getIsBasic().booleanValue()) continue;
                details.setSysDataRoleBasicAuth(authVo);
                iterator.remove();
                break;
            }
            details.setSysDataRoleAdvancedAuth(dataRoleAuthVos);
        }
        List sysBizDataConstraintVOS = this.sysBizDataConstraintService.listByRoleCode(details.getCode());
        details.setSysBizDataConstraintVOS(sysBizDataConstraintVOS);
        return details;
    }

    public Optional<SysDataRoleVO> findOneByCode(String roleCode) {
        return Optional.ofNullable(this.sysDataRoleRepoProc.findDataRoleByCode(roleCode));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Long sysDateRoleSaveOrUpdate(SysDataRoleSaveParam param) {
        SysDataRoleDO sysDataRoleDO;
        if (param.getId() == null) {
            if (RoleWhiteListEnum.ADMIN.name().equalsIgnoreCase(param.getCode())) {
                throw new BusinessException("\u7f16\u53f7\uff1a" + param.getCode() + " \u4e3a\u7cfb\u7edf\u5185\u7f6e\u6570\u636e\u7ba1\u7406\u5458\u7f16\u53f7\uff0c\u65e0\u6cd5\u4f7f\u7528");
            }
            if (this.sysDataRoleRepo.existsByCode(param.getCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7f16\u53f7\uff1a" + param.getCode() + "\u5df2\u5b58\u5728");
            }
            if (this.sysDataRoleRepo.existsByName(param.getName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u540d\u79f0\uff1a" + param.getName() + "\u5df2\u5b58\u5728");
            }
            sysDataRoleDO = SysDataRoleConvert.INSTANCE.saveParamToDo(param);
        } else {
            if (RoleWhiteListEnum.ADMIN.name().equalsIgnoreCase(param.getCode())) {
                throw new BusinessException("\u7cfb\u7edf\u6570\u636e\u7ba1\u7406\u5458\u89d2\u8272\u4e3a\u5185\u7f6e\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            if (this.sysDataRoleRepo.existsByNameAndIdNot(param.getName(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u540d\u79f0\uff1a" + param.getName() + "\u5df2\u5b58\u5728");
            }
            Optional optional = this.sysDataRoleRepo.findById(param.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e");
            }
            sysDataRoleDO = (SysDataRoleDO)optional.get();
            SysDataRoleConvert.INSTANCE.updateSaveParamToDo(param, sysDataRoleDO);
        }
        this.sysDataRoleRepo.save(sysDataRoleDO);
        this.dataRoleAuthInfoHardSave(sysDataRoleDO.getId(), param);
        if (param.getSysBizDataConstraintSaveParams() != null && !param.getSysBizDataConstraintSaveParams().isEmpty()) {
            this.sysBizDataConstraintService.updateInBatch(sysDataRoleDO.getCode(), param.getSysBizDataConstraintSaveParams());
        }
        return sysDataRoleDO.getId();
    }

    public List<SysDataRoleSelectVO> findDataRoleSelectAll() {
        return this.sysDataRoleRepoProc.findDataRoleSelectAll();
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysDataRoleSelectVO> listAllByPermission() {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return Collections.emptyList();
        }
        List<SysDataRoleSelectVO> roles = this.findDataRoleSelectAll();
        if (roles.isEmpty()) {
            return roles;
        }
        Set<String> noPermissionRoles = this.rolesOfNoPermission(currentUser.getUser());
        for (SysDataRoleSelectVO role : roles) {
            role.setNoPermission(Boolean.valueOf(noPermissionRoles.contains(role.getCode())));
        }
        return roles;
    }

    public Set<String> rolesOfNoPermission(SysUserDTO user) {
        Set allRoleCodes = RoleWhiteListEnum.getAllCode();
        if (user == null) {
            return allRoleCodes;
        }
        Set userRoles = user.getSysDataRoleVOS();
        if (userRoles == null || userRoles.isEmpty()) {
            return allRoleCodes;
        }
        String prefix = this.grantedAuthorityPrefix();
        int prefixLength = prefix.length();
        Set userRoleCodes = userRoles.stream().map(t -> {
            int index = t.getCode().indexOf(prefix);
            if (index < 0) {
                return t.getCode();
            }
            return t.getCode().substring(index + prefixLength);
        }).collect(Collectors.toSet());
        if (userRoleCodes.isEmpty()) {
            return allRoleCodes;
        }
        return allRoleCodes.stream().filter(t -> !userRoleCodes.contains(t)).collect(Collectors.toSet());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void batchSwitchEnable(SysDataRoleBatchSwitchParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIds())) {
            return;
        }
        List<Long> ids = param.getIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (param.getEnabled() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sysDataRoleRepoProc.switchEnableByIds(ids, param.getEnabled());
    }

    public Map<String, Long> getIdByName(Set<String> names) {
        if (CollUtil.isEmpty(names)) {
            return Collections.emptyMap();
        }
        return this.sysDataRoleRepoProc.getIdByName(names);
    }

    public Map<String, Long> getIdByCode(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return Collections.emptyMap();
        }
        return this.sysDataRoleRepoProc.getIdByCode(codes);
    }

    public Long getIdByCode(String code) {
        return this.sysDataRoleRepoProc.getIdByCode(code);
    }

    private void dataRoleAuthInfoHardSave(Long dataRoleId, SysDataRoleSaveParam param) {
        List<SysDataRoleAuthSaveParam> advancedAuthInfos;
        SysDataRoleAuthSaveParam basicAuthInfo = param.getSysDataRoleBasicAuth();
        if (this.isAuthEmpty(basicAuthInfo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5fc5\u987b\u914d\u7f6e\u57fa\u7840\u6388\u6743\u4fe1\u606f");
        }
        ArrayList<SysDataRoleAuthSaveParam> dataRoleAuthSaveParams = new ArrayList<SysDataRoleAuthSaveParam>();
        basicAuthInfo.setIsBasic(Boolean.valueOf(true));
        dataRoleAuthSaveParams.add(basicAuthInfo);
        if (param.getAdvancedEnable().booleanValue() && CollectionUtils.isNotEmpty((Collection)param.getSysDataRoleAdvancedAuth()) && CollectionUtils.isNotEmpty(advancedAuthInfos = param.getSysDataRoleAdvancedAuth().stream().filter(auth -> !this.isAuthEmpty((SysDataRoleAuthSaveParam)auth)).collect(Collectors.toList()))) {
            advancedAuthInfos.forEach(auth -> auth.setIsBasic(Boolean.valueOf(false)));
            dataRoleAuthSaveParams.addAll(advancedAuthInfos);
        }
        this.sysDataRoleAuthService.dataRoleAuthHardSave(dataRoleId, dataRoleAuthSaveParams);
    }

    private boolean isAuthEmpty(SysDataRoleAuthSaveParam authSaveParam) {
        return !(authSaveParam != null && (authSaveParam.getIsPermitAll() != null && authSaveParam.getIsPermitAll() != false || authSaveParam.getEmpAuthEnable() != null && authSaveParam.getEmpAuthEnable() != false || authSaveParam.getBuAuthEnable() != null && authSaveParam.getBuAuthEnable() != false || authSaveParam.getOuAuthEnable() != null && authSaveParam.getOuAuthEnable() != false));
    }

    private String grantedAuthorityPrefix() {
        return CharSequenceUtil.blankToDefault((CharSequence)this.customSecurityProperties.getRolePrefix(), (String)"ROLE_");
    }

    public ISysDataRoleServiceImpl(ISysDataRoleAuthService sysDataRoleAuthService, SysDataRoleRepo sysDataRoleRepo, SysDataRoleRepoProc sysDataRoleRepoProc, CustomSecurityProperties customSecurityProperties) {
        this.sysDataRoleAuthService = sysDataRoleAuthService;
        this.sysDataRoleRepo = sysDataRoleRepo;
        this.sysDataRoleRepoProc = sysDataRoleRepoProc;
        this.customSecurityProperties = customSecurityProperties;
    }
}

