/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.convert.SysNextNumberConvert;
import com.elitesland.yst.system.param.SysNextNumberQParam;
import com.elitesland.yst.system.service.ISysNextNumberService;
import com.elitesland.yst.system.service.ISysUdcService;
import com.elitesland.yst.system.service.entity.SysNextNumberDO;
import com.elitesland.yst.system.service.impl.NextNumberCreatorFactory;
import com.elitesland.yst.system.service.repo.SysNextNumberRepo;
import com.elitesland.yst.system.service.repo.SysNextNumberRepoProc;
import com.elitesland.yst.system.vo.SysNextNumberVO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ISysNextNumberServiceImpl
implements ISysNextNumberService {
    private static final Logger log = LogManager.getLogger(ISysNextNumberServiceImpl.class);
    private static final SysNextNumberConvert CONVERT = SysNextNumberConvert.INSTANCE;
    private ConcurrentHashMap<String, Lock> lockMap = new ConcurrentHashMap(256);
    @Autowired
    private SysNextNumberRepo sysNextNumberRepo;
    @Autowired
    private SysNextNumberRepoProc sysNextNumberRepoProc;
    @Autowired
    private NextNumberCreatorFactory nextNumberCreatorFactory;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ISysUdcService sysUdcService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> create(SysNextNumberVO nextNumber) {
        boolean exists = this.sysNextNumberRepoProc.existsCode(nextNumber.getCode(), null);
        if (exists) {
            return ApiResult.fail((String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        SysNextNumberDO nextNumberDo = CONVERT.voToDO(nextNumber);
        if (nextNumberDo.getNnTime() == null) {
            nextNumberDo.setNnTime(LocalDateTime.now());
        }
        this.sysNextNumberRepo.save((Object)nextNumberDo);
        return ApiResult.ok((Object)nextNumberDo.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(SysNextNumberVO nextNumber) {
        if (nextNumber.getId() == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        }
        boolean exists = this.sysNextNumberRepoProc.existsCode(nextNumber.getCode(), nextNumber.getId());
        if (exists) {
            return ApiResult.fail((String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        SysNextNumberDO nextNumberDO = (SysNextNumberDO)this.sysNextNumberRepoProc.get(nextNumber.getId());
        if (nextNumberDO == null) {
            return ApiResult.fail((String)"\u66f4\u65b0\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        nextNumberDO.setCode(nextNumber.getCode()).setName(nextNumber.getName()).setNumberClass(nextNumber.getNumberClass()).setStep(nextNumber.getStep()).setNextNumber(nextNumber.getNextNumber());
        this.sysNextNumberRepo.save((Object)nextNumberDO);
        return ApiResult.ok((Object)nextNumber.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        this.sysNextNumberRepoProc.delete(ids);
        return ApiResult.ok((Object)true);
    }

    public ApiResult<PagingVO<SysNextNumberVO>> search(SysNextNumberQParam param) {
        PagingVO pagingDo = this.sysNextNumberRepoProc.search(param);
        if (pagingDo.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        Map<String, String> udcNnPeriod = this.getUdcNnPeriod();
        PagingVO pagingVO = this.sysNextNumberRepoProc.search(param).map(t -> {
            SysNextNumberVO vo = CONVERT.doToVO((SysNextNumberDO)t);
            vo.setNnPeriodName((String)udcNnPeriod.get(vo.getNnPeriod()));
            return vo;
        });
        return ApiResult.ok((Object)pagingVO);
    }

    public ApiResult<SysNextNumberVO> oneById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        SysNextNumberVO nextNumberVO = this.sysNextNumberRepoProc.getOptional(id).map(CONVERT::doToVO).orElse(null);
        return ApiResult.ok((Object)nextNumberVO);
    }

    public ApiResult<Long> getNextNumber(String code, Integer nnLen) {
        int i;
        Long newNextNumber = null;
        for (i = 0; i < 5; ++i) {
            try {
                newNextNumber = this.lockAndCreate(code, nnLen);
                break;
            }
            catch (Exception e) {
                if (e instanceof BusinessException) {
                    throw (BusinessException)e;
                }
                log.warn("\u53d1\u53f7\u5668\u751f\u6210\u5931\u8d25\uff0c\u91cd\u8bd5\u7b2c" + (i + 1) + "\u6b21", (Throwable)e);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    log.error("\u53d1\u53f7\u5668\u751f\u6210\u6682\u505c\u5931\u8d25", (Throwable)ignored);
                }
                continue;
            }
        }
        if (newNextNumber == null) {
            throw new BusinessException("\u53d1\u53f7\u5931\u8d25\uff0c\u5f53\u524d\u8bbf\u95ee\u6570\u8fc7\u591a");
        }
        log.info("\u6210\u529f\u53d1\u53f7\uff0c\u91cd\u8bd5\u6b21\u6570\u4e3a\uff1a{}", (Object)i);
        return ApiResult.ok((Object)newNextNumber);
    }

    public ApiResult<Long> getNextNumbers(String code, Integer nnLen, String telhead) {
        int i;
        Long newNextNumber = null;
        for (i = 0; i < 5; ++i) {
            try {
                newNextNumber = this.lockAndCreates(code, nnLen, telhead);
                break;
            }
            catch (Exception e) {
                if (e instanceof BusinessException) {
                    throw (BusinessException)e;
                }
                log.warn("\u53d1\u53f7\u5668\u751f\u6210\u5931\u8d25\uff0c\u91cd\u8bd5\u7b2c" + (i + 1) + "\u6b21", (Throwable)e);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    log.error("\u53d1\u53f7\u5668\u751f\u6210\u6682\u505c\u5931\u8d25", (Throwable)ignored);
                }
                continue;
            }
        }
        if (newNextNumber == null) {
            throw new BusinessException("\u53d1\u53f7\u5931\u8d25\uff0c\u5f53\u524d\u8bbf\u95ee\u6570\u8fc7\u591a");
        }
        log.info("\u6210\u529f\u53d1\u53f7\uff0c\u91cd\u8bd5\u6b21\u6570\u4e3a\uff1a{}", (Object)i);
        return ApiResult.ok((Object)newNextNumber);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> getNextNumberForRuntime(String code, Integer nnLen) {
        SysNextNumberDO nndOpt = this.sysNextNumberRepoProc.getByCode(code);
        if (nndOpt == null) {
            this.nextNumberCreatorFactory.createNumber(code);
        }
        return this.getNextNumber(code, nnLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Long lockAndCreate(String code, Integer nnLen) throws Exception {
        block19: {
            Lock lockLocal = this.lockMap.computeIfAbsent(code, c -> new ReentrantLock());
            try {
                if (!lockLocal.tryLock(1L, TimeUnit.MINUTES)) break block19;
                try {
                    Long l = this.nextNumberCreatorFactory.nextNumber(code, nnLen);
                    return l;
                }
                catch (Exception e) {
                    RLock lockRedis;
                    block20: {
                        Long l;
                        block21: {
                            log.info("\u53d1\u53f7\u5931\u8d25\uff1a{}\uff0c\u6539\u7528\u5206\u5e03\u5f0f\u9501", (Object)e.getMessage());
                            lockRedis = null;
                            lockRedis = this.redissonClient.getLock("yst_system_number_" + code);
                            if (!lockRedis.tryLock(30L, 30L, TimeUnit.SECONDS)) break block20;
                            l = this.nextNumberCreatorFactory.nextNumber(code, nnLen);
                            if (lockRedis == null || !lockRedis.isLocked()) break block21;
                            lockRedis.unlock();
                        }
                        try {
                            lockLocal.unlock();
                        }
                        catch (IllegalMonitorStateException e2) {
                            log.warn("\u91ca\u653e\u9501\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
                        }
                        return l;
                    }
                    if (lockRedis != null && lockRedis.isLocked()) {
                        lockRedis.unlock();
                    }
                    break block19;
                    {
                        catch (Throwable throwable) {
                            if (lockRedis != null && lockRedis.isLocked()) {
                                lockRedis.unlock();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                try {
                    lockLocal.unlock();
                }
                catch (IllegalMonitorStateException e) {
                    log.warn("\u91ca\u653e\u9501\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Long lockAndCreates(String code, Integer nnLen, String telhead) throws Exception {
        block19: {
            Lock lockLocal = this.lockMap.computeIfAbsent(code, c -> new ReentrantLock());
            try {
                if (!lockLocal.tryLock(1L, TimeUnit.MINUTES)) break block19;
                try {
                    Long l = this.nextNumberCreatorFactory.nextNumbers(code, nnLen, telhead);
                    return l;
                }
                catch (Exception e) {
                    RLock lockRedis;
                    block20: {
                        Long l;
                        block21: {
                            log.info("\u53d1\u53f7\u5931\u8d25\uff1a{}\uff0c\u6539\u7528\u5206\u5e03\u5f0f\u9501", (Object)e.getMessage());
                            lockRedis = null;
                            lockRedis = this.redissonClient.getLock("yst_system_number_" + code);
                            if (!lockRedis.tryLock(30L, 30L, TimeUnit.SECONDS)) break block20;
                            l = this.nextNumberCreatorFactory.nextNumbers(code, nnLen, telhead);
                            if (lockRedis == null || !lockRedis.isLocked()) break block21;
                            lockRedis.unlock();
                        }
                        try {
                            lockLocal.unlock();
                        }
                        catch (IllegalMonitorStateException e2) {
                            log.warn("\u91ca\u653e\u9501\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
                        }
                        return l;
                    }
                    if (lockRedis != null && lockRedis.isLocked()) {
                        lockRedis.unlock();
                    }
                    break block19;
                    {
                        catch (Throwable throwable) {
                            if (lockRedis != null && lockRedis.isLocked()) {
                                lockRedis.unlock();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                try {
                    lockLocal.unlock();
                }
                catch (IllegalMonitorStateException e) {
                    log.warn("\u91ca\u653e\u9501\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private Map<String, String> getUdcNnPeriod() {
        return this.sysUdcService.getCodeMap("SYS", "NNPERIOD");
    }
}

