/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.convert.SysNumberRuleDtlConvert;
import com.elitesland.yst.system.dto.SysNumberRuleDtlDTO;
import com.elitesland.yst.system.service.ISysNumberRuleDtlService;
import com.elitesland.yst.system.service.ISysUdcService;
import com.elitesland.yst.system.service.entity.SysNumberRuleDtlDO;
import com.elitesland.yst.system.service.repo.SysNumberRuleDtlRepo;
import com.elitesland.yst.system.service.repo.SysNumberRuleDtlRepoProc;
import com.elitesland.yst.system.vo.SysNumberRuleDtlVO;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ISysNumberRuleDtlServiceImpl
implements ISysNumberRuleDtlService {
    private static final Logger log = LogManager.getLogger(ISysNumberRuleDtlServiceImpl.class);
    private static final SysNumberRuleDtlConvert CONVERT = SysNumberRuleDtlConvert.INSTANCE;
    @Autowired
    private SysNumberRuleDtlRepo sysNumberRuleDtlRepo;
    @Autowired
    private SysNumberRuleDtlRepoProc sysNumberRuleDtlRepoProc;
    @Autowired
    private ISysUdcService sysUdcService;

    @Transactional(rollbackOn={Exception.class})
    public ApiResult<Long> updateInBatch(List<SysNumberRuleDtlVO> details) {
        if (CollectionUtils.isEmpty(details)) {
            return ApiResult.fail((String)"\u89c4\u5219\u660e\u7ec6\u4e3a\u7a7a");
        }
        Long ruleId = details.get(0).getRuleId();
        if (ruleId == null) {
            return ApiResult.fail((String)"\u53d1\u8d27\u671f\u89c4\u5219ID\u4e3a\u7a7a");
        }
        this.sysNumberRuleDtlRepoProc.deleteByRuleId(ruleId);
        AtomicInteger i = new AtomicInteger();
        List detailDoList = details.stream().map(detail -> {
            detail.setRuleId(ruleId);
            if (detail.getSeq() == null) {
                detail.setSeq(Integer.valueOf(i.getAndIncrement()));
            }
            return CONVERT.voToDO((SysNumberRuleDtlVO)detail);
        }).collect(Collectors.toList());
        this.sysNumberRuleDtlRepo.saveAll(detailDoList);
        return ApiResult.ok((Object)ruleId);
    }

    @Transactional(rollbackOn={Exception.class})
    public ApiResult<Boolean> removeByIds(List<Long> ids) {
        Long id;
        if (CollectionUtils.isEmpty(ids)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        Long ruleId = null;
        Iterator<Long> iterator = ids.iterator();
        while (iterator.hasNext() && (ruleId = this.sysNumberRuleDtlRepoProc.getRuleId(id = iterator.next())) == null) {
        }
        if (ruleId == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        this.sysNumberRuleDtlRepoProc.delete(ids);
        List details = this.sysNumberRuleDtlRepoProc.queryDetails(ruleId);
        if (details.isEmpty()) {
            return ApiResult.ok((Object)true);
        }
        int seq = 0;
        for (SysNumberRuleDtlDO detail : details) {
            detail.setSeq(Integer.valueOf(seq));
            ++seq;
        }
        this.sysNumberRuleDtlRepo.saveAll((Iterable)details);
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Long> removeByRuleId(Long ruleId) {
        if (ruleId == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        this.sysNumberRuleDtlRepoProc.deleteByRuleId(ruleId);
        return ApiResult.ok((Object)ruleId);
    }

    public ApiResult<List<SysNumberRuleDtlVO>> listByRuleId(Long ruleId) {
        if (ruleId == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        List details = this.sysNumberRuleDtlRepoProc.queryDetails(ruleId);
        if (details.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map<String, String> numberTypeUdc = this.getUdcNumberTypeMap();
        List result = details.stream().map(t -> {
            SysNumberRuleDtlVO vo = CONVERT.doToVO((SysNumberRuleDtlDO)t);
            vo.setNumberTypeName((String)numberTypeUdc.get(vo.getNumberType()));
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok(result);
    }

    public ApiResult<List<SysNumberRuleDtlDTO>> listDtoByRuleId(Long ruleId) {
        if (ruleId == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        List result = this.sysNumberRuleDtlRepoProc.queryByRuleId(ruleId);
        return ApiResult.ok((Object)result);
    }

    public ApiResult<SysNumberRuleDtlVO> oneById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        SysNumberRuleDtlVO ruleDtlVO = this.sysNumberRuleDtlRepoProc.getOptional(id).map(CONVERT::doToVO).orElse(null);
        return ApiResult.ok((Object)ruleDtlVO);
    }

    private Map<String, String> getUdcNumberTypeMap() {
        return this.sysUdcService.getCodeMap("SYS", "NUMBERTYPE");
    }
}

