/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.convert.SysNumberRuleConvert;
import com.elitesland.yst.system.dto.SysNumberRuleDtlDTO;
import com.elitesland.yst.system.param.SysNumberRuleQParam;
import com.elitesland.yst.system.service.ISysNumberRuleService;
import com.elitesland.yst.system.service.SysNextNumberService;
import com.elitesland.yst.system.service.SysNumberRuleDtlService;
import com.elitesland.yst.system.service.entity.SysNumberRuleDO;
import com.elitesland.yst.system.service.repo.SysNumberRuleDtlRepoProc;
import com.elitesland.yst.system.service.repo.SysNumberRuleRepo;
import com.elitesland.yst.system.service.repo.SysNumberRuleRepoProc;
import com.elitesland.yst.system.vo.SysNumberRuleVO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ISysNumberRuleServiceImpl
implements ISysNumberRuleService {
    private static final Logger log = LogManager.getLogger(ISysNumberRuleServiceImpl.class);
    private static final SysNumberRuleConvert CONVERT = SysNumberRuleConvert.INSTANCE;
    private static final Map<String, DateTimeFormatter> FORMATTER_MAP = new HashMap<String, DateTimeFormatter>();
    @Autowired
    private SysNumberRuleRepo sysNumberRuleRepo;
    @Autowired
    private SysNumberRuleRepoProc sysNumberRuleRepoProc;
    @Autowired
    private SysNumberRuleDtlRepoProc sysNumberRuleDtlRepoProc;
    @Autowired
    private SysNumberRuleDtlService sysNumberRuleDtlService;
    @Autowired
    private SysNextNumberService sysNextNumberService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> create(SysNumberRuleVO rule) {
        boolean exists = this.sysNumberRuleRepoProc.existsRuleCode(rule.getRuleCode());
        if (exists) {
            return ApiResult.fail((String)("\u7f16\u53f7\u89c4\u5219\uff1a" + rule.getRuleCode() + "\uff0c \u5df2\u7ecf\u5b58\u5728"));
        }
        SysNumberRuleDO ruleDO = CONVERT.voToDO(rule);
        this.sysNumberRuleRepo.save((Object)ruleDO);
        return ApiResult.ok((Object)rule.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(SysNumberRuleVO rule) {
        if (rule.getId() == null) {
            return ApiResult.fail((String)"\u6570\u636e\u6807\u8bc6ID\u4e3a\u7a7a");
        }
        SysNumberRuleDO numberRuleDO = (SysNumberRuleDO)this.sysNumberRuleRepoProc.get(rule.getId());
        if (numberRuleDO == null) {
            return ApiResult.fail((String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        boolean exists = this.sysNumberRuleRepoProc.existsRuleCode(rule.getRuleCode(), rule.getId());
        if (exists) {
            return ApiResult.fail((String)("\u7f16\u53f7\u89c4\u5219\uff1a" + rule.getRuleCode() + "\uff0c \u5df2\u7ecf\u5b58\u5728"));
        }
        numberRuleDO.setRuleCode(rule.getRuleCode());
        numberRuleDO.setRuleName(rule.getRuleName());
        numberRuleDO.setRuleClass(rule.getRuleClass());
        this.sysNumberRuleRepo.save((Object)numberRuleDO);
        return ApiResult.ok((Object)numberRuleDO.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> removeById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        this.sysNumberRuleRepoProc.delete(id);
        return ApiResult.ok((Object)true);
    }

    @SysCodeProc
    public ApiResult<PagingVO<SysNumberRuleVO>> search(SysNumberRuleQParam param) {
        PagingVO pageResult = this.sysNumberRuleRepoProc.queryForPage(param).map(CONVERT::doToVO);
        return ApiResult.ok((Object)pageResult);
    }

    public ApiResult<String> generateSampleCode(Long ruleId, List<String> runtimeValues) {
        String code = this.executeGenerateCode(ruleId, d -> 1L, runtimeValues);
        return ApiResult.ok((Object)code);
    }

    public ApiResult<String> generateSampleCode(String ruleCode, List<String> runtimeValues) {
        if (!StringUtils.hasText((String)ruleCode)) {
            return ApiResult.fail((String)"\u7f16\u53f7\u4e3a\u7a7a");
        }
        Long id = this.sysNumberRuleRepoProc.getIdByCode(ruleCode);
        if (id == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u53d1\u53f7\u89c4\u5219[" + ruleCode + "]");
        }
        return this.generateSampleCode(id, runtimeValues);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> generateCode(Long ruleId, List<String> runtimeValues) {
        String code = this.executeGenerateCode(ruleId, d -> this.sysNextNumberService.getNextNumber(d.getNumberPattern(), d.getNnLen()), runtimeValues);
        return ApiResult.ok((Object)code);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> generateCodes(Long ruleId, List<String> runtimeValues, String telhead) {
        String code = this.executeGenerateCodes(ruleId, d -> this.sysNextNumberService.getNextNumbers(d.getNumberPattern(), d.getNnLen(), telhead), runtimeValues);
        return ApiResult.ok((Object)code);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> generateCode(String ruleCode, List<String> runtimeValues) {
        Long id = this.sysNumberRuleRepoProc.getIdByCode(ruleCode);
        if (id == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u53d1\u53f7\u89c4\u5219[" + ruleCode + "]");
        }
        return this.generateCode(id, runtimeValues);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> generateCodes(String ruleCode, List<String> runtimeValues, String telhead) {
        Long id = this.sysNumberRuleRepoProc.getIdByCode(ruleCode);
        if (id == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u53d1\u53f7\u89c4\u5219[" + ruleCode + "]");
        }
        return this.generateCodes(id, runtimeValues, telhead);
    }

    public ApiResult<SysNumberRuleVO> oneCombined(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u89c4\u5219ID\u4e3a\u7a7a");
        }
        SysNumberRuleDO numberRule = (SysNumberRuleDO)this.sysNumberRuleRepoProc.get(id);
        if (numberRule == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SysNumberRuleVO ruleVO = CONVERT.doToVO(numberRule);
        List details = this.sysNumberRuleDtlService.listByRuleId(id);
        ruleVO.setRuleDetails((List)ObjectUtil.defaultIfNull((Object)details, Collections.emptyList()));
        return ApiResult.ok((Object)ruleVO);
    }

    private String executeGenerateCode(Long ruleId, Function<SysNumberRuleDtlDTO, Long> nextNumberFunction, List<String> runtimeValues) {
        if (ruleId == null) {
            throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219ID\u4e3a\u7a7a");
        }
        List ruleDetails = this.sysNumberRuleDtlRepoProc.queryByRuleId(ruleId);
        if (ruleDetails.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u53d1\u53f7\u89c4\u5219\u914d\u7f6e");
        }
        return this.executeGenerateCode(ruleId, ruleDetails, nextNumberFunction, runtimeValues);
    }

    private String executeGenerateCodes(Long ruleId, Function<SysNumberRuleDtlDTO, Long> nextNumberFunction, List<String> runtimeValues) {
        if (ruleId == null) {
            throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219ID\u4e3a\u7a7a");
        }
        List ruleDetails = this.sysNumberRuleDtlRepoProc.queryByRuleId(ruleId);
        if (ruleDetails.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u53d1\u53f7\u89c4\u5219\u914d\u7f6e");
        }
        return this.executeGenerateCodes(ruleId, ruleDetails, nextNumberFunction, runtimeValues);
    }

    private String executeGenerateCodes(@NonNull Long ruleId, @NonNull List<SysNumberRuleDtlDTO> ruleDetails, Function<SysNumberRuleDtlDTO, Long> nextNumberFunction, List<String> runtimeValues) {
        StringBuilder code = new StringBuilder();
        int offset = 0;
        block10: for (SysNumberRuleDtlDTO ruleDetail : ruleDetails) {
            Long nextNumber;
            Integer len;
            if (!StringUtils.hasText((String)ruleDetail.getNumberType())) {
                throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u53d6\u53f7\u7c7b\u578b\u4e3a\u7a7a");
            }
            LocalDateTime now = LocalDateTime.now();
            String pattern = ruleDetail.getNumberPattern();
            switch (ruleDetail.getNumberType()) {
                case "FS": {
                    if (!StringUtils.hasText((String)pattern)) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u56fa\u5b9a\u503c\u7684\u6a21\u5f0f\u4e3a\u7a7a");
                    }
                    code.append(pattern);
                    continue block10;
                }
                case "DP": {
                    if (!StringUtils.hasText((String)pattern)) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u65e5\u671f\u683c\u5f0f\u7684\u6a21\u5f0f\u4e3a\u7a7a");
                    }
                    code.append(FORMATTER_MAP.computeIfAbsent(pattern, DateTimeFormatter::ofPattern).format(now));
                    continue block10;
                }
                case "NN": {
                    len = ruleDetail.getNnLen();
                    if (len == null) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e3a\u7a7a");
                    }
                    nextNumber = nextNumberFunction.apply(ruleDetail);
                    code.append(this.preZero(nextNumber, len));
                    continue block10;
                }
            }
            if (runtimeValues == null || offset >= runtimeValues.size()) continue;
            if (CharSequenceUtil.equals((CharSequence)"NN", (CharSequence)pattern)) {
                len = ruleDetail.getNnLen();
                if (len == null) {
                    throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e3a\u7a7a");
                }
                nextNumber = this.sysNextNumberService.getNextNumberForRuntime(runtimeValues.get(offset), len);
                code.append(this.preZero(nextNumber, len));
            } else {
                code.append(runtimeValues.get(offset));
            }
            ++offset;
        }
        return code.toString();
    }

    private String executeGenerateCode(@NonNull Long ruleId, @NonNull List<SysNumberRuleDtlDTO> ruleDetails, Function<SysNumberRuleDtlDTO, Long> nextNumberFunction, List<String> runtimeValues) {
        StringBuilder code = new StringBuilder();
        int offset = 0;
        block10: for (SysNumberRuleDtlDTO ruleDetail : ruleDetails) {
            Long nextNumber;
            Integer len;
            if (!StringUtils.hasText((String)ruleDetail.getNumberType())) {
                throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u53d6\u53f7\u7c7b\u578b\u4e3a\u7a7a");
            }
            LocalDateTime now = LocalDateTime.now();
            String pattern = ruleDetail.getNumberPattern();
            switch (ruleDetail.getNumberType()) {
                case "FS": {
                    if (!StringUtils.hasText((String)pattern)) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u56fa\u5b9a\u503c\u7684\u6a21\u5f0f\u4e3a\u7a7a");
                    }
                    code.append(pattern);
                    continue block10;
                }
                case "DP": {
                    if (!StringUtils.hasText((String)pattern)) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u65e5\u671f\u683c\u5f0f\u7684\u6a21\u5f0f\u4e3a\u7a7a");
                    }
                    code.append(FORMATTER_MAP.computeIfAbsent(pattern, DateTimeFormatter::ofPattern).format(now));
                    continue block10;
                }
                case "NN": {
                    len = ruleDetail.getNnLen();
                    if (len == null) {
                        throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e3a\u7a7a");
                    }
                    nextNumber = nextNumberFunction.apply(ruleDetail);
                    code.append(this.preZero(nextNumber, len));
                    continue block10;
                }
            }
            if (runtimeValues == null || offset >= runtimeValues.size()) continue;
            if (CharSequenceUtil.equals((CharSequence)"NN", (CharSequence)pattern)) {
                len = ruleDetail.getNnLen();
                if (len == null) {
                    throw new BusinessException("\u53d1\u53f7\u5668\u89c4\u5219\u3010" + ruleId + "\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u81ea\u589e\u5e8f\u53f7\u5bbd\u5ea6\u4e3a\u7a7a");
                }
                nextNumber = this.sysNextNumberService.getNextNumberForRuntime(runtimeValues.get(offset), len);
                code.append(this.preZero(nextNumber, len));
            } else {
                code.append(runtimeValues.get(offset));
            }
            ++offset;
        }
        return code.toString();
    }

    private String preZero(long val, int len) {
        String format = "%0" + len + "d";
        return String.format(format, val);
    }
}

