/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.core.provider.tenant.TenantClientProvider;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysUdcConvert;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.model.entity.SysUdcDO;
import com.elitesland.yst.system.param.SysUdcQueryParam;
import com.elitesland.yst.system.repo.SysUdcRepo;
import com.elitesland.yst.system.repo.SysUdcRepoProc;
import com.elitesland.yst.system.service.ISysUdcService;
import com.elitesland.yst.system.service.SysUdcService;
import com.elitesland.yst.system.vo.SysUdcComboVO;
import com.elitesland.yst.system.vo.SysUdcVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ISysUdcServiceImpl
implements ISysUdcService {
    private static final SysUdcConvert CONVERT = SysUdcConvert.INSTANCE;
    @Autowired
    private SysUdcRepo sysUdcRepo;
    @Autowired
    private SysUdcRepoProc sysUdcRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    @Caching(evict={@CacheEvict(value={"udccodes"}, key="'codecombos-' + #code.domainCode + '-' + #code.udcCode"), @CacheEvict(value={"udccodes"}, key="'codemap-' + #code.domainCode + '-' + #code.udcCode"), @CacheEvict(value={"udccodes"}, key="'codemap-all'")})
    public ApiResult<Long> createCode(SysUdcVO code) {
        boolean exists = this.sysUdcRepoProc.exists(code.getDomainCode(), code.getUdcCode(), code.getUdcVal());
        if (exists) {
            return ApiResult.fail((String)(code.getDomainCode() + ":" + code.getUdcCode() + ":" + code.getUdcVal() + ", \u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0"));
        }
        if (code.getValSortNo() == null) {
            code.setValSortNo(Integer.valueOf(0));
        }
        SysUdcDO udcDO = CONVERT.voToDO(code);
        this.sysUdcRepo.save(udcDO);
        return ApiResult.ok((Object)udcDO.getId());
    }

    @Caching(evict={@CacheEvict(value={"udccodes"}, key="'codecombos-' + #code.domainCode + '-' + #code.udcCode"), @CacheEvict(value={"udccodes"}, key="'codemap-' + #code.domainCode + '-' + #code.udcCode"), @CacheEvict(value={"udccodes"}, key="'codemap-all'")})
    public ApiResult<Long> updateCode(SysUdcVO code) {
        SysUdcDO data = this.sysUdcRepoProc.get(code.getDomainCode(), code.getUdcCode(), code.getUdcVal());
        if (data == null) {
            return ApiResult.fail((String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        code.setId(data.getId());
        code.setCreateUserId(data.getCreateUserId());
        code.setCreateTime(data.getCreateTime());
        SysUdcDO dataNew = CONVERT.voToDO(code);
        this.sysUdcRepo.save(dataNew);
        return ApiResult.ok((Object)dataNew.getId());
    }

    @Transactional(rollbackOn={Exception.class})
    public ApiResult<Boolean> removeBySys(String sysCode) {
        if (!StringUtils.hasText((String)sysCode)) {
            return ApiResult.fail((String)"\u9886\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        this.sysUdcRepoProc.delete(sysCode, null, null);
        return ApiResult.ok((Object)true);
    }

    @Transactional(rollbackOn={Exception.class})
    public ApiResult<Boolean> removeByMod(String sysCode, String modCode) {
        if (!StringUtils.hasText((String)sysCode)) {
            return ApiResult.fail((String)"\u9886\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        this.sysUdcRepoProc.delete(sysCode, modCode, null);
        return ApiResult.ok((Object)true);
    }

    @Transactional(rollbackOn={Exception.class})
    public ApiResult<Boolean> removeByKey(String sysCode, String modCode, String key) {
        if (!StringUtils.hasText((String)sysCode)) {
            return ApiResult.fail((String)"\u9886\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        this.sysUdcRepoProc.delete(sysCode, modCode, key);
        return ApiResult.ok((Object)true);
    }

    @Transactional(rollbackOn={Exception.class})
    public ApiResult<Boolean> removeByIdInBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return ApiResult.fail((String)"\u9886\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        this.sysUdcRepoProc.delete(ids);
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Boolean> clearCache(Boolean all) {
        this.clearCache("udccodes*", all);
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Boolean> clearUdcCache(String domain, String udc, Boolean all) {
        String keyPattern = String.format("udccodescodecombos-%s-%s", domain, udc);
        this.clearCache(keyPattern, all);
        keyPattern = String.format("udccodescodemap-%s-%s", domain, udc);
        this.clearCache(keyPattern, all);
        return null;
    }

    public PagingVO<SysUdcVO> search(SysUdcQueryParam param) {
        return this.sysUdcRepoProc.queryByPage(param).map(CONVERT::doToVO);
    }

    public SysUdcVO findOneSysUdc(String domainCode, String udcCode, String udcVal) {
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{domainCode, udcCode, udcVal})) {
            throw new BusinessException("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        List<SysUdcDO> udcDOList = this.queryUdcList(domainCode, udcCode);
        if (udcDOList.isEmpty()) {
            return null;
        }
        for (SysUdcDO udcDO : udcDOList) {
            if (!CharSequenceUtil.equals((CharSequence)udcDO.getUdcVal(), (CharSequence)udcVal)) continue;
            return CONVERT.doToVO(udcDO);
        }
        return null;
    }

    public List<SysUdcComboVO> listSubCodeLike(String domain, String udcCode3, String udcName) {
        return this.sysUdcRepoProc.queryByUdcValue(domain, udcCode3, udcName).stream().map(CONVERT::codeToComboVo).collect(Collectors.toList());
    }

    public List<SysUdcComboVO> listCodeLike(String domain, String udcCode3, String udcName) {
        return this.sysUdcRepoProc.queryByUdcValueOrValDesc(domain, udcCode3, udcName).stream().map(CONVERT::codeToComboVo).collect(Collectors.toList());
    }

    public List<SysUdcComboVO> listCodeCombosValLike(String domain, String udc, String valDesc) {
        return this.sysUdcRepoProc.queryByUdcDesc(domain, udc, valDesc).stream().map(CONVERT::codeToComboVo).collect(Collectors.toList());
    }

    public Optional<SysUdcVO> findOneById(Long id) {
        return this.sysUdcRepo.findById(id).map(SysUdcConvert.INSTANCE::doToVO);
    }

    @Cacheable(value={"udccodes"}, key="'codecombos-' + #p0 + '-' + #p1")
    public List<SysUdcComboVO> listCodeCombos(String domain, String udc) {
        List<SysUdcDO> udcList = this.queryUdcList(domain, udc);
        if (udcList.isEmpty()) {
            return Collections.emptyList();
        }
        return CONVERT.codeToComboVo(udcList);
    }

    @Cacheable(value={"udccodes"}, key="'codemap-' + #p0 + '-' + #p1")
    public Map<String, String> getCodeMap(String domain, String udc) {
        List<SysUdcDO> udcList = this.queryUdcList(domain, udc);
        if (udcList.isEmpty()) {
            return Collections.emptyMap();
        }
        return udcList.stream().collect(Collectors.toMap(SysUdcDO::getUdcVal, SysUdcDO::getValDesc, (t1, t2) -> t1));
    }

    @Cacheable(value={"udccodes"}, key="'codemap-all'")
    public Map<String, String> getCodeMapAll() {
        List<SysUdcDO> udcDefaults = this.queryUdcList();
        if (udcDefaults.isEmpty()) {
            return Collections.emptyMap();
        }
        return udcDefaults.stream().collect(Collectors.toMap(sysUdcDO -> SysUdcService.combinationUdcKey((String)sysUdcDO.getDomainCode(), (String)sysUdcDO.getUdcCode(), (String)sysUdcDO.getUdcVal()), sysUdcComboVO -> sysUdcComboVO.getValDesc() == null ? "" : sysUdcComboVO.getValDesc()));
    }

    public List<SysUdcComboVO> findByUdcValues(List<String> udc) {
        if (CollectionUtils.isEmpty(udc)) {
            return Collections.emptyList();
        }
        List<SysUdcDO> udcList = this.queryUdcList(() -> this.sysUdcRepo.findAllByUdcValIn(udc), SysUdcDO::getUdcVal, null);
        if (udcList.isEmpty()) {
            return Collections.emptyList();
        }
        return CONVERT.codeToComboVo(udcList);
    }

    public List<SysUdcVO> findUdcByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<SysUdcDO> udcList = this.queryUdcList(() -> this.sysUdcRepoProc.get(ids), SysUdcDO::getUdcVal, null);
        if (udcList.isEmpty()) {
            return Collections.emptyList();
        }
        return CONVERT.codeToVo(udcList);
    }

    private List<SysUdcDO> queryUdcList(@NonNull String domain, @NonNull String udc) {
        Assert.hasText((String)domain, (String)"domain\u4e3a\u7a7a");
        Assert.hasText((String)udc, (String)"udc\u4e3a\u7a7a");
        return this.queryUdcList(() -> this.sysUdcRepoProc.queryUdc(domain, udc), SysUdcDO::getUdcVal, Comparator.comparingInt(t -> (Integer)ObjectUtil.defaultIfNull((Object)t.getValSortNo(), (Object)0)));
    }

    private List<SysUdcDO> queryUdcList() {
        return this.queryUdcList(() -> this.sysUdcRepoProc.all(), SysUdcDO::getUdcVal, null);
    }

    private <T> List<T> queryUdcList(@NonNull Supplier<List<T>> udcSupplier, @NonNull Function<T, String> selectStrategy, Comparator<T> comparator) {
        List udcDefault = null;
        try {
            udcDefault = (List)this.tenantDataIsolateProvider.byDefaultDirectly(udcSupplier::get);
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u9ed8\u8ba4UDC\u5931\u8d25", (Throwable)e);
        }
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            return udcDefault;
        }
        List udcTenant = null;
        try {
            udcTenant = (List)this.tenantDataIsolateProvider.byTenantDirectly(udcSupplier::get, tenant);
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u79df\u6237UDC\u5931\u8d25", (Throwable)e);
        }
        if (udcTenant.isEmpty()) {
            return udcDefault;
        }
        if (udcDefault.isEmpty()) {
            return udcTenant;
        }
        Map<String, Object> mapDefault = udcDefault.stream().collect(Collectors.toMap(selectStrategy, t -> t, (t1, t2) -> t1));
        Map<String, Object> mapTenant = udcTenant.stream().collect(Collectors.toMap(selectStrategy, t -> t, (t1, t2) -> t1));
        mapDefault.putAll(mapTenant);
        if (comparator != null) {
            return mapDefault.values().stream().sorted(comparator).collect(Collectors.toList());
        }
        return new ArrayList<Object>(mapDefault.values());
    }

    private void clearCache(String keyPattern, Boolean all) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.NOT_PERMISSION, "\u8bf7\u5148\u767b\u5f55");
        }
        if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                this.executeRedisCache(keyPattern);
                return null;
            });
            if (Boolean.TRUE.equals(all)) {
                this.tenantDataIsolateProvider.byAllTenant(() -> {
                    this.executeRedisCache(keyPattern);
                    return null;
                });
            }
            return;
        }
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            this.executeRedisCache(keyPattern);
            return null;
        }, currentUser.getTenant());
    }

    private void executeRedisCache(String keyPattern) {
        List keys = this.redisUtils.scan(keyPattern);
        if (keys.isEmpty()) {
            return;
        }
        this.redisUtils.getRedisTemplate().delete((Collection)keys);
    }
}

