/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.boot.elasticsearch.common.PageResult;
import com.elitesland.boot.elasticsearch.common.query.AggregationParam;
import com.elitesland.boot.elasticsearch.common.query.ConditionBuilder;
import com.elitesland.boot.elasticsearch.common.query.ElasticsearchQueryHelper;
import com.elitesland.boot.elasticsearch.common.query.QueryParam;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.constant.Terminal;
import com.elitesland.yst.system.entity.QSysUserDO;
import com.elitesland.yst.system.model.es.LoginLogDocument;
import com.elitesland.yst.system.repo.SysUserRepoProc;
import com.elitesland.yst.system.repo.es.LoginLogDocumentService;
import com.elitesland.yst.system.service.LoginLogService;
import com.elitesland.yst.system.service.vo.param.LoginLogQueryParamVO;
import com.elitesland.yst.system.service.vo.param.OnlineUserCountQueryParamVO;
import com.elitesland.yst.system.service.vo.resp.LoginLogRespVO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LoginLogServiceImpl
implements LoginLogService {
    private static final Logger log = LoggerFactory.getLogger(LoginLogServiceImpl.class);
    @Autowired
    private LoginLogDocumentService loginLogDocumentService;
    @Autowired
    private SysUserRepoProc sysUserRepoProc;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    private final ZoneOffset zoneOffset = ZoneOffset.ofHours(8);
    private static final QSysUserDO USER_DO = QSysUserDO.sysUserDO;

    public ApiResult<PagingVO<LoginLogRespVO>> query(LoginLogQueryParamVO queryParamVO) {
        Long userId = null;
        if (!StrUtil.isAllBlank((CharSequence[])new CharSequence[]{queryParamVO.getUsername(), queryParamVO.getMobile(), queryParamVO.getEmail()}) && (userId = this.queryUser(queryParamVO)) == null) {
            return ApiResult.ok((Object)PagingVO.builder().total(Long.valueOf(0L)).records(Collections.emptyList()).build());
        }
        ConditionBuilder filter = ElasticsearchQueryHelper.conditionBuilder(LoginLogDocument.class).and("userId", (Object)userId, userId != null).and("terminal", (Object)(queryParamVO.getTerminal() == null ? null : queryParamVO.getTerminal().toString()), queryParamVO.getTerminal() != null).andBetween("loginTime", (Object)queryParamVO.getTimeStart(), true, (Object)queryParamVO.getTimeEnd(), true);
        QueryParam queryParam = ElasticsearchQueryHelper.buildQuery(LoginLogDocument.class).withConditionFilter(filter).withPageRequest(queryParamVO.getPageRequest());
        PageResult queryResult = null;
        try {
            queryResult = this.loginLogDocumentService.documentQuery(queryParam);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u767b\u5f55\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            return ApiResult.fail((String)"\u67e5\u8be2\u65e5\u5fd7\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u670d\u52a1\u6b63\u5e38");
        }
        if (CollUtil.isEmpty((Collection)queryResult.getRecordList())) {
            return ApiResult.ok((Object)PagingVO.builder().total(Long.valueOf(queryResult.getTotal())).records(Collections.emptyList()).build());
        }
        Set<Long> userIds = userId == null ? queryResult.getRecordList().stream().map(LoginLogDocument::getUserId).collect(Collectors.toSet()) : Set.of(userId);
        Map<Long, Tuple> userInfoMap = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{LoginLogServiceImpl.USER_DO.id, LoginLogServiceImpl.USER_DO.username, LoginLogServiceImpl.USER_DO.firstName, LoginLogServiceImpl.USER_DO.lastName, LoginLogServiceImpl.USER_DO.mobile, LoginLogServiceImpl.USER_DO.email}).from((EntityPath)USER_DO)).where((Predicate)LoginLogServiceImpl.USER_DO.id.in(userIds))).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Expression)LoginLogServiceImpl.USER_DO.id), t -> t, (t1, t2) -> t1));
        List respVoList = queryResult.getRecordList().stream().map(t -> {
            LoginLogRespVO respVO = new LoginLogRespVO();
            respVO.setUserId(t.getUserId());
            Tuple userInfo = (Tuple)userInfoMap.get(t.getUserId());
            if (userInfo != null) {
                respVO.setUsername((String)userInfo.get((Expression)LoginLogServiceImpl.USER_DO.username));
                respVO.setMobile((String)userInfo.get((Expression)LoginLogServiceImpl.USER_DO.mobile));
                respVO.setEmail((String)userInfo.get((Expression)LoginLogServiceImpl.USER_DO.email));
                respVO.setLastName((String)userInfo.get((Expression)LoginLogServiceImpl.USER_DO.lastName));
                respVO.setFirstName((String)userInfo.get((Expression)LoginLogServiceImpl.USER_DO.firstName));
            }
            respVO.setTerminal(t.getTerminal());
            if (StrUtil.isNotBlank((CharSequence)t.getTerminal())) {
                respVO.setTerminalName(Terminal.valueOf((String)t.getTerminal()).name());
            }
            respVO.setLoginTime(t.getLoginTime());
            respVO.setLoginIp(t.getLoginIp());
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)PagingVO.builder().total(Long.valueOf(queryResult.getTotal())).records(respVoList).build());
    }

    public ApiResult<Long> countUser(OnlineUserCountQueryParamVO queryParamVO) {
        String base = (String)ObjectUtil.defaultIfBlank((CharSequence)queryParamVO.getBase(), (CharSequence)"visitor");
        long count = 0L;
        switch (base) {
            case "visitor": {
                count = this.countUserByVisitor(queryParamVO);
                break;
            }
            case "login": {
                count = this.countUserByLogin(queryParamVO);
                break;
            }
            default: {
                return ApiResult.fail((String)"\u672a\u77e5\u7c7b\u578b");
            }
        }
        return ApiResult.ok((Object)count);
    }

    private Long countUserByVisitor(OnlineUserCountQueryParamVO queryParamVO) {
        Set result;
        if (queryParamVO.getTimeStart() == null && queryParamVO.getTimeEnd() == null) {
            Long count = this.redisTemplate.opsForZSet().size((Object)"yst_online_user_set");
            return (Long)ObjectUtil.defaultIfNull((Object)count, (Object)0L);
        }
        long start = 0L;
        if (queryParamVO.getTimeStart() != null) {
            start = queryParamVO.getTimeStart().toEpochSecond(this.zoneOffset);
        }
        long end = 0L;
        if (queryParamVO.getTimeEnd() == null) {
            queryParamVO.setTimeEnd(LocalDateTime.now());
            end = queryParamVO.getTimeEnd().toEpochSecond(this.zoneOffset);
        }
        return (result = this.redisTemplate.opsForZSet().rangeByScore((Object)"yst_online_user_set", (double)start, (double)end)) == null ? 0L : (long)result.size();
    }

    private long countUserByLogin(OnlineUserCountQueryParamVO queryParamVO) {
        ConditionBuilder filter = null;
        if (queryParamVO.getTimeStart() != null || queryParamVO.getTimeEnd() != null) {
            filter = ElasticsearchQueryHelper.conditionBuilder(LoginLogDocument.class).andBetween("loginTime", (Object)queryParamVO.getTimeStart(), true, (Object)queryParamVO.getTimeEnd(), true);
        }
        String aggName = "userCount";
        CardinalityAggregationBuilder aggBuilder = ((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)aggName).field("userId")).precisionThreshold(40000L);
        AggregationParam queryParam = ElasticsearchQueryHelper.buildAggregation(LoginLogDocument.class).withConditionFilter(filter).withAggregationBuilder((AbstractAggregationBuilder)aggBuilder);
        Aggregations aggregations = this.loginLogDocumentService.aggregationSearch(queryParam);
        return ((ParsedCardinality)aggregations.get(aggName)).getValue();
    }

    private Long queryUser(LoginLogQueryParamVO queryParamVO) {
        Long userId = null;
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getUsername()) && (userId = this.sysUserRepoProc.getIdByUsername(queryParamVO.getUsername())) != null) {
            return userId;
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getMobile()) && (userId = this.sysUserRepoProc.getIdByMobile(queryParamVO.getMobile())) != null) {
            return userId;
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getEmail()) && (userId = this.sysUserRepoProc.getIdByEmail(queryParamVO.getEmail())) != null) {
            return userId;
        }
        return null;
    }
}

