/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.service.entity.SysNextNumberDO;
import com.elitesland.yst.system.service.repo.SysNextNumberRepo;
import com.elitesland.yst.system.service.repo.SysNextNumberRepoProc;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NextNumberCreatorFactory {
    @Autowired
    private SysNextNumberRepo sysNextNumberRepo;
    @Autowired
    private SysNextNumberRepoProc sysNextNumberRepoProc;

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long nextNumber(String code, Integer nnLen) {
        SysNextNumberDO nextNumberDO = this.sysNextNumberRepoProc.getByCode(code);
        if (nextNumberDO == null) {
            throw new BusinessException("\u672a\u627e\u5230\u53d1\u53f7\u5668\u914d\u7f6e\u7684\u4e0b\u4e00\u7f16\u53f7[" + code + "]");
        }
        LocalDateTime nowTime = LocalDateTime.now();
        Long nextNumber = this.generateNextNumber(nextNumberDO, nnLen, nowTime);
        nextNumberDO.setNextNumber(Long.valueOf(nextNumber + (long)(nextNumberDO.getStep() == null || nextNumberDO.getStep() <= 0 ? 1 : nextNumberDO.getStep()))).setNnTime(nowTime);
        this.sysNextNumberRepo.save((Object)nextNumberDO);
        return nextNumber;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long nextNumbers(String code, Integer nnLen, String telHead) {
        SysNextNumberDO nextNumberDO = this.sysNextNumberRepoProc.getByCode(code + telHead);
        if (nextNumberDO == null) {
            nextNumberDO = this.sysNextNumberRepoProc.getByCode(code);
            nextNumberDO.setId(null);
            nextNumberDO.setNextNumber(Long.valueOf(1L));
            nextNumberDO.setCode(nextNumberDO.getCode() + telHead);
            nextNumberDO.setName(nextNumberDO.getName() + telHead);
            nextNumberDO.setNextNumber(Long.valueOf(1L));
        }
        LocalDateTime nowTime = LocalDateTime.now();
        Long nextNumber = this.generateNextNumber(nextNumberDO, nnLen, nowTime);
        nextNumberDO.setNextNumber(Long.valueOf(nextNumber + (long)(nextNumberDO.getStep() == null || nextNumberDO.getStep() <= 0 ? 1 : nextNumberDO.getStep()))).setNnTime(nowTime);
        this.sysNextNumberRepo.save((Object)nextNumberDO);
        return nextNumber;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void createNumber(String code) {
        SysNextNumberDO nextNumber = new SysNextNumberDO();
        nextNumber.setCode(code);
        nextNumber.setName("RVNN\uff1a" + code);
        nextNumber.setNumberClass("SYS");
        nextNumber.setStep(Integer.valueOf(1));
        nextNumber.setNextNumber(Long.valueOf(1L));
        this.sysNextNumberRepo.saveAndFlush((Object)nextNumber);
    }

    private Long generateNextNumber(SysNextNumberDO nextNumberDO, Integer nnLen, LocalDateTime nowTime) {
        if (CharSequenceUtil.isNotBlank((CharSequence)nextNumberDO.getNnPeriod()) && nextNumberDO.getNnTime() != null) {
            switch (nextNumberDO.getNnPeriod()) {
                case "D": {
                    int nowD = nowTime.getDayOfYear();
                    int nnD = nextNumberDO.getNnTime().getDayOfYear();
                    if (nowD - nnD > 0) {
                        return 1L;
                    }
                    return nextNumberDO.getNextNumber();
                }
                case "W": {
                    DayOfWeek nowTimeDayOfWeek = nowTime.getDayOfWeek();
                    DayOfWeek nextNumberDayOfWeek = nextNumberDO.getNnTime().getDayOfWeek();
                    if (nowTime.getYear() != nextNumberDO.getNnTime().getYear() || nowTimeDayOfWeek == DayOfWeek.MONDAY && nowTimeDayOfWeek != nextNumberDayOfWeek) {
                        return 1L;
                    }
                    return nextNumberDO.getNextNumber();
                }
                case "M": {
                    if (nowTime.getMonthValue() != nextNumberDO.getNnTime().getMonthValue()) {
                        return 1L;
                    }
                    return nextNumberDO.getNextNumber();
                }
                case "Y": {
                    if (nowTime.getYear() != nextNumberDO.getNnTime().getYear()) {
                        return 1L;
                    }
                    return nextNumberDO.getNextNumber();
                }
            }
            return nextNumberDO.getNextNumber();
        }
        if ((double)nextNumberDO.getNextNumber().longValue() >= Math.pow(10.0, nnLen.intValue())) {
            return 1L;
        }
        return nextNumberDO.getNextNumber();
    }
}

