/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.metadata.rpcservice.MetaColumnRpcService;
import com.elitesland.yst.system.convert.SysBizDataConstraintConvert;
import com.elitesland.yst.system.model.entity.SysBizDataConstraintDO;
import com.elitesland.yst.system.param.SysBizDataConstraintSaveParam;
import com.elitesland.yst.system.repo.SysBizDataConstraintRepo;
import com.elitesland.yst.system.repo.SysDataRoleRepoProc;
import com.elitesland.yst.system.service.SysBizDataConstraintService;
import com.elitesland.yst.system.vo.SysBizDataConstraintVO;
import com.elitesland.yst.system.vo.SysDataRoleVO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysBizDataConstraintServiceImpl
implements SysBizDataConstraintService {
    private static final Logger log = LoggerFactory.getLogger(SysBizDataConstraintServiceImpl.class);
    private MetaColumnRpcService metaColumnRpcService;
    private SysBizDataConstraintRepo sysBizDataConstraintRepo;
    private SysDataRoleRepoProc sysDataRoleRepoProc;

    @Autowired
    public void setSysDataRoleRepoProc(SysDataRoleRepoProc sysDataRoleRepoProc) {
        this.sysDataRoleRepoProc = sysDataRoleRepoProc;
    }

    @DubboReference(version="${provider.service.version}", check=false)
    public void setMetaColumnRpcService(MetaColumnRpcService metaColumnRpcService) {
        this.metaColumnRpcService = metaColumnRpcService;
    }

    @Autowired
    public void setSysBizDataConstraintRepo(SysBizDataConstraintRepo sysBizDataConstraintRepo) {
        this.sysBizDataConstraintRepo = sysBizDataConstraintRepo;
    }

    public List<SysBizDataConstraintVO> listByRoleCode(String roleCode) {
        return this.sysBizDataConstraintRepo.findAllByDataRoleCode(roleCode).stream().map(SysBizDataConstraintConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public Optional<SysDataRoleVO> findOneByCode(String roleCode) {
        return Optional.ofNullable(this.sysDataRoleRepoProc.findDataRoleByCode(roleCode));
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer updateInBatch(String sysDataRoleCode, List<SysBizDataConstraintSaveParam> params) {
        AtomicInteger rowAffected = new AtomicInteger();
        this.findOneByCode(sysDataRoleCode).ifPresentOrElse(r -> {
            List metaColumnIds = params.stream().map(SysBizDataConstraintSaveParam::getMetaColumnId).collect(Collectors.toList());
            List metaColumns = this.metaColumnRpcService.findAllByIds(metaColumnIds);
            List constraints = params.stream().map(p -> metaColumns.stream().filter(c -> c.getId().equals(p.getMetaColumnId())).findFirst().map(cc -> new SysBizDataConstraintDO().setDataRoleCode(sysDataRoleCode).setDataRoleName(r.getName()).setDomainCode(cc.getDomainCode()).setDomainName(cc.getDomainName()).setTableCode(cc.getTableCode()).setTableName(cc.getTableName()).setFieldCode(cc.getFieldCode()).setFieldCaption(cc.getFieldCaption()).setFieldType(cc.getFieldType()).setFieldUdcType(cc.getFieldUdcType()).setUdcDomainCode(cc.getUdcDomainCode()).setUdcCode(cc.getUdcCode()).setDefaultValue(cc.getDefaultValue()).setCompareOpCode(p.getCompareOpCode()).setCompareOpName(p.getCompareOpName()).setConstraintValues(p.getConstraintValues())).orElse(null)).filter(c -> !Objects.isNull(c)).collect(Collectors.toList());
            this.sysBizDataConstraintRepo.deleteAllByDataRoleCode(sysDataRoleCode);
            if (constraints.isEmpty()) {
                log.warn("\u5168\u90e8\u5220\u9664\uff0c\u4e0d\u6267\u884c\u6dfb\u52a0 constraints null- sysDataRoleCode:" + sysDataRoleCode + ",metaColumns" + metaColumns);
            } else {
                this.sysBizDataConstraintRepo.saveAll(constraints);
            }
            rowAffected.set(constraints.size());
        }, () -> {
            throw new BusinessException("\u672a\u627e\u5230\u7f16\u7801\u4e3a\uff1a" + sysDataRoleCode + ", \u7684\u6570\u636e\u89d2\u8272\u8bb0\u5f55");
        });
        return rowAffected.get();
    }
}

