/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.model.entity.QSysButableDO;
import com.elitesland.yst.system.model.entity.SysButableDO;
import com.elitesland.yst.system.param.SysButableQParam;
import com.elitesland.yst.system.repo.SysButableRepo;
import com.elitesland.yst.system.service.SysButableService;
import com.elitesland.yst.system.vo.SysTableVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="${provider.service.version}")
@UnicomTag(value="GENERAL")
public class SysButableServiceImpl
implements SysButableService {
    private SysButableRepo sysButableRepo;
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public void setSysButableRepo(SysButableRepo sysButableRepo) {
        this.sysButableRepo = sysButableRepo;
    }

    @Autowired
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<SysTableVO> listButable() {
        List ous = this.jdbcTemplate.query("SELECT id, butable_name, use_null FROM sys_butable where delete_flag=0", (resultSet, rowNum) -> new SysTableVO().setId(Long.valueOf(resultSet.getLong("id"))).setButableName(resultSet.getString("butable_name")).setUseNull(Integer.valueOf(resultSet.getInt("use_null"))));
        return ous;
    }

    public PagingVO<SysTableVO> search(SysButableQParam param) {
        QSysButableDO sysButableDO = QSysButableDO.sysButableDO;
        BooleanExpression predicate = sysButableDO.isNotNull().or((Predicate)sysButableDO.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getButableName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)sysButableDO.butableName.like("%" + param.getButableName() + "%"));
        predicate = param.getUseNull() == null ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)sysButableDO.useNull.eq((Object)param.getUseNull()));
        predicate = param.getDeleteFlag() == null ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)sysButableDO.deleteFlag.eq((Object)param.getDeleteFlag()));
        Page records = this.sysButableRepo.findAll((Predicate)predicate, (Pageable)param.getPageRequest());
        List doList = records.getContent();
        ArrayList<SysTableVO> contentList = new ArrayList<SysTableVO>();
        if (doList != null && !doList.isEmpty()) {
            for (SysButableDO sbd : doList) {
                SysTableVO sysTableVO = new SysTableVO();
                BeanUtils.copyProperties((Object)sbd, (Object)sysTableVO);
                contentList.add(sysTableVO);
            }
        }
        PagingVO pagevo = new PagingVO();
        pagevo.setTotal(Long.valueOf(records.getTotalElements()));
        pagevo.setRecords(contentList);
        return pagevo;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long create(SysTableVO sysTableVO) {
        SysButableDO sysButableDO = new SysButableDO();
        BeanUtils.copyProperties((Object)sysTableVO, (Object)sysButableDO);
        sysButableDO = (SysButableDO)this.sysButableRepo.save(sysButableDO);
        return sysButableDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SysTableVO sysTableVO) {
        Optional buOpt = this.sysButableRepo.findById(sysTableVO.getId());
        if (buOpt.isEmpty()) {
            throw new BusinessException("\u5f85\u66f4\u65b0\u7684\u6570\u636e\u6743\u9650\u4e0d\u5b58\u5728");
        }
        SysButableDO butable = (SysButableDO)buOpt.get();
        butable.setButableName(sysTableVO.getButableName());
        butable.setUseNull(sysTableVO.getUseNull());
        this.sysButableRepo.save(butable);
    }

    public void logicDelete(Long id) {
        Optional buOpt = this.sysButableRepo.findById(id);
        if (buOpt.isEmpty()) {
            throw new BusinessException("\u5f85\u5220\u9664\u7684\u6570\u636e\u6743\u9650\u4e0d\u5b58\u5728");
        }
        SysButableDO butable = (SysButableDO)buOpt.get();
        butable.setDeleteFlag(1);
        this.sysButableRepo.save(butable);
    }

    public Optional<SysTableVO> findOneById(Long id) {
        Optional buOpt = this.sysButableRepo.findById(id);
        if (buOpt.isEmpty()) {
            throw new BusinessException("\u83b7\u53d6\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        SysButableDO butable = (SysButableDO)buOpt.get();
        SysTableVO sysTableVO = new SysTableVO();
        BeanUtils.copyProperties((Object)butable, (Object)sysTableVO);
        return Optional.of(sysTableVO);
    }
}

