/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.common.RoleWhiteListEnum;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysFlowRoleConvert;
import com.elitesland.yst.system.model.entity.SysFlowRoleDO;
import com.elitesland.yst.system.provider.dto.SysFlowRoleDTO;
import com.elitesland.yst.system.repo.SysFlowRoleRepo;
import com.elitesland.yst.system.repo.SysFlowRoleRepoProc;
import com.elitesland.yst.system.repo.SysUserFlowRoleRepoProc;
import com.elitesland.yst.system.service.ISysFlowRoleService;
import com.elitesland.yst.system.service.param.SysFlowRoleBatchSwitchParam;
import com.elitesland.yst.system.service.param.SysFlowRolePagingParam;
import com.elitesland.yst.system.service.param.SysFlowRoleSaveParam;
import com.elitesland.yst.system.service.vo.SysFlowRoleDetailsVO;
import com.elitesland.yst.system.service.vo.SysFlowRolePagingVO;
import com.elitesland.yst.system.service.vo.SysFlowRoleSelectVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class SysFlowRoleServiceImpl
implements ISysFlowRoleService {
    private final SysFlowRoleRepo sysFlowRoleRepo;
    private final SysFlowRoleRepoProc sysFlowRoleRepoProc;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final SysUserFlowRoleRepoProc sysUserFlowRoleRepoProc;

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public PagingVO<SysFlowRolePagingVO> sysFlowRolePagingSearch(SysFlowRolePagingParam param) {
        return this.sysFlowRoleRepoProc.findPaging(param);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public SysFlowRoleDetailsVO findDetailsById(Long id) {
        return this.sysFlowRoleRepoProc.findDetailsById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Long flowRoleSaveOrUpdate(SysFlowRoleSaveParam param) {
        SysFlowRoleDO sysFlowRoleDO;
        if (param.getId() == null) {
            if (this.sysFlowRoleRepo.existsByCode(param.getCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u89d2\u8272\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            if (this.sysFlowRoleRepo.existsByName(param.getName())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            sysFlowRoleDO = SysFlowRoleConvert.INSTANCE.saveParamToDo(param);
        } else {
            Optional optional = this.sysFlowRoleRepo.findById(param.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6d41\u7a0b\u89d2\u8272");
            }
            sysFlowRoleDO = (SysFlowRoleDO)optional.get();
            if (this.sysFlowRoleRepo.existsByCodeAndIdNot(param.getCode(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u89d2\u8272\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            if (this.sysFlowRoleRepo.existsByNameAndIdNot(param.getName(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            SysFlowRoleConvert.INSTANCE.updateSaveParamToDo(param, sysFlowRoleDO);
        }
        this.sysFlowRoleRepo.save(sysFlowRoleDO);
        return sysFlowRoleDO.getId();
    }

    public List<SysFlowRoleSelectVO> findFlowRoleSelectVoAll() {
        return this.sysFlowRoleRepoProc.findSelectVoAll();
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysFlowRoleSelectVO> listAllByPermission() {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return Collections.emptyList();
        }
        List<SysFlowRoleSelectVO> roles = this.findFlowRoleSelectVoAll();
        if (roles.isEmpty()) {
            return roles;
        }
        Set<String> noPermissionRoles = this.rolesOfNoPermission(currentUser.getUser());
        for (SysFlowRoleSelectVO role : roles) {
            role.setNoPermission(Boolean.valueOf(noPermissionRoles.contains(role.getCode())));
        }
        return roles;
    }

    public Set<String> rolesOfNoPermission(SysUserDTO user) {
        Set allRoleCodes = RoleWhiteListEnum.getAllCode();
        if (user == null) {
            return allRoleCodes;
        }
        List<String> userRoleCodes = this.sysUserFlowRoleRepoProc.queryRoleCodeByUserId(user.getId());
        if (userRoleCodes.isEmpty()) {
            return allRoleCodes;
        }
        return allRoleCodes.stream().filter(t -> !userRoleCodes.contains(t)).collect(Collectors.toSet());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void batchSwitchEnable(SysFlowRoleBatchSwitchParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIds()) || param.getEnabled() == null) {
            return;
        }
        List<Long> ids = param.getIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.sysFlowRoleRepoProc.updateStatusByIds(param.getEnabled(), ids);
    }

    public Map<String, Long> getIdByName(Set<String> names) {
        if (CollUtil.isEmpty(names)) {
            return Collections.emptyMap();
        }
        return this.sysFlowRoleRepoProc.getIdByName(names);
    }

    public Map<String, Long> getIdByCode(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return Collections.emptyMap();
        }
        return this.sysFlowRoleRepoProc.getIdByCode(codes);
    }

    public List<SysFlowRoleDTO> getById(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.sysFlowRoleRepoProc.queryById(ids);
    }

    public List<SysFlowRoleDTO> getByCode(List<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return Collections.emptyList();
        }
        return this.sysFlowRoleRepoProc.queryByCode(codes);
    }

    public SysFlowRoleServiceImpl(SysFlowRoleRepo sysFlowRoleRepo, SysFlowRoleRepoProc sysFlowRoleRepoProc, TenantDataIsolateProvider tenantDataIsolateProvider, SysUserFlowRoleRepoProc sysUserFlowRoleRepoProc) {
        this.sysFlowRoleRepo = sysFlowRoleRepo;
        this.sysFlowRoleRepoProc = sysFlowRoleRepoProc;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
        this.sysUserFlowRoleRepoProc = sysUserFlowRoleRepoProc;
    }
}

