/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysFrontConfigConvert;
import com.elitesland.yst.system.model.entity.SysFrontConfigDO;
import com.elitesland.yst.system.repo.SysFrontConfigRepo;
import com.elitesland.yst.system.repo.SysFrontConfigRepoProc;
import com.elitesland.yst.system.service.SysFrontConfigService;
import com.elitesland.yst.system.service.param.SysFrontConfigSaveParam;
import com.elitesland.yst.system.service.vo.SysFrontConfigSimpleVO;
import com.elitesland.yst.system.service.vo.SysFrontConfigVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysFrontConfigServiceImpl
implements SysFrontConfigService {
    private final SysFrontConfigRepo sysFrontConfigRepo;
    private final SysFrontConfigRepoProc sysFrontConfigRepoProc;

    public List<SysFrontConfigSimpleVO> findSimpleListByRoleAndPermission(Long roleId, Long permissionId) {
        return this.sysFrontConfigRepoProc.findListByRoleAndPermission(roleId, permissionId);
    }

    public SysFrontConfigVO findConfigByRoleIdAndCode(Long roleId, String configCode) {
        return this.sysFrontConfigRepoProc.findVoByRoleIdAndCode(roleId, configCode);
    }

    public SysFrontConfigVO findConfigByCode(String configCode) {
        GeneralUserDetails generalUser = SecurityUtil.getUser();
        if (generalUser == null || generalUser.getUser() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f");
        }
        SysUserDTO user = generalUser.getUser();
        List<Long> roleIds = user.getRoles().stream().map(SysRoleVO::getId).collect(Collectors.toList());
        List<SysFrontConfigVO> configVos = this.sysFrontConfigRepoProc.findVoByRoleIdAndConfigCode(roleIds, configCode);
        return CollectionUtils.isEmpty(configVos) ? null : configVos.get(0);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long save(SysFrontConfigSaveParam param) {
        SysFrontConfigDO sysFrontConfigDO;
        if (param.getId() == null) {
            if (this.sysFrontConfigRepo.existsByRoleIdAndConfigCode(param.getRoleId(), param.getConfigCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u914d\u7f6e\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            sysFrontConfigDO = SysFrontConfigConvert.INSTANCE.saveParamToDo(param);
        } else {
            Optional optional = this.sysFrontConfigRepo.findById(param.getId());
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u6307\u5b9a\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            sysFrontConfigDO = (SysFrontConfigDO)optional.get();
            if (this.sysFrontConfigRepo.existsByRoleIdAndConfigCodeAndIdNot(param.getRoleId(), param.getConfigCode(), param.getId())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u914d\u7f6e\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            SysFrontConfigConvert.INSTANCE.updateDoFromParam(param, sysFrontConfigDO);
        }
        this.sysFrontConfigRepo.save(sysFrontConfigDO);
        return sysFrontConfigDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeById(Long id) {
        this.sysFrontConfigRepo.deleteById(id);
    }

    public SysFrontConfigServiceImpl(SysFrontConfigRepo sysFrontConfigRepo, SysFrontConfigRepoProc sysFrontConfigRepoProc) {
        this.sysFrontConfigRepo = sysFrontConfigRepo;
        this.sysFrontConfigRepoProc = sysFrontConfigRepoProc;
    }
}

