/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.repo.SysPermissionRepo;
import com.elitesland.yst.system.util.FrontRoute;
import com.elitesland.yst.system.util.FrontRouterParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysFrontRouterGenerator {
    private final SysPermissionRepo sysPermissionRepo;

    @Transactional(rollbackFor={Exception.class})
    public void frontRouterGenerator(FrontRouterParam param) {
        ArrayList<SysPermissionDO> routeDos = new ArrayList<SysPermissionDO>();
        List<FrontRoute> rootRoutes = param.getRoutes();
        Long id = 101L;
        Long parentId = 0L;
        int sortNo = 1;
        String path = "/";
        int level = 1;
        for (FrontRoute rootRoute : rootRoutes) {
            routeDos.add(this.buildDo(rootRoute, id, parentId, path, sortNo, level));
            if (CollectionUtils.isNotEmpty(rootRoute.getRoutes())) {
                this.findRouters(id, path, level + 1, routeDos, rootRoute.getRoutes());
            }
            id = id + 1L;
            ++sortNo;
        }
        this.sysPermissionRepo.saveAll(routeDos);
    }

    private void findRouters(Long parentId, String parentPath, int level, List<SysPermissionDO> routerDos, List<FrontRoute> routers) {
        int sortNo = 1;
        Long id = Long.valueOf(parentId.toString() + "001");
        String path = parentPath + parentId + "/";
        for (FrontRoute router : routers) {
            routerDos.add(this.buildDo(router, id, parentId, path, sortNo, level));
            if (CollectionUtils.isNotEmpty(router.getRoutes())) {
                this.findRouters(id, path, level + 1, routerDos, router.getRoutes());
            }
            id = id + 1L;
            ++sortNo;
        }
    }

    private SysPermissionDO buildDo(FrontRoute router, Long id, Long parentId, String path, int sortNo, int level) {
        SysPermissionDO routeDo = new SysPermissionDO();
        routeDo.setId(id);
        routeDo.setCode(router.getName());
        routeDo.setName(router.getMeta().getTitle());
        routeDo.setParentId(parentId);
        routeDo.setPath(path);
        routeDo.setPattern(router.getPath());
        routeDo.setPermType(0);
        routeDo.setSortNo(sortNo);
        routeDo.setPermLevel(level);
        routeDo.setMenuDepth(level);
        return routeDo;
    }

    public SysFrontRouterGenerator(SysPermissionRepo sysPermissionRepo) {
        this.sysPermissionRepo = sysPermissionRepo;
    }
}

