/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.system.model.entity.QSysPermissionDO;
import com.elitesland.yst.system.model.entity.QSysRoleDO;
import com.elitesland.yst.system.model.entity.QSysRolePermissionDO;
import com.elitesland.yst.system.vo.SysPermissionWithRoleVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SysPermissionCacheManager {
    private static final Logger log = LoggerFactory.getLogger(SysPermissionCacheManager.class);
    private static final int LOCK_TIMEOUT = 10000;
    private static final int SLEEP_TIME = 5000;
    private final JPAQueryFactory jpaQueryFactory;
    private final RedisUtils redisUtils;
    private final Lock lock = new ReentrantLock();

    @Deprecated
    @Async
    public void refreshCacheOfAllPermissionsWithRoles() {
        log.info("[SysPermissionCacheManager] - \u5f02\u6b65\u5237\u65b0\u6743\u9650\u7f13\u5b58\uff0cStart");
        try {
            if (!this.lock.tryLock(10000L, TimeUnit.MILLISECONDS)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u83b7\u53d6\u66f4\u65b0\u6743\u9650\u89d2\u8272\u7f13\u5b58\u9501\u8d85\u65f6");
            }
            Thread.sleep(5000L);
            QSysPermissionDO permTable = QSysPermissionDO.sysPermissionDO;
            QSysRoleDO roleTable = QSysRoleDO.sysRoleDO;
            QSysRolePermissionDO rolePermTable = QSysRolePermissionDO.sysRolePermissionDO;
            List permissionsWithRoles = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysPermissionWithRoleVO.class, (Expression[])new Expression[]{permTable.id, permTable.parentId, roleTable.code.as("roleCode"), permTable.code, permTable.name, permTable.permType, permTable.pattern, permTable.sortNo, permTable.httpMethod, permTable.terminalCode, permTable.isQuick, permTable.isHidden})).from((EntityPath)permTable)).leftJoin((EntityPath)rolePermTable)).on((Predicate)permTable.id.eq(rolePermTable.permissionId))).leftJoin((EntityPath)roleTable)).on((Predicate)roleTable.id.eq(rolePermTable.roleId).and((Predicate)roleTable.enabled.eq(Boolean.valueOf(true))))).fetch();
            this.redisUtils.set("sys_all_permissions_roles", (Object)permissionsWithRoles);
            Long version = Instant.now().getEpochSecond();
            this.redisUtils.set("sys_all_permissions_roles_version", (Object)version);
            log.info("[SysPermissionCacheManager] - \u66f4\u65b0\u540e\u7684\u6743\u9650\u7f13\u5b58\u7248\u672c\u4e3a\uff1a" + version);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u66f4\u65b0\u6743\u9650\u89d2\u8272\u7f13\u5b58\u9501\u5f02\u5e38.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u83b7\u53d6\u66f4\u65b0\u6743\u9650\u89d2\u8272\u7f13\u5b58\u9501\u5f02\u5e38: " + e.getMessage());
        }
        catch (Exception e) {
            log.error("Fail to refresh SysPermissionWithRoleVO redis cache.", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u66f4\u65b0\u6743\u9650\u89d2\u8272\u7f13\u5b58\u5931\u8d25");
        }
        finally {
            this.lock.unlock();
            log.info("[SysPermissionCacheManager] - \u5f02\u6b65\u5237\u65b0\u6743\u9650\u7f13\u5b58\uff0cEnd");
        }
    }

    public SysPermissionCacheManager(JPAQueryFactory jpaQueryFactory, RedisUtils redisUtils) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.redisUtils = redisUtils;
    }
}

