/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysPermissionConvert;
import com.elitesland.yst.system.manager.UserPermissionManager;
import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.param.SysPermissionNewParam;
import com.elitesland.yst.system.param.SysPermissionUpdateParam;
import com.elitesland.yst.system.repo.SysPermissionRepo;
import com.elitesland.yst.system.repo.SysPermissionRepoProc;
import com.elitesland.yst.system.repo.SysRolePermissionRepo;
import com.elitesland.yst.system.service.ISysPermissionService;
import com.elitesland.yst.system.service.impl.SysPermissionCacheManager;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.vo.AntTreeNode;
import com.elitesland.yst.system.vo.SysPermissionVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class SysPermissionServiceImpl
implements ISysPermissionService {
    private static final Logger log = LoggerFactory.getLogger(SysPermissionServiceImpl.class);
    private static final SysPermissionConvert CONVERT = SysPermissionConvert.INSTANCE;
    private static final String MENU_CACHE = "MENU_CACHE";
    private static final Long FIXED_ROOT_ID = 0L;
    @Autowired
    private SysPermissionRepo sysPermissionRepo;
    @Autowired
    private SysRolePermissionRepo sysRolePermissionRepo;
    @Autowired
    private SysPermissionRepoProc sysPermissionRepoProc;
    @Autowired
    private SysPermissionCacheManager sysPermissionCacheManager;
    @Autowired
    private UserPermissionManager userPermissionManager;

    @CacheEvict(cacheNames={"MENU_CACHE"}, key="'MENU_TREE'")
    @Transactional(rollbackFor={Exception.class})
    public Long createMenu(SysPermissionNewParam permission) throws BusinessException {
        if (this.sysPermissionRepo.existsByCode(permission.getCode())) {
            throw new BusinessException("\u5e94\u7528\uff1a" + permission.getCode() + ", \u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        SysPermissionDO tempPermission = SysPermissionConvert.INSTANCE.newParamToDO(permission);
        tempPermission.setPermType(0);
        tempPermission.setHttpMethod(null);
        if (permission.getParentId() == null || permission.getParentId() == 0L) {
            tempPermission.setParentId(FIXED_ROOT_ID);
            tempPermission.setPath("/");
        } else {
            Optional<SysPermissionVO> parentOpt = this.getById(permission.getParentId());
            if (parentOpt.isEmpty()) {
                throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u7236\u7ea7\u5e94\u7528\u4e0d\u5b58\u5728");
            }
            SysPermissionVO parent = parentOpt.get();
            tempPermission.setPath(parent.getPath() + parent.getId() + "/");
        }
        SysPermissionDO newPermission = (SysPermissionDO)this.sysPermissionRepo.save(tempPermission);
        return newPermission.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createAction(SysPermissionNewParam permission) throws BusinessException {
        if (permission.getParentId() == null || permission.getParentId() == 0L) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u64cd\u4f5c\u5fc5\u987b\u6302\u5728\u5e94\u7528\u4e4b\u4e0b");
        }
        Optional<SysPermissionVO> parentOpt = this.getById(permission.getParentId());
        if (parentOpt.isEmpty()) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u64cd\u4f5c\u6240\u5c5e\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        SysPermissionVO parent = parentOpt.get();
        if (parent.getPermType() != 0) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u64cd\u4f5c\u5fc5\u987b\u6302\u5728\u5e94\u7528\u4e4b\u4e0b");
        }
        if (this.sysPermissionRepo.existsByCodeAndParentId(permission.getCode(), permission.getParentId())) {
            throw new BusinessException("\u5f53\u524d\u5e94\u7528\u4e0b\uff0c\u64cd\u4f5c\uff1a" + permission.getCode() + ", \u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        SysPermissionDO tempPermission = SysPermissionConvert.INSTANCE.newParamToDO(permission);
        tempPermission.setPermType(1);
        tempPermission.setSortNo(0);
        tempPermission.setPath(parent.getPath() + parent.getId() + "/");
        SysPermissionDO newPermission = (SysPermissionDO)this.sysPermissionRepo.save(tempPermission);
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
        return newPermission.getId();
    }

    @CacheEvict(cacheNames={"MENU_CACHE"}, key="'MENU_TREE'")
    @Transactional(rollbackFor={Exception.class})
    public void update(SysPermissionUpdateParam perm) {
        Optional optional = this.sysPermissionRepo.findById(perm.getId());
        if (optional.isEmpty()) {
            throw new BusinessException("\u5f85\u66f4\u65b0\u7684\u6743\u9650\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        SysPermissionDO oldPerm = (SysPermissionDO)optional.get();
        if (oldPerm.getPermType() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u6743\u9650\u7c7b\u578b\u4e3a\u7a7a");
        }
        boolean isMenu = oldPerm.getPermType().equals(0);
        if (StringUtils.isNotBlank((CharSequence)perm.getCode())) {
            if (isMenu) {
                if (this.sysPermissionRepo.existsByCodeAndIdNot(perm.getCode(), perm.getId())) {
                    throw new BusinessException("\u5e94\u7528\uff1a" + perm.getCode() + ", \u5df2\u7ecf\u5b58\u5728");
                }
            } else if (this.sysPermissionRepo.existsByCodeAndParentIdAndIdNot(perm.getCode(), oldPerm.getParentId(), perm.getId())) {
                throw new BusinessException("\u5f53\u524d\u5e94\u7528\u4e0b\uff0c\u64cd\u4f5c\uff1a" + perm.getCode() + ", \u5df2\u7ecf\u5b58\u5728");
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        oldPerm.setCode(perm.getCode());
        if (!StringUtils.isNotBlank((CharSequence)perm.getName())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        oldPerm.setName(perm.getName());
        oldPerm.setPattern(perm.getPattern());
        oldPerm.setHttpMethod(perm.getHttpMethod());
        oldPerm.setIsHidden(perm.getIsHidden());
        oldPerm.setIsQuick(perm.getIsQuick());
        oldPerm.setIcon(perm.getIcon());
        oldPerm.setSortNo(perm.getSortNo());
        ArrayList<SysPermissionDO> updatePerms = new ArrayList<SysPermissionDO>(Collections.singletonList(oldPerm));
        if (!perm.getParentId().equals(oldPerm.getParentId())) {
            this.sysPermissionRepo.findById(perm.getParentId()).ifPresent(pp -> {
                String oldSubPath = oldPerm.getPath() + oldPerm.getId() + "/";
                List<SysPermissionDO> perms = this.sysPermissionRepo.findByPathLike(oldPerm.getPath() + oldPerm.getId() + "%");
                oldPerm.setPath(pp.getPath() + pp.getId() + "/").setParentId(pp.getId());
                String subPath = oldPerm.getPath() + oldPerm.getId() + "/";
                perms.forEach(p -> p.setPath(p.getPath().replace(oldSubPath, subPath)));
                updatePerms.addAll(perms);
            });
        }
        this.sysPermissionRepo.saveAll(updatePerms);
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
    }

    @CacheEvict(cacheNames={"MENU_CACHE"}, key="'MENU_TREE'")
    @Transactional(rollbackFor={Exception.class})
    public void deleteMenuById(Long id) {
        if (id == null) {
            return;
        }
        if (this.sysPermissionRepo.existsByParentId(id)) {
            throw new BusinessException("\u5f53\u524d\u5e94\u7528\u4e0b\u5b58\u5728\u64cd\u4f5c\uff0c\u8bf7\u5148\u5220\u9664\u6240\u6709\u64cd\u4f5c\uff0c\u624d\u80fd\u5220\u9664\u5f53\u524d\u5e94\u7528");
        }
        this.sysRolePermissionRepo.deleteByPermissionIdIn(Collections.singletonList(id));
        this.sysPermissionRepo.deleteById(id);
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteActionByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<Long> permissionIds = ids.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(permissionIds)) {
            return;
        }
        this.sysRolePermissionRepo.deleteByPermissionIdIn(permissionIds);
        this.sysPermissionRepo.deleteByIdIn(permissionIds);
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
    }

    @Cacheable(cacheNames={"MENU_CACHE"}, key="'MENU_TREE'")
    public List<AntTreeNode> listAllMenuTree() {
        List<AntTreeNode> antTreeNodes = this.sysPermissionRepoProc.findTreeNodes(0, null);
        return this.buildMenuTree(antTreeNodes, FIXED_ROOT_ID);
    }

    public List<AntTreeNode> listAllMenuWithActionTree(String terminalCode) {
        List<Object> antTreeNodes = this.listAllMenuWithActionTree(FIXED_ROOT_ID);
        antTreeNodes = antTreeNodes.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        return antTreeNodes;
    }

    public List<AntTreeNode> listAllMenuWithActionTree(Long permId) {
        List<AntTreeNode> antTreeNodes = null;
        if (permId == null || FIXED_ROOT_ID.equals(permId)) {
            antTreeNodes = this.sysPermissionRepoProc.findTreeNodes(null, null);
            return this.buildMenuTree(antTreeNodes, FIXED_ROOT_ID);
        }
        Optional optional = this.sysPermissionRepo.findById(permId);
        if (optional.isEmpty()) {
            throw new BusinessException("\u5bf9\u5e94\u6743\u9650\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        SysPermissionDO perm = (SysPermissionDO)optional.get();
        if (perm.getPermType() == 1) {
            return Collections.emptyList();
        }
        antTreeNodes = this.sysPermissionRepoProc.findTreeNodes(null, perm.getPath() + perm.getId() + "/%");
        return this.buildMenuTree(antTreeNodes, permId);
    }

    private List<AntTreeNode> buildMenuTree(List<AntTreeNode> antTreeNodes, Long rootKey) {
        if (CollectionUtils.isEmpty(antTreeNodes)) {
            return Collections.emptyList();
        }
        Map<Long, List<AntTreeNode>> pKeyMap = antTreeNodes.stream().filter(node -> node.getParentKey() != null).collect(Collectors.groupingBy(AntTreeNode::getParentKey));
        List<Object> rootNodes = null;
        if (rootKey == null || FIXED_ROOT_ID.equals(rootKey)) {
            if (pKeyMap.containsKey(FIXED_ROOT_ID)) {
                rootNodes = pKeyMap.get(FIXED_ROOT_ID);
            }
        } else {
            rootNodes = antTreeNodes.stream().filter(node -> rootKey.equals(node.getKey())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isNotEmpty(rootNodes)) {
            return Collections.emptyList();
        }
        Collections.sort(rootNodes);
        rootNodes.forEach(node -> this.buildChildNodes((AntTreeNode)node, pKeyMap));
        return rootNodes;
    }

    private void buildChildNodes(AntTreeNode rootNode, Map<Long, List<AntTreeNode>> pKeyMap) {
        if (!pKeyMap.containsKey(rootNode.getKey())) {
            return;
        }
        List<AntTreeNode> childNodes = pKeyMap.get(rootNode.getKey());
        if (CollectionUtils.isNotEmpty(childNodes)) {
            Collections.sort(childNodes);
            childNodes.forEach(node -> this.buildChildNodes((AntTreeNode)node, pKeyMap));
        }
        rootNode.setChildren(childNodes);
    }

    public Set<SysPermissionVO> listAllPermissionsByIds(List<Long> ids) {
        return this.sysPermissionRepo.findAllByIdIn(ids).stream().map(CONVERT::doToVO).collect(Collectors.toSet());
    }

    public Set<SysPermissionVO> listAllActionsByIds(Set<Long> ids) {
        return this.sysPermissionRepoProc.queryByIds(ids, SysPermTypeEnum.ACTION).stream().map(CONVERT::doToVO).collect(Collectors.toSet());
    }

    public Set<Long> listAllParentIdByIds(Set<Long> ids, Integer permType) {
        return this.sysPermissionRepoProc.queryParentId(ids, this.convertPermType(permType));
    }

    public List<AntTreeNode> listPermTreeByIds(List<Long> ids) {
        return null;
    }

    public Optional<SysPermissionVO> getById(Long id) {
        return this.sysPermissionRepo.findById(id).map(p -> {
            SysPermissionVO vo = CONVERT.doToVO((SysPermissionDO)p);
            this.sysPermissionRepo.findById(p.getParentId()).ifPresent(par -> vo.setParentName(par.getName()));
            return vo;
        });
    }

    public ApiResult<List<SysPermissionVO>> listActionsByMenuId(Long id) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
        }
        List<SysCurrentUserPermissions> userPermissions = this.userPermissionManager.queryUserPermissionActionList(currentUser.getUser(), id);
        if (userPermissions.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Set<Long> actionIds = userPermissions.stream().map(SysCurrentUserPermissions::getId).collect(Collectors.toSet());
        List actionList = this.sysPermissionRepoProc.queryByIds(actionIds, null).stream().map(CONVERT::doToVO).collect(Collectors.toList());
        return ApiResult.ok(actionList);
    }

    public List<SysPermissionVO> findAllByPermType(Integer permType) {
        return this.sysPermissionRepo.findAllByPermType(permType).stream().map(CONVERT::doToVO).collect(Collectors.toList());
    }

    public List<SysPermissionVO> findAll() {
        return this.sysPermissionRepo.findAll().stream().map(CONVERT::doToVO).collect(Collectors.toList());
    }

    private SysPermTypeEnum convertPermType(Integer permType) {
        if (permType == null) {
            return null;
        }
        if (permType.equals(SysPermTypeEnum.ACTION.getValue())) {
            return SysPermTypeEnum.ACTION;
        }
        if (permType.equals(SysPermTypeEnum.MENU.getValue())) {
            return SysPermTypeEnum.MENU;
        }
        throw new BusinessException("\u672a\u77e5\u6743\u9650\u7c7b\u578b\uff1a" + permType);
    }
}

