/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.util.TreeDataUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysPersonalitySettingsConvert;
import com.elitesland.yst.system.manager.UserPermissionManager;
import com.elitesland.yst.system.model.entity.QSysPersonalitySettingsDO;
import com.elitesland.yst.system.model.entity.SysPersonalitySettingsDO;
import com.elitesland.yst.system.repo.SysPersonalitySettingsRepo;
import com.elitesland.yst.system.repo.SysPersonalitySettingsRepoProc;
import com.elitesland.yst.system.service.IUserPermissionService;
import com.elitesland.yst.system.service.SysPersonalitySettingsService;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.service.vo.param.SysPersonalitySettingsParamVO;
import com.elitesland.yst.system.service.vo.resp.SysPersonalitySettingsRespVO;
import com.elitesland.yst.system.service.vo.save.SysPersonalitySettingsSaveVO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"sysPersonalitySettings"})
@Api(value="sysPersonalitySettings", tags={"sysPersonalitySettings"})
@Service(value="sysPersonalitySettings")
public class SysPersonalitySettingsServiceImpl
implements SysPersonalitySettingsService {
    private final SysPersonalitySettingsRepo sysPersonalitySettingsRepo;
    private final SysPersonalitySettingsRepoProc sysPersonalitySettingsRepoProc;
    private final IUserPermissionService userPermissionService;
    @Autowired
    private UserPermissionManager userPermissionManager;

    public Optional<SysPersonalitySettingsRespVO> findIdOne(Long id) {
        return this.sysPersonalitySettingsRepo.findById(id).map(SysPersonalitySettingsConvert.INSTANCE::doToVO);
    }

    public List<SysCurrentUserPermissions> findParam(String terminalCode, String personality) {
        ArrayList sysPersonalitySettingsRespVOList = new ArrayList();
        ArrayList<SysCurrentUserPermissions> sysCurrentUserPermissionsList = new ArrayList<SysCurrentUserPermissions>();
        GeneralUserDetails user = SecurityUtil.getUser();
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTreeset(user.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        if (user != null) {
            QSysPersonalitySettingsDO sysPersonalitySettingsQDo = QSysPersonalitySettingsDO.sysPersonalitySettingsDO;
            Iterable all = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)personality)));
            ArrayList sysPersonalitySettingsDOList = Lists.newArrayList((Iterable)all);
            sysPersonalitySettingsRespVOList.addAll(sysPersonalitySettingsDOList);
            if (!org.springframework.util.CollectionUtils.isEmpty(sysPersonalitySettingsRespVOList)) {
                Optional<SysPersonalitySettingsDO> first;
                if (sysPersonalitySettingsRespVOList.size() == 1 && (first = sysPersonalitySettingsRespVOList.stream().filter(t -> 0 == t.getSortNo()).filter(t -> Long.valueOf(0L).equals(t.getPId())).findFirst()).isPresent()) {
                    return new ArrayList<SysCurrentUserPermissions>();
                }
                ArrayList finalSysPersonalitySettingsRespVOList = sysPersonalitySettingsRespVOList;
                permissions.forEach(v -> {
                    v.setIsQuick(Boolean.valueOf(false));
                    Optional<SysPersonalitySettingsDO> first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> v.getId().equals(t.getPId())).findFirst();
                    if (first.isPresent()) {
                        v.setSortNo(first.get().getSortNo());
                        v.setIsQuick(first.get().getIsQuick());
                    }
                });
                TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
                return treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList());
            }
            TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
            sysCurrentUserPermissionsList.addAll(treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList()));
        }
        return sysCurrentUserPermissionsList;
    }

    public List<SysCurrentUserPermissions> findParamPid(String terminalCode, String personality, @PathVariable Long pid) {
        ArrayList sysPersonalitySettingsRespVOList = new ArrayList();
        ArrayList<SysCurrentUserPermissions> sysCurrentUserPermissionsList = new ArrayList<SysCurrentUserPermissions>();
        GeneralUserDetails user = SecurityUtil.getUser();
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTreeset(user.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        if (user != null) {
            QSysPersonalitySettingsDO sysPersonalitySettingsQDo = QSysPersonalitySettingsDO.sysPersonalitySettingsDO;
            Iterable all = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)personality)).and((Predicate)sysPersonalitySettingsQDo.pId.eq((Object)pid)));
            ArrayList sysPersonalitySettingsDOList = Lists.newArrayList((Iterable)all);
            sysPersonalitySettingsRespVOList.addAll(sysPersonalitySettingsDOList);
            if (!org.springframework.util.CollectionUtils.isEmpty(sysPersonalitySettingsRespVOList)) {
                Optional<SysPersonalitySettingsDO> first;
                if (sysPersonalitySettingsRespVOList.size() == 1 && (first = sysPersonalitySettingsRespVOList.stream().filter(t -> 0 == t.getSortNo()).filter(t -> Long.valueOf(0L).equals(t.getPId())).findFirst()).isPresent()) {
                    return new ArrayList<SysCurrentUserPermissions>();
                }
                ArrayList finalSysPersonalitySettingsRespVOList = sysPersonalitySettingsRespVOList;
                permissions.forEach(v -> {
                    Optional<SysPersonalitySettingsDO> first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> v.getId().equals(t.getPId())).findFirst();
                    if (first.isPresent()) {
                        v.setSortNo(first.get().getSortNo());
                        v.setIsQuick(first.get().getIsQuick());
                    }
                });
                TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
                return treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList());
            }
            TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
            sysCurrentUserPermissionsList.addAll(treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList()));
        }
        return sysCurrentUserPermissionsList;
    }

    public List<SysCurrentUserPermissions> findParamquick(String terminalCode, String personality) {
        ArrayList sysPersonalitySettingsRespVOList = new ArrayList();
        ArrayList sysCurrentUserPermissionsList = new ArrayList();
        GeneralUserDetails user = SecurityUtil.getUser();
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTreeset(user.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        if (user != null) {
            QSysPersonalitySettingsDO sysPersonalitySettingsQDo = QSysPersonalitySettingsDO.sysPersonalitySettingsDO;
            Iterable all = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)personality)));
            ArrayList sysPersonalitySettingsDOList = Lists.newArrayList((Iterable)all);
            sysPersonalitySettingsRespVOList.addAll(sysPersonalitySettingsDOList);
            if (!org.springframework.util.CollectionUtils.isEmpty(sysPersonalitySettingsRespVOList)) {
                Optional<SysPersonalitySettingsDO> first;
                if (sysPersonalitySettingsRespVOList.size() == 1 && (first = sysPersonalitySettingsRespVOList.stream().filter(t -> 0 == t.getSortNo()).filter(t -> Long.valueOf(0L).equals(t.getPId())).findFirst()).isPresent()) {
                    return new ArrayList<SysCurrentUserPermissions>();
                }
                ArrayList finalSysPersonalitySettingsRespVOList = sysPersonalitySettingsRespVOList;
                List pids = sysPersonalitySettingsRespVOList.stream().map(SysPersonalitySettingsDO::getPId).filter(Objects::nonNull).collect(Collectors.toList());
                permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> pids.contains(t.getId())).collect(Collectors.toList());
                permissions.forEach(v -> {
                    Optional<SysPersonalitySettingsDO> first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> t.getPId().equals(v.getId())).findFirst();
                    if (first.isPresent()) {
                        if (null == v.getSortNo()) {
                            v.setSortNo(Integer.valueOf(0));
                        }
                        v.setSortNo(first.get().getSortNo());
                        v.setIsQuick(first.get().getIsQuick());
                    }
                });
            }
            permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> t.getIsQuick()).collect(Collectors.toList());
            permissions = permissions.stream().sorted(Comparator.comparing(SysCurrentUserPermissions::getSortNo)).collect(Collectors.toList());
        }
        return permissions;
    }

    public List<SysCurrentUserPermissions> findParampersonality(String terminalCode, String personality) {
        ArrayList sysPersonalitySettingsRespVOList = new ArrayList();
        ArrayList<SysCurrentUserPermissions> sysCurrentUserPermissionsList = new ArrayList<SysCurrentUserPermissions>();
        GeneralUserDetails user = SecurityUtil.getUser();
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTreeset(user.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        if (user != null) {
            QSysPersonalitySettingsDO sysPersonalitySettingsQDo = QSysPersonalitySettingsDO.sysPersonalitySettingsDO;
            Iterable all = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)personality)));
            ArrayList sysPersonalitySettingsDOList = Lists.newArrayList((Iterable)all);
            sysPersonalitySettingsRespVOList.addAll(sysPersonalitySettingsDOList);
            if (!org.springframework.util.CollectionUtils.isEmpty(sysPersonalitySettingsRespVOList)) {
                Optional<SysPersonalitySettingsDO> first;
                ArrayList finalSysPersonalitySettingsRespVOList = sysPersonalitySettingsRespVOList;
                List pids = finalSysPersonalitySettingsRespVOList.stream().map(SysPersonalitySettingsDO::getPId).filter(Objects::nonNull).collect(Collectors.toList());
                permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> pids.contains(t.getId())).collect(Collectors.toList());
                if (sysPersonalitySettingsRespVOList.size() == 1 && (first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> 0 == t.getSortNo()).filter(t -> Long.valueOf(0L).equals(t.getPId())).findFirst()).isPresent()) {
                    return new ArrayList<SysCurrentUserPermissions>();
                }
                permissions.forEach(v -> {
                    Optional<SysPersonalitySettingsDO> first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> t.getId().equals(t.getPId())).findFirst();
                    if (first.isPresent()) {
                        v.setSortNo(first.get().getSortNo());
                        v.setIsQuick(first.get().getIsQuick());
                    }
                });
                TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
                return treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList());
            }
            TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
            sysCurrentUserPermissionsList.addAll(treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList()));
        }
        return sysCurrentUserPermissionsList;
    }

    public List<SysCurrentUserPermissions> findParampersonalityPid(String terminalCode, String personality) {
        ArrayList sysPersonalitySettingsRespVOList = new ArrayList();
        ArrayList<SysCurrentUserPermissions> sysCurrentUserPermissionsList = new ArrayList<SysCurrentUserPermissions>();
        GeneralUserDetails user = SecurityUtil.getUser();
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTreeset(user.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        if (user != null) {
            QSysPersonalitySettingsDO sysPersonalitySettingsQDo = QSysPersonalitySettingsDO.sysPersonalitySettingsDO;
            Iterable all = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)personality)));
            ArrayList sysPersonalitySettingsDOList = Lists.newArrayList((Iterable)all);
            sysPersonalitySettingsRespVOList.addAll(sysPersonalitySettingsDOList);
            if (!org.springframework.util.CollectionUtils.isEmpty(sysPersonalitySettingsRespVOList)) {
                Optional<SysPersonalitySettingsDO> first;
                ArrayList finalSysPersonalitySettingsRespVOList = sysPersonalitySettingsRespVOList;
                List pids = finalSysPersonalitySettingsRespVOList.stream().map(SysPersonalitySettingsDO::getPId).filter(Objects::nonNull).collect(Collectors.toList());
                permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> pids.contains(t.getId())).collect(Collectors.toList());
                if (sysPersonalitySettingsRespVOList.size() == 1 && (first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> 0 == t.getSortNo()).filter(t -> Long.valueOf(0L).equals(t.getPId())).findFirst()).isPresent()) {
                    return new ArrayList<SysCurrentUserPermissions>();
                }
                permissions.forEach(v -> {
                    Optional<SysPersonalitySettingsDO> first = finalSysPersonalitySettingsRespVOList.stream().filter(t -> t.getId().equals(t.getPId())).findFirst();
                    if (first.isPresent()) {
                        v.setSortNo(first.get().getSortNo());
                        v.setIsQuick(first.get().getIsQuick());
                    }
                });
                TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
                return treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList());
            }
            TreeDataUtil treeDataUtil = new TreeDataUtil(permissions, SysCurrentUserPermissions::getId, SysCurrentUserPermissions::getParentId, SysCurrentUserPermissions::setChildNodes, Comparator.comparingInt(SysCurrentUserPermissions::getSortNo));
            sysCurrentUserPermissionsList.addAll(treeDataUtil.getRoots().stream().filter(t -> Long.valueOf(0L).equals(t.getParentId())).collect(Collectors.toList()));
        }
        return sysCurrentUserPermissionsList;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createOne(SysPersonalitySettingsSaveVO param) {
        SysPersonalitySettingsDO sysPersonalitySettingsDO = SysPersonalitySettingsConvert.INSTANCE.saveToDo(param);
        return ((SysPersonalitySettingsDO)this.sysPersonalitySettingsRepo.save(sysPersonalitySettingsDO)).getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void createAll(List<SysPersonalitySettingsSaveVO> param) {
        List<SysPersonalitySettingsDO> sysPersonalitySettingsDOS = SysPersonalitySettingsConvert.INSTANCE.saveListToDo(param);
        this.sysPersonalitySettingsRepo.saveAll(sysPersonalitySettingsDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateOne(SysPersonalitySettingsSaveVO param) {
        if (param.getId() != null) {
            Optional first = this.sysPersonalitySettingsRepo.findById(param.getId());
            if (!first.isPresent()) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
            }
            SysPersonalitySettingsConvert.INSTANCE.copyRpSaveToDo(param, (SysPersonalitySettingsDO)first.get());
            this.sysPersonalitySettingsRepo.save((SysPersonalitySettingsDO)first.get());
        } else {
            Long id = ((SysPersonalitySettingsDO)this.sysPersonalitySettingsRepo.save(SysPersonalitySettingsConvert.INSTANCE.saveToDo(param))).getId();
            param.setId(id);
        }
        return param.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public List<SysPersonalitySettingsSaveVO> updateAll(List<SysPersonalitySettingsSaveVO> param) {
        if (CollectionUtils.isNotEmpty(param)) {
            List pids = param.stream().map(SysPersonalitySettingsSaveVO::getPId).filter(Objects::nonNull).collect(Collectors.toList());
            GeneralUserDetails user = SecurityUtil.getUser();
            QSysPersonalitySettingsDO sysPersonalitySettingsQDo = QSysPersonalitySettingsDO.sysPersonalitySettingsDO;
            Iterable all = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)param.get(0).getPersonality())).and((Predicate)sysPersonalitySettingsQDo.pId.in(pids)));
            ArrayList sysPersonalitySettingsDOList = Lists.newArrayList((Iterable)all);
            List ppids = sysPersonalitySettingsDOList.stream().map(SysPersonalitySettingsDO::getPId).filter(Objects::nonNull).collect(Collectors.toList());
            pids.removeAll(ppids);
            Iterable deleall = this.sysPersonalitySettingsRepo.findAll((Predicate)sysPersonalitySettingsQDo.createUserId.eq((Object)user.getUser().getId()).and((Predicate)sysPersonalitySettingsQDo.personality.eq((Object)param.get(0).getPersonality())).and((Predicate)sysPersonalitySettingsQDo.pId.notIn(ppids)));
            ArrayList delesysPersonalitySettingsDOList = Lists.newArrayList((Iterable)deleall);
            List delppids = delesysPersonalitySettingsDOList.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toList());
            this.sysPersonalitySettingsRepo.deleteAllById(delppids);
            List<SysPersonalitySettingsSaveVO> sysPersonalitySettingsSaveList = param.stream().filter(Objects::nonNull).distinct().filter(t -> pids.contains(t.getPId())).collect(Collectors.toList());
            this.sysPersonalitySettingsRepo.saveAll(SysPersonalitySettingsConvert.INSTANCE.saveListToDo(sysPersonalitySettingsSaveList));
            for (SysPersonalitySettingsDO detailDTO : sysPersonalitySettingsDOList) {
                if (detailDTO.getId() == null) continue;
                Optional<SysPersonalitySettingsSaveVO> first = param.stream().filter(vo -> vo.getPId().equals(detailDTO.getPId()) && vo.getPersonality().equals(detailDTO.getPersonality())).filter(Objects::nonNull).distinct().findFirst();
                if (!first.isPresent()) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
                }
                SysPersonalitySettingsConvert.INSTANCE.copyRpSaveToDo(first.get(), detailDTO);
                this.sysPersonalitySettingsRepo.save(detailDTO);
            }
        }
        return param;
    }

    public void updateAllSysCurrentUserPermissions(List<SysCurrentUserPermissions> param, String personality) {
        ArrayList<SysCurrentUserPermissions> list = new ArrayList<SysCurrentUserPermissions>();
        SysPersonalitySettingsServiceImpl.changtree(list, param);
        List<SysPersonalitySettingsSaveVO> sysPersonalitySettingsSaveVOList = list.stream().map(i -> {
            SysPersonalitySettingsSaveVO saveVO = new SysPersonalitySettingsSaveVO();
            saveVO.setPId(i.getId());
            saveVO.setIsQuick(i.getIsQuick());
            saveVO.setPersonality(personality);
            saveVO.setSortNo(i.getSortNo());
            return saveVO;
        }).collect(Collectors.toList());
        this.updateAll(sysPersonalitySettingsSaveVOList);
    }

    public static void changtree(List<SysCurrentUserPermissions> newSysCurrentUserPermissions, List<SysCurrentUserPermissions> oldSysCurrentUserPermissions) {
        oldSysCurrentUserPermissions.forEach(v -> {
            newSysCurrentUserPermissions.add((SysCurrentUserPermissions)v);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)v.getChildNodes()) && v.getChildNodes().size() > 0) {
                SysPersonalitySettingsServiceImpl.changtree(newSysCurrentUserPermissions, v.getChildNodes());
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.sysPersonalitySettingsRepo.deleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ids.forEach(this::deleteOne);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        SysPersonalitySettingsParamVO sysPersonalitySettingsParamVO = new SysPersonalitySettingsParamVO();
        sysPersonalitySettingsParamVO.setIds(ids);
        this.sysPersonalitySettingsRepoProc.updateDeleteFlagBatch(sysPersonalitySettingsParamVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        SysPersonalitySettingsParamVO sysPersonalitySettingsParamVO = new SysPersonalitySettingsParamVO();
        sysPersonalitySettingsParamVO.setId(id);
        Long count = this.sysPersonalitySettingsRepoProc.updateDeleteFlagBatch(sysPersonalitySettingsParamVO);
    }

    public SysPersonalitySettingsServiceImpl(SysPersonalitySettingsRepo sysPersonalitySettingsRepo, SysPersonalitySettingsRepoProc sysPersonalitySettingsRepoProc, IUserPermissionService userPermissionService) {
        this.sysPersonalitySettingsRepo = sysPersonalitySettingsRepo;
        this.sysPersonalitySettingsRepoProc = sysPersonalitySettingsRepoProc;
        this.userPermissionService = userPermissionService;
    }
}

