/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysQuickEntryConvert;
import com.elitesland.yst.system.model.entity.QSysQuickEntryDO;
import com.elitesland.yst.system.model.entity.SysQuickEntryDO;
import com.elitesland.yst.system.repo.SysQuickEntryRepo;
import com.elitesland.yst.system.repo.SysQuickEntryRepoProc;
import com.elitesland.yst.system.service.SysQuickEntryService;
import com.elitesland.yst.system.service.param.SysQuickEntryCreateParam;
import com.elitesland.yst.system.service.param.SysQuickEntryQueryParam;
import com.elitesland.yst.system.service.param.SysQuickEntryUpdateParam;
import com.elitesland.yst.system.service.vo.SysQuickEntryVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysQuickEntryService")
public class SysQuickEntryServiceImpl
implements SysQuickEntryService {
    private final SysQuickEntryRepo sysQuickEntryRepo;
    private final SysQuickEntryRepoProc sysQuickEntryRepoProc;

    @SysCodeProc
    public PagingVO<SysQuickEntryVO> search(SysQuickEntryQueryParam param) {
        Page ret = this.sysQuickEntryRepo.findAll(this.sysQuickEntryRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(SysQuickEntryConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    public Optional<SysQuickEntryVO> findDataCurrent() {
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null) {
            return this.sysQuickEntryRepo.findByCreateUserId(user.getUser().getId()).map(SysQuickEntryConvert.INSTANCE::doToVO);
        }
        return Optional.empty();
    }

    @SysCodeProc
    public Optional<SysQuickEntryVO> findCodeOne(String itemCode) {
        JPAQuery<SysQuickEntryVO> jpaQuery = this.sysQuickEntryRepoProc.select(null);
        QSysQuickEntryDO jpaQDo = QSysQuickEntryDO.sysQuickEntryDO;
        SysQuickEntryVO vo = (SysQuickEntryVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<SysQuickEntryVO> findIdOne(Long id) {
        return this.sysQuickEntryRepo.findById(id).map(SysQuickEntryConvert.INSTANCE::doToVO);
    }

    @SysCodeProc
    public List<SysQuickEntryVO> findIdBatch(List<Long> idList) {
        return this.sysQuickEntryRepo.findAllById(idList).stream().map(SysQuickEntryConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(SysQuickEntryCreateParam param) {
        SysQuickEntryDO sysQuickEntryDO = SysQuickEntryConvert.INSTANCE.creatParamToDo(param);
        return ((SysQuickEntryDO)this.sysQuickEntryRepo.save(sysQuickEntryDO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<SysQuickEntryCreateParam> list) {
        List dos = list.stream().map(SysQuickEntryConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
        return this.sysQuickEntryRepo.saveAll(dos).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(SysQuickEntryUpdateParam param) {
        SysQuickEntryDO objDo = SysQuickEntryConvert.INSTANCE.updateParamToDo(param);
        Optional optional = this.sysQuickEntryRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore((Object)objDo, (Object)((SysQuickEntryDO)optional.get()), (String[])BeanCopyUtil.getNullPropertyNames((Object)objDo));
        this.sysQuickEntryRepo.save((SysQuickEntryDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QSysQuickEntryDO jpaQDo = QSysQuickEntryDO.sysQuickEntryDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.sysQuickEntryRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SysQuickEntryDO do1 = (SysQuickEntryDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.sysQuickEntryRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.sysQuickEntryRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.sysQuickEntryRepo.deleteById(id));
    }

    public SysQuickEntryServiceImpl(SysQuickEntryRepo sysQuickEntryRepo, SysQuickEntryRepoProc sysQuickEntryRepoProc) {
        this.sysQuickEntryRepo = sysQuickEntryRepo;
        this.sysQuickEntryRepoProc = sysQuickEntryRepoProc;
    }
}

