/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysRoleOuConvert;
import com.elitesland.yst.system.model.entity.QSysRoleOuDO;
import com.elitesland.yst.system.model.entity.SysRoleOuDO;
import com.elitesland.yst.system.repo.SysRoleOuRepo;
import com.elitesland.yst.system.repo.SysRoleOuRepoProc;
import com.elitesland.yst.system.service.ISysRoleOuService;
import com.elitesland.yst.system.service.ISysUserRoleService;
import com.elitesland.yst.system.service.dto.SysUserRoleDTO;
import com.elitesland.yst.system.service.param.SysRoleOuCreateParam;
import com.elitesland.yst.system.service.param.SysRoleOuQueryParam;
import com.elitesland.yst.system.service.param.SysRoleOuUpdateParam;
import com.elitesland.yst.system.service.vo.SysRoleOuVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class SysRoleOuServiceImpl
implements ISysRoleOuService {
    private static final SysRoleOuConvert CONVERT = SysRoleOuConvert.INSTANCE;
    private final SysRoleOuRepo sysRoleOuRepo;
    private final SysRoleOuRepoProc sysRoleOuRepoProc;
    private final ISysUserRoleService sysUserRoleService;

    @SysCodeProc
    public PagingVO<SysRoleOuVO> search(SysRoleOuQueryParam param) {
        Page ret = this.sysRoleOuRepo.findAll(this.sysRoleOuRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(SysRoleOuConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<SysRoleOuVO> findCodeOne(String code) {
        JPAQuery<SysRoleOuVO> jpaQuery = this.sysRoleOuRepoProc.select(null);
        QSysRoleOuDO jpaQDo = QSysRoleOuDO.sysRoleOuDO;
        jpaQuery.where((Predicate)jpaQDo.roleName.eq((Object)code));
        SysRoleOuVO vo = (SysRoleOuVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @SysCodeProc
    public Optional<SysRoleOuVO> findIdOne(Long id) {
        return this.sysRoleOuRepo.findById(id).map(SysRoleOuConvert.INSTANCE::doToVO);
    }

    @SysCodeProc
    public List<SysRoleOuVO> findIdBatch(List<Long> idList) {
        return this.sysRoleOuRepo.findAllById(idList).stream().map(SysRoleOuConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public List<SysRoleOuVO> findCodeBatch(List<String> idList) {
        return this.sysRoleOuRepo.findAllByRoleNameIn(idList).stream().map(SysRoleOuConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(SysRoleOuCreateParam param) {
        SysRoleOuDO doo = CONVERT.createParam2Do(param);
        GeneralUserDetails user = SecurityUtil.getUser();
        if (user != null && user.getUser() != null) {
            doo.setUserId(user.getUser().getId());
            doo.setUsername(user.getUser().getUsername());
            doo.setFirstName(user.getUser().getFirstName());
            doo.setLastName(user.getUser().getLastName());
        }
        return ((SysRoleOuDO)this.sysRoleOuRepo.save(doo)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<SysRoleOuCreateParam> list) {
        List<SysRoleOuDO> dos = CONVERT.createParam2Do(list);
        return this.sysRoleOuRepo.saveAll(dos).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(SysRoleOuUpdateParam objDo) {
        Optional optional = this.sysRoleOuRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        CONVERT.copyUpdateParam(objDo, (SysRoleOuDO)optional.get());
        this.sysRoleOuRepo.save((SysRoleOuDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QSysRoleOuDO jpaQDo = QSysRoleOuDO.sysRoleOuDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.sysRoleOuRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SysRoleOuDO do1 = (SysRoleOuDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.sysRoleOuRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.sysRoleOuRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.sysRoleOuRepo.deleteById(id));
    }

    public List<SysRoleOuVO> selectCust(SysRoleOuQueryParam param) {
        List SysRoleOuDOS = this.sysRoleOuRepo.findAll();
        List<SysRoleOuVO> SysRoleOuVOList = SysRoleOuDOS.stream().map(SysRoleOuConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return SysRoleOuVOList;
    }

    public List<SysRoleOuVO> selectByUserId(Long userId) {
        List userRoleDtoByUserIds = this.sysUserRoleService.findUserRoleDtoByUserIds(Arrays.asList(userId));
        List<Long> collect = userRoleDtoByUserIds.stream().map(SysUserRoleDTO::getRoleId).collect(Collectors.toList());
        List<SysRoleOuDO> allByRoleIdIn = this.sysRoleOuRepo.findAllByRoleIdIn(collect);
        List<SysRoleOuVO> collect1 = allByRoleIdIn.stream().map(SysRoleOuConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return collect1;
    }

    public SysRoleOuServiceImpl(SysRoleOuRepo sysRoleOuRepo, SysRoleOuRepoProc sysRoleOuRepoProc, ISysUserRoleService sysUserRoleService) {
        this.sysRoleOuRepo = sysRoleOuRepo;
        this.sysRoleOuRepoProc = sysRoleOuRepoProc;
        this.sysUserRoleService = sysUserRoleService;
    }
}

