/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysPermissionConvert;
import com.elitesland.yst.system.convert.SysRoleConvert;
import com.elitesland.yst.system.convert.SysRolePermissionConvert;
import com.elitesland.yst.system.manager.PermissionManager;
import com.elitesland.yst.system.model.bo.SysPermissionBO;
import com.elitesland.yst.system.model.entity.QSysPermissionDO;
import com.elitesland.yst.system.model.entity.QSysRoleDO;
import com.elitesland.yst.system.model.entity.QSysRolePermissionDO;
import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.model.entity.SysRoleDO;
import com.elitesland.yst.system.model.entity.SysRolePermissionDO;
import com.elitesland.yst.system.repo.SysPermissionRepoProc;
import com.elitesland.yst.system.repo.SysRolePermissionRepo;
import com.elitesland.yst.system.repo.SysRolePermissionRepoProc;
import com.elitesland.yst.system.service.ISysRolePermissionService;
import com.elitesland.yst.system.service.impl.SysPermissionCacheManager;
import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysRolePermissionVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class SysRolePermissionServiceImpl
implements ISysRolePermissionService {
    private static final SysPermissionConvert CONVERT_PERMISSION = SysPermissionConvert.INSTANCE;
    @Autowired
    private SysRolePermissionRepo sysRolePermissionRepo;
    @Autowired
    private SysRolePermissionRepoProc sysRolePermissionRepoProc;
    private SysPermissionCacheManager sysPermissionCacheManager;
    @Autowired
    private SysPermissionRepoProc sysPermissionRepoProc;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    private final QSysRolePermissionDO rolePermissions = QSysRolePermissionDO.sysRolePermissionDO;
    private final QSysRoleDO roles = QSysRoleDO.sysRoleDO;
    private final QSysPermissionDO permissions = QSysPermissionDO.sysPermissionDO;

    public Set<SysPermissionVO> listPermissionsByRoleId(Long roleId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.permissions).from((EntityPath)this.permissions)).leftJoin((EntityPath)this.rolePermissions)).on((Predicate)this.rolePermissions.permissionId.eq(this.permissions.id))).where((Predicate)this.rolePermissions.roleId.eq((Object)roleId))).fetch().stream().map(SysPermissionConvert.INSTANCE::doToVO).collect(Collectors.toSet());
    }

    public Set<SysPermissionVO> listMenusByRoleId(Long roleId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.permissions).from((EntityPath)this.permissions)).leftJoin((EntityPath)this.rolePermissions)).on((Predicate)this.rolePermissions.permissionId.eq(this.permissions.id))).where((Predicate)this.rolePermissions.roleId.eq((Object)roleId).and((Predicate)this.permissions.permType.eq((Object)0)))).fetch().stream().map(SysPermissionConvert.INSTANCE::doToVO).collect(Collectors.toSet());
    }

    public Set<SysPermissionVO> listActionsByRoleId(Long roleId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.permissions).from((EntityPath)this.permissions)).leftJoin((EntityPath)this.rolePermissions)).on((Predicate)this.rolePermissions.permissionId.eq(this.permissions.id))).where((Predicate)this.rolePermissions.roleId.eq((Object)roleId).and((Predicate)this.permissions.permType.eq((Object)1)))).fetch().stream().map(SysPermissionConvert.INSTANCE::doToVO).collect(Collectors.toSet());
    }

    public Map<Long, Set<SysPermissionVO>> listPermissionsByRoleIds(List<Long> roleIds) {
        List rolePermissionTuples = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.rolePermissions.roleId, this.permissions}).from((EntityPath)this.permissions)).leftJoin((EntityPath)this.rolePermissions)).on((Predicate)this.rolePermissions.permissionId.eq(this.permissions.id))).where((Predicate)this.rolePermissions.roleId.in(roleIds))).fetch();
        return rolePermissionTuples.stream().collect(Collectors.groupingBy(t -> (Long)t.get(0, Long.class), Collectors.mapping(t -> SysPermissionConvert.INSTANCE.doToVO((SysPermissionDO)t.get(1, SysPermissionDO.class)), Collectors.toSet())));
    }

    public Set<SysRoleVO> listRolesByPermissionId(Long permissionId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.roles).from((EntityPath)this.roles)).leftJoin((EntityPath)this.rolePermissions)).on((Predicate)this.rolePermissions.roleId.eq(this.roles.id))).where((Predicate)this.rolePermissions.permissionId.eq((Object)permissionId))).fetch().stream().map(SysRoleConvert.INSTANCE::doToVo).collect(Collectors.toSet());
    }

    public Map<Long, Set<SysRoleVO>> listRolesByPermissionIds(List<Long> permissionIds) {
        List permissionRoleTuples = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.rolePermissions.permissionId, this.roles}).from((EntityPath)this.roles)).leftJoin((EntityPath)this.rolePermissions)).on((Predicate)this.rolePermissions.roleId.eq(this.roles.id))).where((Predicate)this.rolePermissions.permissionId.in(permissionIds))).fetch();
        return permissionRoleTuples.stream().collect(Collectors.groupingBy(t -> (Long)t.get(0, Long.class), Collectors.mapping(t -> SysRoleConvert.INSTANCE.doToVo((SysRoleDO)t.get(1, SysRoleDO.class)), Collectors.toSet())));
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Set<SysPermissionVO> listActionsByMenuIdOfRole(Long roleId, Long menuId) {
        List<Long> permissionids = this.sysRolePermissionRepoProc.queryPermissionIdByRoleId(roleId);
        if (permissionids.isEmpty()) {
            return Collections.emptySet();
        }
        return this.sysPermissionRepoProc.queryByParent(menuId).stream().filter(t -> permissionids.contains(t.getId())).map(CONVERT_PERMISSION::doToVO).collect(Collectors.toSet());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void saveAll(List<SysRolePermissionVO> rps) {
        this.sysRolePermissionRepo.saveAll(rps.stream().map(SysRolePermissionConvert.INSTANCE::voToDO).collect(Collectors.toList()));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void saveActionsByRoleAndRole(Long roleId, Long menuId, Set<Long> permissionIds) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
        }
        List<SysPermissionBO> permissionBoList = this.permissionManager.queryPermissionsByParent(menuId, SysPermTypeEnum.ACTION);
        if (permissionBoList.isEmpty()) {
            throw new BusinessException("\u83dc\u5355\u4e0b\u6ca1\u6709\u64cd\u4f5c");
        }
        Set<Long> permissionIdsToDelete = permissionBoList.stream().map(SysPermissionBO::getId).collect(Collectors.toSet());
        if (!permissionIdsToDelete.isEmpty()) {
            this.sysRolePermissionRepoProc.deleteByRoleIdAndPermissionId(roleId, permissionIdsToDelete);
        }
        if (CollectionUtils.isNotEmpty(permissionIds)) {
            this.sysRolePermissionRepo.saveAll(permissionIds.stream().map(permId -> new SysRolePermissionDO().setRoleId(roleId).setPermissionId((Long)permId)).collect(Collectors.toList()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void removePermissionsByRoleId(Long roleId) {
        this.sysRolePermissionRepo.deleteAllByRoleId(roleId);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void removeRolesByPermissionIds(List<Long> permissionIds) {
        this.sysRolePermissionRepo.deleteAllByPermissionIdIn(permissionIds);
    }
}

