/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.common.InnerUserEnum;
import com.elitesland.yst.security.common.RoleWhiteListEnum;
import com.elitesland.yst.security.config.CustomSecurityProperties;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysRoleConvert;
import com.elitesland.yst.system.model.entity.QSysRoleDO;
import com.elitesland.yst.system.model.entity.SysPermissionDO;
import com.elitesland.yst.system.model.entity.SysRoleDO;
import com.elitesland.yst.system.param.SysRoleNewParam;
import com.elitesland.yst.system.param.SysRoleQueryParam;
import com.elitesland.yst.system.param.SysRoleUpdateParam;
import com.elitesland.yst.system.repo.SysPermissionRepoProc;
import com.elitesland.yst.system.repo.SysRolePermissionRepoProc;
import com.elitesland.yst.system.repo.SysRoleRepo;
import com.elitesland.yst.system.repo.SysRoleRepoProc;
import com.elitesland.yst.system.service.ISysPermissionService;
import com.elitesland.yst.system.service.ISysRolePermissionService;
import com.elitesland.yst.system.service.ISysRoleService;
import com.elitesland.yst.system.service.impl.SysPermissionCacheManager;
import com.elitesland.yst.system.service.param.SysRoleBatchSwitchParam;
import com.elitesland.yst.system.service.vo.SysRolePagingVO;
import com.elitesland.yst.system.vo.SysPermissionVO;
import com.elitesland.yst.system.vo.SysRolePermissionVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class SysRoleServiceImpl
implements ISysRoleService {
    private static final Logger log = LoggerFactory.getLogger(SysRoleServiceImpl.class);
    @Autowired
    private SysRoleRepo sysRoleRepo;
    @Autowired
    private SysRoleRepoProc sysRoleRepoProc;
    @Autowired
    private SysPermissionRepoProc sysPermissionRepoProc;
    @Autowired
    private SysRolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private SysPermissionCacheManager sysPermissionCacheManager;
    @Autowired
    private ISysRolePermissionService sysRolePermissionService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private CustomSecurityProperties customSecurityProperties;

    @Transactional
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public PagingVO<SysRolePagingVO> sysRolePagingSearch(SysRoleQueryParam param) {
        return this.sysRoleRepoProc.sysRolePagingSearch(param);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Optional<SysRoleVO> one(Long roleId) {
        return this.sysRoleRepo.findById(roleId).map(SysRoleConvert.INSTANCE::doToVo);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Long create(SysRoleNewParam role) {
        if (StrUtil.length((CharSequence)role.getCode()) > 16) {
            throw new BusinessException("\u7f16\u53f7\uff1a" + role.getCode() + " \u8d85\u8fc716\u4f4d\uff0c\u65e0\u6cd5\u4f7f\u7528");
        }
        if (RoleWhiteListEnum.exists((String)role.getCode())) {
            throw new BusinessException("\u7f16\u53f7\uff1a" + role.getCode() + " \u4e3a\u7cfb\u7edf\u5185\u7f6e\u7f16\u53f7\uff0c\u65e0\u6cd5\u4f7f\u7528");
        }
        if (this.sysRoleRepo.existsByCode(role.getCode())) {
            throw new BusinessException("\u89d2\u8272\u4ee3\u7801\u91cd\u590d: " + role.getCode());
        }
        if (this.sysRoleRepo.existsByName(role.getName())) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\u91cd\u590d: " + role.getName());
        }
        SysRoleDO sysRoleDO = SysRoleConvert.INSTANCE.newParamToDO(role);
        this.sysRoleRepo.save(sysRoleDO);
        if (CollectionUtils.isNotEmpty((Collection)role.getPermIds())) {
            Set permissions = this.sysPermissionService.listAllPermissionsByIds(role.getPermIds());
            List rolePermissionVOs = permissions.stream().map(p -> new SysRolePermissionVO().setRoleId(sysRoleDO.getId()).setPermissionId(p.getId())).collect(Collectors.toList());
            this.sysRolePermissionService.saveAll(rolePermissionVOs);
            this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
        }
        this.redisUtils.del(new String[]{"sys_all_roles"});
        return sysRoleDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void update(SysRoleUpdateParam reqRole) {
        List rolePermissionVOs;
        if (this.sysRoleRepo.existsByCodeAndIdNot(reqRole.getCode(), reqRole.getId())) {
            throw new BusinessException("\u89d2\u8272\u7f16\u7801\uff1a" + reqRole.getCode() + "\uff0c \u5df2\u7ecf\u5b58\u5728");
        }
        if (this.sysRoleRepo.existsByNameAndIdNot(reqRole.getName(), reqRole.getId())) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\uff1a" + reqRole.getName() + "\uff0c \u5df2\u7ecf\u5b58\u5728");
        }
        Optional roleOpt = this.sysRoleRepo.findById(reqRole.getId());
        if (roleOpt.isEmpty()) {
            throw new BusinessException("\u5f85\u66f4\u65b0\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        SysRoleDO role = (SysRoleDO)roleOpt.get();
        if (RoleWhiteListEnum.exists((String)role.getCode()) && !CharSequenceUtil.equals((CharSequence)role.getCode(), (CharSequence)reqRole.getCode())) {
            throw new BusinessException("\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\u4e0d\u53ef\u4fee\u6539\u7f16\u53f7");
        }
        role.setCode(reqRole.getCode());
        role.setName(reqRole.getName());
        role.setEnabled(reqRole.getEnabled());
        this.sysRoleRepo.save(role);
        List<Long> existsPermissionIds = this.deleteNotExistsPermissionIds(reqRole);
        if (CollectionUtils.isNotEmpty((Collection)reqRole.getPermIds()) && !(rolePermissionVOs = reqRole.getPermIds().stream().filter(p -> !existsPermissionIds.contains(p)).map(p -> new SysRolePermissionVO().setRoleId(role.getId()).setPermissionId(p)).collect(Collectors.toList())).isEmpty()) {
            this.sysRolePermissionService.saveAll(rolePermissionVOs);
        }
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
        this.redisUtils.del(new String[]{"sys_all_roles"});
    }

    private List<Long> deleteNotExistsPermissionIds(SysRoleUpdateParam reqRole) {
        Set notExistsPermissions;
        List<Long> existsPermissionIds = this.rolePermissionRepoProc.queryPermissionIdByRoleId(reqRole.getId());
        if (existsPermissionIds.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> notExistsPermissionIds = null;
        List<SysPermissionDO> sysPermissionDOS = this.sysPermissionRepoProc.selectTerminalCode(reqRole.getTerminalCode());
        ArrayList ids = new ArrayList();
        ids.addAll(sysPermissionDOS.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toList()));
        if (CollUtil.isEmpty((Collection)reqRole.getPermIds())) {
            Set permissionIds = existsPermissionIds.stream().filter(t -> ids.contains(t)).collect(Collectors.toSet());
            notExistsPermissionIds = new HashSet(permissionIds);
        } else {
            notExistsPermissionIds = existsPermissionIds.stream().filter(t -> ids.contains(t)).filter(t -> !reqRole.getPermIds().contains(t)).collect(Collectors.toSet());
        }
        if (notExistsPermissionIds.isEmpty()) {
            return existsPermissionIds;
        }
        if (CollUtil.isNotEmpty((Collection)reqRole.getPermIds()) && !(notExistsPermissions = this.sysPermissionService.listAllPermissionsByIds(new ArrayList(notExistsPermissionIds))).isEmpty()) {
            for (SysPermissionVO perm : notExistsPermissions) {
                if (SysPermTypeEnum.MENU.getValue().equals(perm.getPermType()) || !reqRole.getPermIds().contains(perm.getParentId())) continue;
                notExistsPermissionIds.remove(perm.getId());
            }
        }
        if (!notExistsPermissionIds.isEmpty()) {
            this.rolePermissionRepoProc.deleteByRoleIdAndPermissionId(reqRole.getId(), notExistsPermissionIds);
        }
        return existsPermissionIds;
    }

    public Set<SysRoleVO> listByRoleIds(List<Long> roleIds) {
        return this.sysRoleRepo.findAllByIdIn(roleIds).stream().map(SysRoleConvert.INSTANCE::doToVo).collect(Collectors.toSet());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysRoleVO> listAll() {
        List<SysRoleVO> roles = this.sysRoleRepo.findAll().stream().map(SysRoleConvert.INSTANCE::doToVo).collect(Collectors.toList());
        this.redisUtils.set("sys_all_roles", roles);
        return roles;
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysRoleVO> listAllByPermission() {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return Collections.emptyList();
        }
        List<SysRoleVO> roles = this.listAll();
        if (roles.isEmpty()) {
            return roles;
        }
        Set<String> noPermissionRoles = this.rolesOfNoPermission(currentUser.getUser());
        for (SysRoleVO role : roles) {
            role.setNoPermission(Boolean.valueOf(noPermissionRoles.contains(role.getCode())));
        }
        return roles;
    }

    public Set<String> rolesOfNoPermission(SysUserDTO user) {
        Set allRoleCodes = RoleWhiteListEnum.getAllCode();
        if (user == null) {
            return allRoleCodes;
        }
        if (CharSequenceUtil.equals((CharSequence)user.getUsername(), (CharSequence)InnerUserEnum.ADMIN.getUsername())) {
            return Collections.emptySet();
        }
        Set userRoles = user.getRoles();
        if (userRoles == null || userRoles.isEmpty()) {
            return allRoleCodes;
        }
        String prefix = this.grantedAuthorityPrefix();
        int prefixLength = prefix.length();
        Set userRoleCodes = userRoles.stream().map(t -> {
            int index = t.getCode().indexOf(prefix);
            if (index < 0) {
                return t.getCode();
            }
            return t.getCode().substring(index + prefixLength);
        }).collect(Collectors.toSet());
        if (userRoleCodes.isEmpty()) {
            return allRoleCodes;
        }
        return allRoleCodes.stream().filter(t -> !userRoleCodes.contains(t)).collect(Collectors.toSet());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<String> listMenusById(Long id) {
        Set<Long> permissionIds = this.rolePermissionRepoProc.queryRoleWithPermission(Set.of(id)).get(id);
        if (CollUtil.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        return this.sysPermissionService.listAllPermissionsByIds(new ArrayList<Long>(permissionIds)).stream().filter(t -> SysPermTypeEnum.MENU.getValue().equals(t.getPermType())).map(t -> t.getId().toString()).collect(Collectors.toList());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<String> listMenusByIdAndTerminalCode(Long id, String terminalCode) {
        Set<Long> permissionIds = this.rolePermissionRepoProc.queryRoleWithPermission(Set.of(id)).get(id);
        if (CollUtil.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        return this.sysPermissionService.listAllPermissionsByIds(new ArrayList<Long>(permissionIds)).stream().filter(t -> SysPermTypeEnum.MENU.getValue().equals(t.getPermType()) && terminalCode.equals(t.getTerminalCode())).map(t -> t.getId().toString()).collect(Collectors.toList());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<String> listActionsById(Long id) {
        Set<Long> permissionIds = this.rolePermissionRepoProc.queryRoleWithPermission(Set.of(id)).get(id);
        if (CollUtil.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        return this.sysPermissionService.listAllPermissionsByIds(new ArrayList<Long>(permissionIds)).stream().filter(t -> SysPermTypeEnum.ACTION.getValue().equals(t.getPermType())).map(t -> t.getId().toString()).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Boolean switchRoleStatus(Long id) {
        Optional roleOpt = this.sysRoleRepo.findById(id);
        this.sysPermissionCacheManager.refreshCacheOfAllPermissionsWithRoles();
        return roleOpt.map(r -> {
            r.setEnabled(r.getEnabled() == false);
            this.sysRoleRepo.save(r);
            return r.getEnabled();
        }).orElseThrow(new BusinessException(ApiCode.FAIL, "ID\u4e3a\uff1a" + id + "\uff0c\u7684\u89d2\u8272\u4e0d\u5b58\u5728"));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void batchSwitchEnable(SysRoleBatchSwitchParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getIds())) {
            return;
        }
        List<Long> ids = param.getIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (param.getEnabled() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sysRoleRepoProc.switchEnableByIds(ids, param.getEnabled());
    }

    public Map<String, Long> getIdByName(Set<String> names) {
        if (CollUtil.isEmpty(names)) {
            return Collections.emptyMap();
        }
        return this.sysRoleRepoProc.getIdByName(names);
    }

    public Map<String, Long> getIdByCode(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return Collections.emptyMap();
        }
        return this.sysRoleRepoProc.getIdByCode(codes);
    }

    public Long getIdByCode(String code) {
        Assert.hasText((String)code, (String)"\u89d2\u8272\u7f16\u53f7\u4e3a\u7a7a");
        return this.sysRoleRepoProc.getIdByCode(code);
    }

    public List<SysRoleVO> selectreolename(String rolename) {
        QSysRoleDO Q_SYS_ROLE_DO = QSysRoleDO.sysRoleDO;
        List fetch = ((JPAQuery)this.sysRoleRepoProc.select().where((Predicate)Q_SYS_ROLE_DO.name.eq((Object)rolename).and((Predicate)Q_SYS_ROLE_DO.deleteFlag.eq((Object)0)))).fetch();
        return fetch;
    }

    private String grantedAuthorityPrefix() {
        return CharSequenceUtil.blankToDefault((CharSequence)this.customSecurityProperties.getRolePrefix(), (String)"ROLE_");
    }
}

