/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.convert.SysSettingConvert;
import com.elitesland.yst.system.model.entity.QSysSettingDO;
import com.elitesland.yst.system.model.entity.SysSettingDO;
import com.elitesland.yst.system.param.SysSettingQParam;
import com.elitesland.yst.system.repo.SysSettingRepo;
import com.elitesland.yst.system.repo.SysSettingRepoProc;
import com.elitesland.yst.system.service.ISysSettingService;
import com.elitesland.yst.system.service.dto.SysSettingDTO;
import com.elitesland.yst.system.vo.SysSettingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SysSettingServiceImpl
implements ISysSettingService {
    private final SysSettingRepo sysSettingRepo;
    private final SysSettingRepoProc sysSettingRepoProc;

    public SysSettingServiceImpl(SysSettingRepo sysSettingRepo, SysSettingRepoProc sysSettingRepoProc) {
        this.sysSettingRepo = sysSettingRepo;
        this.sysSettingRepoProc = sysSettingRepoProc;
    }

    public PagingVO<SysSettingVO> search(SysSettingQParam param) {
        QSysSettingDO settings = QSysSettingDO.sysSettingDO;
        BooleanExpression predicate = settings.isNotNull().or((Predicate)settings.isNull());
        predicate = StrUtil.isBlank((CharSequence)param.getSettingNo()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)settings.settingNo.like("%" + param.getSettingNo() + "%"));
        predicate = CollectionUtils.isEmpty((Collection)param.getSettingNoList()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)settings.settingNo.in((Collection)param.getSettingNoList()));
        predicate = StrUtil.isBlank((CharSequence)param.getSettingName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)settings.settingName.like("%" + param.getSettingName() + "%"));
        predicate = StrUtil.isBlank((CharSequence)param.getSettingDesc()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)settings.settingDesc.like("%" + param.getSettingDesc() + "%"));
        predicate = StrUtil.isBlank((CharSequence)param.getSettingVal()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)settings.settingVal.like("%" + param.getSettingVal() + "%"));
        Page settingRecords = this.sysSettingRepo.findAll((Predicate)predicate, (Pageable)param.getPageRequest());
        List settingVos = settingRecords.getContent().stream().map(SysSettingConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(settingRecords.getTotalElements())).records(settingVos).build();
    }

    @Cacheable(value={"sys-setting"}, key="#root.methodName")
    public List<SysSettingVO> all() {
        return this.sysSettingRepo.findAll().stream().map(SysSettingConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    public SysSettingVO oneById(Long id) {
        return this.sysSettingRepo.findById(id).map(SysSettingConvert.INSTANCE::doToVO).orElse(null);
    }

    public SysSettingVO oneByNo(String no) {
        return this.sysSettingRepo.findBySettingNo(no).map(SysSettingConvert.INSTANCE::doToVO).orElse(null);
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public Long create(SysSettingVO sysSetting) {
        this.sysSettingRepo.findBySettingNo(sysSetting.getSettingNo()).ifPresent(s -> {
            throw new BusinessException("\u914d\u7f6e\uff1a" + s.getSettingNo() + ", \u5df2\u7ecf\u5b58\u5728");
        });
        SysSettingDO newSetting = (SysSettingDO)this.sysSettingRepo.save(SysSettingConvert.INSTANCE.voToDO(sysSetting));
        return newSetting.getId();
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public void update(SysSettingVO sysSettingVO) {
        Optional oldSetting = this.sysSettingRepo.findById(sysSettingVO.getId());
        if (oldSetting.isEmpty()) {
            throw new BusinessException("\u8bbe\u7f6e\uff1a" + sysSettingVO.getSettingNo() + ", \u672a\u627e\u5230");
        }
        SysSettingDO saveSetting = (SysSettingDO)oldSetting.get();
        saveSetting.setSettingVal(sysSettingVO.getSettingVal());
        this.sysSettingRepo.save(saveSetting);
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public void removeByIds(List<Long> ids) {
        this.sysSettingRepo.deleteAllByIdIn(ids);
    }

    @Transactional(rollbackOn={Exception.class})
    @CacheEvict(value={"sys-setting"}, allEntries=true)
    public void removeByNos(List<String> nos) {
        this.sysSettingRepo.deleteAllBySettingNoIn(nos);
    }

    public List<SysSettingDTO> findSettingsBySettingNo(String settingNo) {
        return this.sysSettingRepoProc.findDtosBySettingNo(settingNo);
    }
}

