/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.logInfo.tracking.EventTrackingInterface;
import com.elitesland.yst.core.logInfo.tracking.EventTrackingLogLevelEnum;
import com.elitesland.yst.system.model.entity.SysDataRoleAuthCustomizeDO;
import com.elitesland.yst.system.model.entity.SysDataRoleAuthDO;
import com.elitesland.yst.system.model.entity.SysDataRoleDO;
import com.elitesland.yst.system.model.entity.SysUserDataRoleDO;
import com.elitesland.yst.system.repo.SysDataRoleAuthCustomizeRepo;
import com.elitesland.yst.system.repo.SysDataRoleAuthRepo;
import com.elitesland.yst.system.repo.SysDataRoleRepo;
import com.elitesland.yst.system.repo.SysDataRoleRepoProc;
import com.elitesland.yst.system.repo.SysUserDataRoleRepo;
import com.elitesland.yst.system.repo.SysUserDataRoleRepoProc;
import com.elitesland.yst.system.service.ISysUserDataRoleService;
import com.elitesland.yst.system.service.SysBizDataConstraintService;
import com.elitesland.yst.system.service.dto.SysUserDataRoleDTO;
import com.elitesland.yst.system.util.SysDataRoleAuthCustomizeTypeEnum;
import com.elitesland.yst.system.vo.SysDataAuthVO;
import com.elitesland.yst.system.vo.SysDataRoleAuthScope;
import com.elitesland.yst.system.vo.SysDataRoleVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class SysUserDataRoleServiceImpl
implements ISysUserDataRoleService {
    private static final Logger log = LoggerFactory.getLogger(SysUserDataRoleServiceImpl.class);
    private final SysDataRoleRepo sysDataRoleRepo;
    private final SysDataRoleRepoProc sysDataRoleRepoProc;
    private final SysDataRoleAuthRepo sysDataRoleAuthRepo;
    private final SysUserDataRoleRepo sysUserDataRoleRepo;
    private final SysUserDataRoleRepoProc sysUserDataRoleRepoProc;
    private final SysDataRoleAuthCustomizeRepo sysDataRoleAuthCustomizeRepo;
    static final String BASIC_AUTH = "basic";
    static final String ADVANCED_AUTH = "advanced";
    private final SysBizDataConstraintService sysBizDataConstraintService;
    private final EventTrackingInterface eventTrackingInterface;

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysUserDataRoleDTO> findUserDataRoleDtoByUserIds(List<Long> userIds) {
        return this.sysUserDataRoleRepoProc.findDataRoleIdsByUserIds(userIds);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<Long> findUserIdsByDataRoleLike(String dataRoleCodeName) {
        return this.sysUserDataRoleRepoProc.findUserIdsByDataRoleLike(dataRoleCodeName);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void userDataRoleHardSave(Long userId, List<Long> dataRoleIds) {
        if (userId == null) {
            return;
        }
        this.sysUserDataRoleRepo.deleteByUserId(userId);
        if (CollectionUtils.isNotEmpty(dataRoleIds)) {
            List dos = dataRoleIds.stream().map(dataRoleId -> {
                SysUserDataRoleDO userDataRoleDO = new SysUserDataRoleDO();
                userDataRoleDO.setUserId(userId);
                userDataRoleDO.setRoleId((Long)dataRoleId);
                return userDataRoleDO;
            }).collect(Collectors.toList());
            this.sysUserDataRoleRepo.saveAll(dos);
        }
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
    public Set<SysDataRoleVO> listDataRolesByUserId(Long userId) {
        HashSet<SysDataRoleVO> set = new HashSet<SysDataRoleVO>();
        List<SysUserDataRoleDO> sysUserRoleDOS = this.sysUserDataRoleRepo.findByUserId(userId);
        if (CollectionUtils.isNotEmpty(sysUserRoleDOS)) {
            List<Long> roleIdS = sysUserRoleDOS.stream().map(SysUserDataRoleDO::getRoleId).collect(Collectors.toList());
            List sysDataRoleDOS = this.sysDataRoleRepo.findAllById(roleIdS);
            List<SysDataRoleAuthCustomizeDO> sysDataRoleAuthCustomizeDOS = null;
            List<SysDataRoleAuthDO> sysDataRoleAuthDOS = null;
            Object sysBizDataConstraintVO = null;
            if (CollectionUtils.isNotEmpty((Collection)sysDataRoleDOS) && CollectionUtils.isNotEmpty(sysDataRoleAuthDOS = this.sysDataRoleAuthRepo.findByDataRoleIdIn(roleIdS))) {
                List<Long> roleAuthIdS = sysDataRoleAuthDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
                sysDataRoleAuthCustomizeDOS = this.sysDataRoleAuthCustomizeRepo.findByDataRoleAuthIdIn(roleAuthIdS);
            }
            for (SysDataRoleDO sysDataRoleDO : sysDataRoleDOS) {
                if (sysDataRoleDO.getEnabled() == null || !sysDataRoleDO.getEnabled().booleanValue()) continue;
                SysDataRoleVO sysDataRoleVO = new SysDataRoleVO();
                sysDataRoleVO.setId(sysDataRoleDO.getId());
                sysDataRoleVO.setCode(sysDataRoleDO.getCode());
                sysDataRoleVO.setName(sysDataRoleDO.getName());
                sysDataRoleVO.setAdvancedEnable(sysDataRoleDO.getAdvancedEnable());
                sysDataRoleVO.setBusinessEnable(sysDataRoleDO.getBusinessEnable());
                sysDataRoleVO.setEnabled(sysDataRoleDO.getEnabled());
                this.setSysDataAuthVO(sysDataRoleVO, sysDataRoleAuthDOS, sysDataRoleDO, sysDataRoleAuthCustomizeDOS);
                this.setBizDataConstraintVO(sysDataRoleVO, sysDataRoleDO);
                set.add(sysDataRoleVO);
            }
        }
        return set;
    }

    private void setBizDataConstraintVO(SysDataRoleVO sysDataRoleVO, SysDataRoleDO sysDataRoleDO) {
        List sysBizDataConstraintVOS = this.sysBizDataConstraintService.listByRoleCode(sysDataRoleDO.getCode());
        sysDataRoleVO.setSysBizDataConstraintVO(sysBizDataConstraintVOS);
    }

    private void setSysDataAuthVO(SysDataRoleVO sysDataRoleVO, List<SysDataRoleAuthDO> sysDataRoleAuthDOS, SysDataRoleDO sysDataRoleDO, List<SysDataRoleAuthCustomizeDO> sysDataRoleAuthCustomizeDOS) {
        Map<String, List<SysDataAuthVO>> sysDataAuthVO;
        if (CollectionUtils.isNotEmpty(sysDataRoleAuthDOS) && MapUtils.isNotEmpty(sysDataAuthVO = this.getSysDataRoleAuth(sysDataRoleDO, sysDataRoleAuthDOS, sysDataRoleAuthCustomizeDOS))) {
            List<SysDataAuthVO> sysDataAuthAppVOS;
            List<SysDataAuthVO> sysDataAuthBasicVOS = sysDataAuthVO.get(BASIC_AUTH);
            if (CollectionUtils.isNotEmpty(sysDataAuthBasicVOS)) {
                sysDataRoleVO.setSysDataAuthVO(sysDataAuthBasicVOS.get(0));
            }
            if (sysDataRoleDO.getAdvancedEnable() != null && sysDataRoleDO.getAdvancedEnable().booleanValue() && CollectionUtils.isNotEmpty(sysDataAuthAppVOS = sysDataAuthVO.get(ADVANCED_AUTH))) {
                Map<String, SysDataAuthVO> sysDataRoleAuthListHashMap = this.getSysDataAuthAppMap(sysDataAuthAppVOS);
                sysDataRoleVO.setStringSysDataPermissionVOMap(sysDataRoleAuthListHashMap);
            }
        }
    }

    private Map<String, SysDataAuthVO> getSysDataAuthAppMap(List<SysDataAuthVO> sysDataAuthAppVOS) {
        HashMap<String, SysDataAuthVO> sysDataRoleAuthListHashMap = new HashMap<String, SysDataAuthVO>();
        for (SysDataAuthVO sysDataAuthVOS : sysDataAuthAppVOS) {
            String permissionCode = sysDataAuthVOS.getPermissionCode();
            if (permissionCode == null || permissionCode.length() == 0) {
                log.warn("\u9ad8\u7ea7\u6743\u9650permissionCode\u5e94\u7528\u7f16\u7801\u7a7a?\u5c06\u8df3\u8fc7\u6743\u9650.{}", (Object)sysDataAuthVOS);
                this.eventTrackingInterface.addEventTracking(EventTrackingLogLevelEnum.ERROR, "\u9ad8\u7ea7\u6743\u9650permissionCode\u5e94\u7528\u7f16\u7801\u7a7a?\u5c06\u8df3\u8fc7\u6743\u9650.{}", new Object[]{sysDataAuthVOS});
                continue;
            }
            if (sysDataRoleAuthListHashMap.containsKey(permissionCode)) {
                log.warn("\u9ad8\u7ea7\u6743\u9650permissionCode\u5e94\u7528\u7f16\u7801\u91cd\u590d?\u5c06\u8df3\u8fc7\u53d6\u7528.{}", (Object)sysDataAuthVOS);
                this.eventTrackingInterface.addEventTracking(EventTrackingLogLevelEnum.ERROR, "\u9ad8\u7ea7\u6743\u9650permissionCode\u5e94\u7528\u7f16\u7801\u7a7a?\u5c06\u8df3\u8fc7\u6743\u9650.{}", new Object[]{sysDataAuthVOS});
                continue;
            }
            sysDataRoleAuthListHashMap.put(permissionCode, sysDataAuthVOS);
        }
        return sysDataRoleAuthListHashMap;
    }

    private Map<String, List<SysDataAuthVO>> getSysDataRoleAuth(SysDataRoleDO sysDataRoleDO, List<SysDataRoleAuthDO> sysDataRoleAuthDOS, List<SysDataRoleAuthCustomizeDO> sysDataRoleAuthCustomizeDOS) {
        if (CollectionUtils.isEmpty(sysDataRoleAuthDOS)) {
            return Collections.emptyMap();
        }
        List<SysDataRoleAuthDO> thisSysDataAuth = sysDataRoleAuthDOS.stream().collect(Collectors.groupingBy(SysDataRoleAuthDO::getDataRoleId)).get(sysDataRoleDO.getId());
        if (CollectionUtils.isEmpty(thisSysDataAuth)) {
            return Collections.emptyMap();
        }
        Map<Boolean, List<SysDataRoleAuthDO>> roleAuthIsBasicListMap = thisSysDataAuth.stream().collect(Collectors.groupingBy(SysDataRoleAuthDO::getIsBasic));
        HashMap<String, List<SysDataAuthVO>> listMap = new HashMap<String, List<SysDataAuthVO>>();
        Map<Long, List<SysDataRoleAuthCustomizeDO>> sysDataRoleAuthCustomizeDOHashMap = sysDataRoleAuthCustomizeDOS.stream().collect(Collectors.groupingBy(SysDataRoleAuthCustomizeDO::getDataRoleAuthId));
        List<SysDataRoleAuthDO> roleAuthBasic = roleAuthIsBasicListMap.get(true);
        if (CollectionUtils.isEmpty(roleAuthBasic)) {
            listMap.put(BASIC_AUTH, null);
        } else {
            if (roleAuthBasic.size() != 1) {
                String message = "\u63d0\u9192\uff1a{}-{}-{}\u6570\u636e\u89d2\u8272\u591a\u4e2a\u57fa\u7840\u6570\u636e\u6743\u9650\u914d\u7f6e\uff0c\u76ee\u524d\u53d6\u7b2c\u4e00\u4e2a\u3002\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01";
                log.warn(message, new Object[]{sysDataRoleDO.getId(), sysDataRoleDO.getCode(), sysDataRoleDO.getName()});
                this.eventTrackingInterface.addEventTracking(EventTrackingLogLevelEnum.ERROR, message, new Object[]{sysDataRoleDO.getId(), sysDataRoleDO.getCode(), sysDataRoleDO.getName()});
            }
            SysDataRoleAuthDO sysDataRoleAuthDO = roleAuthBasic.get(0);
            SysDataAuthVO sysDataAuthVO = this.sysDataRoleAuthDOToVO(sysDataRoleAuthDO, sysDataRoleAuthCustomizeDOHashMap);
            ArrayList<SysDataAuthVO> list = new ArrayList<SysDataAuthVO>();
            list.add(sysDataAuthVO);
            listMap.put(BASIC_AUTH, list);
        }
        List<SysDataRoleAuthDO> roleAuthApp = roleAuthIsBasicListMap.get(false);
        if (CollectionUtils.isEmpty(roleAuthApp)) {
            listMap.put(ADVANCED_AUTH, null);
        } else {
            ArrayList<SysDataAuthVO> appAuthList = new ArrayList<SysDataAuthVO>();
            for (SysDataRoleAuthDO sysDataRoleAuthDO : roleAuthApp) {
                SysDataAuthVO sysDataAuthVO = this.sysDataRoleAuthDOToVO(sysDataRoleAuthDO, sysDataRoleAuthCustomizeDOHashMap);
                appAuthList.add(sysDataAuthVO);
            }
            listMap.put(ADVANCED_AUTH, appAuthList);
        }
        return listMap;
    }

    private SysDataAuthVO sysDataRoleAuthDOToVO(SysDataRoleAuthDO sysDataRoleAuthDO, Map<Long, List<SysDataRoleAuthCustomizeDO>> sysDataRoleAuthCustomizeDOHashMap) {
        SysDataAuthVO sysDataAuthVO = new SysDataAuthVO();
        sysDataAuthVO.setIsAll(sysDataRoleAuthDO.getIsPermitAll());
        sysDataAuthVO.setIsBasic(sysDataRoleAuthDO.getIsBasic());
        sysDataAuthVO.setDataRoleId(sysDataRoleAuthDO.getDataRoleId());
        sysDataAuthVO.setPermissionCode(sysDataRoleAuthDO.getPermissionCode());
        sysDataAuthVO.setBuAuthEnable(sysDataRoleAuthDO.getBuAuthEnable());
        if (StringUtils.isBlank((CharSequence)sysDataRoleAuthDO.getBuAuthScope())) {
            sysDataAuthVO.setBuDataAuthScope(null);
        } else {
            sysDataAuthVO.setBuDataAuthScope(SysDataRoleAuthScope.valueOf((String)sysDataRoleAuthDO.getBuAuthScope()));
        }
        sysDataAuthVO.setEmpAuthEnable(sysDataRoleAuthDO.getEmpAuthEnable());
        if (StringUtils.isBlank((CharSequence)sysDataRoleAuthDO.getEmpAuthScope())) {
            sysDataAuthVO.setUserDataAuthScope(null);
        } else {
            sysDataAuthVO.setUserDataAuthScope(SysDataRoleAuthScope.valueOf((String)sysDataRoleAuthDO.getEmpAuthScope()));
        }
        sysDataAuthVO.setOuAuthEnable(sysDataRoleAuthDO.getOuAuthEnable());
        List<SysDataRoleAuthCustomizeDO> thisSysDataRoleAuthCustomizeDOS = sysDataRoleAuthCustomizeDOHashMap.get(sysDataRoleAuthDO.getId());
        if (thisSysDataRoleAuthCustomizeDOS != null) {
            Map<String, List<SysDataRoleAuthCustomizeDO>> authCustomizeTypeGroupMap = thisSysDataRoleAuthCustomizeDOS.stream().collect(Collectors.groupingBy(SysDataRoleAuthCustomizeDO::getCustomizeType));
            List<SysDataRoleAuthCustomizeDO> buAuthList = authCustomizeTypeGroupMap.get(SysDataRoleAuthCustomizeTypeEnum.BU.name());
            List<SysDataRoleAuthCustomizeDO> empAuthList = authCustomizeTypeGroupMap.get(SysDataRoleAuthCustomizeTypeEnum.EMP.name());
            List<SysDataRoleAuthCustomizeDO> ouAuthList = authCustomizeTypeGroupMap.get(SysDataRoleAuthCustomizeTypeEnum.OU.name());
            if (sysDataRoleAuthDO.getBuCustomizeEnable() != null && sysDataRoleAuthDO.getBuCustomizeEnable().booleanValue() && CollectionUtils.isNotEmpty(buAuthList)) {
                sysDataAuthVO.setBuIdSet((Set)buAuthList.stream().map(SysDataRoleAuthCustomizeDO::getSecId).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new)));
            }
            if (sysDataRoleAuthDO.getEmpCustomizeEnable() != null && sysDataRoleAuthDO.getEmpCustomizeEnable().booleanValue() && CollectionUtils.isNotEmpty(empAuthList)) {
                sysDataAuthVO.setUserIdSet((Set)empAuthList.stream().map(SysDataRoleAuthCustomizeDO::getSecId).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new)));
            }
            if (sysDataRoleAuthDO.getOuCustomizeEnable() != null && sysDataRoleAuthDO.getOuCustomizeEnable().booleanValue() && CollectionUtils.isNotEmpty(ouAuthList)) {
                sysDataAuthVO.setOuIdSet((Set)ouAuthList.stream().map(SysDataRoleAuthCustomizeDO::getSecId).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new)));
            }
        }
        return sysDataAuthVO;
    }

    private SysDataAuthVO getBasicSysDataPermissionVO() {
        SysDataAuthVO sysDataAuthVO = new SysDataAuthVO();
        sysDataAuthVO.setIsAll(Boolean.valueOf(true));
        HashSet<Integer> buSet = new HashSet<Integer>();
        buSet.add(1);
        buSet.add(3);
        buSet.add(2);
        sysDataAuthVO.setBuIdSet(buSet);
        HashSet<Integer> userSet = new HashSet<Integer>();
        userSet.add(1);
        userSet.add(3);
        userSet.add(2);
        sysDataAuthVO.setUserIdSet(userSet);
        return sysDataAuthVO;
    }

    public SysUserDataRoleServiceImpl(SysDataRoleRepo sysDataRoleRepo, SysDataRoleRepoProc sysDataRoleRepoProc, SysDataRoleAuthRepo sysDataRoleAuthRepo, SysUserDataRoleRepo sysUserDataRoleRepo, SysUserDataRoleRepoProc sysUserDataRoleRepoProc, SysDataRoleAuthCustomizeRepo sysDataRoleAuthCustomizeRepo, SysBizDataConstraintService sysBizDataConstraintService, EventTrackingInterface eventTrackingInterface) {
        this.sysDataRoleRepo = sysDataRoleRepo;
        this.sysDataRoleRepoProc = sysDataRoleRepoProc;
        this.sysDataRoleAuthRepo = sysDataRoleAuthRepo;
        this.sysUserDataRoleRepo = sysUserDataRoleRepo;
        this.sysUserDataRoleRepoProc = sysUserDataRoleRepoProc;
        this.sysDataRoleAuthCustomizeRepo = sysDataRoleAuthCustomizeRepo;
        this.sysBizDataConstraintService = sysBizDataConstraintService;
        this.eventTrackingInterface = eventTrackingInterface;
    }
}

