/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.system.model.entity.SysUserFlowRoleDO;
import com.elitesland.yst.system.repo.SysUserFlowRoleRepo;
import com.elitesland.yst.system.repo.SysUserFlowRoleRepoProc;
import com.elitesland.yst.system.service.ISysUserFlowRoleService;
import com.elitesland.yst.system.service.dto.SysUserFlowRoleDTO;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class SysUserFlowRoleServiceImpl
implements ISysUserFlowRoleService {
    private static final Logger log = LoggerFactory.getLogger(SysUserFlowRoleServiceImpl.class);
    private final SysUserFlowRoleRepo sysUserFlowRoleRepo;
    private final SysUserFlowRoleRepoProc sysUserFlowRoleRepoProc;

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysUserFlowRoleDTO> findUserFlowRoleDtoByUserIds(List<Long> userIds) {
        return this.sysUserFlowRoleRepoProc.findDataRoleIdsByUserIds(userIds);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<Long> findUserIdsByFlowRoleLike(String flowRoleCodeName) {
        return this.sysUserFlowRoleRepoProc.findUserIdsByFlowRoleLike(flowRoleCodeName);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void userFlowRoleHardSave(Long userId, List<Long> flowRoleIds) {
        if (userId == null) {
            return;
        }
        this.sysUserFlowRoleRepo.deleteByUserId(userId);
        if (CollectionUtils.isNotEmpty(flowRoleIds)) {
            List dos = flowRoleIds.stream().map(flowRoleId -> {
                SysUserFlowRoleDO userFlowRoleDO = new SysUserFlowRoleDO();
                userFlowRoleDO.setUserId(userId);
                userFlowRoleDO.setRoleId((Long)flowRoleId);
                return userFlowRoleDO;
            }).collect(Collectors.toList());
            this.sysUserFlowRoleRepo.saveAll(dos);
        }
    }

    public List<Long> findUserIdsByFlowRoleCodes(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Collections.emptyList();
        }
        List<String> codes = roleCodes.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        return this.sysUserFlowRoleRepoProc.findUserIdsByFlowRoleCodes(codes);
    }

    public Map<Long, List<Long>> queryIdsByUserId(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        return this.sysUserFlowRoleRepoProc.getByUserId(userIds);
    }

    public SysUserFlowRoleServiceImpl(SysUserFlowRoleRepo sysUserFlowRoleRepo, SysUserFlowRoleRepoProc sysUserFlowRoleRepoProc) {
        this.sysUserFlowRoleRepo = sysUserFlowRoleRepo;
        this.sysUserFlowRoleRepoProc = sysUserFlowRoleRepoProc;
    }
}

