/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseViewModel;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.system.convert.SysRoleConvert;
import com.elitesland.yst.system.convert.SysUserConvert;
import com.elitesland.yst.system.convert.SysUserRoleConvert;
import com.elitesland.yst.system.entity.QSysUserDO;
import com.elitesland.yst.system.entity.SysUserDO;
import com.elitesland.yst.system.model.entity.QSysRoleDO;
import com.elitesland.yst.system.model.entity.QSysUserRoleDO;
import com.elitesland.yst.system.model.entity.SysRoleDO;
import com.elitesland.yst.system.param.SysUserUpdateParam;
import com.elitesland.yst.system.repo.SysRoleRepo;
import com.elitesland.yst.system.repo.SysUserRepo;
import com.elitesland.yst.system.repo.SysUserRoleRepo;
import com.elitesland.yst.system.repo.SysUserRoleRepoProc;
import com.elitesland.yst.system.service.ISysUserRoleService;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.dto.SysUserRoleDTO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserRoleVO;
import com.elitesland.yst.system.vo.SysUserVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
public class SysUserRoleServiceImpl
implements ISysUserRoleService {
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private SysUserRepo sysUserRepo;
    private SysUserRoleRepo sysUserRoleRepo;
    private SysRoleRepo sysRoleRepo;
    private SysUserRoleRepoProc sysUserRoleRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private ISysUserService iSysUserService;
    private final QSysUserRoleDO userRoles = QSysUserRoleDO.sysUserRoleDO;
    private final QSysUserDO users = QSysUserDO.sysUserDO;
    private final QSysRoleDO roles = QSysRoleDO.sysRoleDO;

    @Autowired
    public void setJpaQueryFactory(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    @Autowired
    public void setSysUserRoleRepo(SysUserRoleRepo sysUserRoleRepo) {
        this.sysUserRoleRepo = sysUserRoleRepo;
    }

    @Autowired
    public void setSysUserRoleRepoProc(SysUserRoleRepoProc sysUserRoleRepoProc) {
        this.sysUserRoleRepoProc = sysUserRoleRepoProc;
    }

    @Autowired
    public void setISysUserService(ISysUserService iSysUserService) {
        this.iSysUserService = iSysUserService;
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysUserRoleDTO> findUserRoleDtoByUserIds(List<Long> userIds) {
        return this.sysUserRoleRepoProc.findUserRoleDtoByUserIds(userIds);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<Long> findUserIdsByRoleLike(String roleCodeName) {
        return this.sysUserRoleRepoProc.findUserIdsByRoleLike(roleCodeName);
    }

    public Set<SysUserVO> listUsersByRoleId(Long roleId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.users).from((EntityPath)this.users)).leftJoin((EntityPath)this.userRoles)).on((Predicate)this.userRoles.userId.eq((Expression)this.users.id))).where((Predicate)this.userRoles.roleId.eq((Object)roleId))).fetch().stream().map(SysUserConvert.INSTANCE::doToVo).collect(Collectors.toSet());
    }

    public Map<Long, Set<SysUserVO>> listUsersByRoleIds(List<Long> roleIds) {
        List roleUserTuples = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.userRoles.roleId, this.users}).from((EntityPath)this.users)).leftJoin((EntityPath)this.userRoles)).on((Predicate)this.userRoles.userId.eq((Expression)this.users.id))).where((Predicate)this.userRoles.roleId.in(roleIds))).fetch();
        return roleUserTuples.stream().collect(Collectors.groupingBy(t -> (Long)t.get(0, Long.class), Collectors.mapping(t -> SysUserConvert.INSTANCE.doToVo((SysUserDO)t.get(1, SysUserDO.class)), Collectors.toSet())));
    }

    public Set<SysRoleVO> listRolesByUserId(Long userId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.roles).from((EntityPath)this.roles)).leftJoin((EntityPath)this.userRoles)).on((Predicate)this.userRoles.roleId.eq(this.roles.id))).where((Predicate)this.userRoles.userId.eq((Object)userId))).fetch().stream().map(SysRoleConvert.INSTANCE::doToVo).collect(Collectors.toSet());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT_USER)
    public Set<SysRoleVO> listDistinctRolesByUserIds(List<Long> userIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)this.roles).from((EntityPath)this.roles)).innerJoin((EntityPath)this.userRoles)).on((Predicate)this.userRoles.roleId.eq(this.roles.id).and((Predicate)this.userRoles.userId.in(userIds)))).fetch().stream().map(SysRoleConvert.INSTANCE::doToVo).collect(Collectors.toSet());
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public Map<Long, Set<SysRoleVO>> listRolesByUserIds(List<Long> userIds) {
        List userRoleTuples = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.userRoles.userId, this.roles}).from((EntityPath)this.roles)).leftJoin((EntityPath)this.userRoles)).on((Predicate)this.userRoles.roleId.eq(this.roles.id))).where((Predicate)this.userRoles.userId.in(userIds))).fetch();
        return userRoleTuples.stream().collect(Collectors.groupingBy(t -> (Long)t.get(0, Long.class), Collectors.mapping(t -> SysRoleConvert.INSTANCE.doToVo((SysRoleDO)t.get(1, SysRoleDO.class)), Collectors.toSet())));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void saveAll(List<SysUserRoleVO> userRoles) {
        List<Long> ids = userRoles.stream().filter(ur -> ur.getId() != null && ur.getId() > 0L).map(BaseViewModel::getId).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            this.sysUserRoleRepo.deleteAllByIdIn(ids);
        }
        this.sysUserRoleRepo.saveAll(userRoles.stream().map(SysUserRoleConvert.INSTANCE::voToDO).collect(Collectors.toList()));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void removeUsersByRoleIds(List<Long> roleIds) {
        this.sysUserRoleRepo.deleteAllByRoleIdIn(roleIds);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public void removeRolesByUserIds(List<Long> userIds) {
        this.sysUserRoleRepo.deleteAllByUserIdIn(userIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateReole(SysUserUpdateParam userUpdateParam) {
        this.iSysUserService.updateReole(userUpdateParam);
    }

    public void updateUserStart(SysUserUpdateParam user) {
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Optional userOpt = this.sysUserRepo.findById(user.getId());
            if (userOpt.isEmpty()) {
                throw new BusinessException(ApiCode.FAIL, "ID\u4e3a\uff1a" + user.getId() + "\uff0c\u7684\u7528\u6237\u4e0d\u5b58\u5728");
            }
            SysUserDO userOpts = (SysUserDO)userOpt.get();
            userOpts.setEnabled(user.getEnabled());
            this.sysUserRepo.save(userOpts);
            return null;
        });
    }
}

