/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitesland.cloudt.authorization.core.SecurityContextUtil;
import com.elitesland.cloudt.context.spi.ServiceProviderLoader;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.constant.Terminal;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.common.util.EncryptUtils;
import com.elitesland.yst.common.util.RedisUtils;
import com.elitesland.yst.coord.messenger.sender.provider.MsgCarrierDubboService;
import com.elitesland.yst.coord.messenger.sender.provider.param.GeneralDubboCarrier;
import com.elitesland.yst.core.annotation.TenantTransaction;
import com.elitesland.yst.core.annotation.common.TenantIsolateType;
import com.elitesland.yst.core.provider.tenant.TenantDataIsolateProvider;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.component.PermissionWithRoleCacheService;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.event.OnlineUserInfoChangeEvent;
import com.elitesland.yst.security.config.CustomSecurityProperties;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.convert.SysRolePermissionConvert;
import com.elitesland.yst.system.convert.SysUserConvert;
import com.elitesland.yst.system.dto.SysTenantDTO;
import com.elitesland.yst.system.entity.QSysUserDO;
import com.elitesland.yst.system.entity.SysUserDO;
import com.elitesland.yst.system.manager.UserPermissionManager;
import com.elitesland.yst.system.manager.VerifyCodeManager;
import com.elitesland.yst.system.model.entity.SysUserCompanyDO;
import com.elitesland.yst.system.param.SysPasswordUpdate;
import com.elitesland.yst.system.param.SysPhoneUpdate;
import com.elitesland.yst.system.param.SysUserBatchSwitchParam;
import com.elitesland.yst.system.param.SysUserNewParam;
import com.elitesland.yst.system.param.SysUserQueryParam;
import com.elitesland.yst.system.param.SysUserUpdateParam;
import com.elitesland.yst.system.provider.dto.SysUserRpcDTO;
import com.elitesland.yst.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.system.provider.repo.SysUserRpcRepoProc;
import com.elitesland.yst.system.repo.SysRoleRepo;
import com.elitesland.yst.system.repo.SysUserCompanyRepo;
import com.elitesland.yst.system.repo.SysUserCompanyRepoProc;
import com.elitesland.yst.system.repo.SysUserRepo;
import com.elitesland.yst.system.repo.SysUserRepoProc;
import com.elitesland.yst.system.service.ISysDataRoleService;
import com.elitesland.yst.system.service.ISysFlowRoleService;
import com.elitesland.yst.system.service.ISysRolePermissionService;
import com.elitesland.yst.system.service.ISysRoleService;
import com.elitesland.yst.system.service.ISysSettingService;
import com.elitesland.yst.system.service.ISysUserDataRoleService;
import com.elitesland.yst.system.service.ISysUserFlowRoleService;
import com.elitesland.yst.system.service.ISysUserRoleService;
import com.elitesland.yst.system.service.ISysUserService;
import com.elitesland.yst.system.service.SysUserProxyService;
import com.elitesland.yst.system.service.SysUserTerminalService;
import com.elitesland.yst.system.service.dto.SysSettingDTO;
import com.elitesland.yst.system.service.dto.SysUserDataRoleDTO;
import com.elitesland.yst.system.service.dto.SysUserFlowRoleDTO;
import com.elitesland.yst.system.service.dto.SysUserRoleDTO;
import com.elitesland.yst.system.service.param.SysAccountUpdateParam;
import com.elitesland.yst.system.service.param.SysPasswordUpdateParam;
import com.elitesland.yst.system.service.param.SysSendVerifyCodeParam;
import com.elitesland.yst.system.service.param.SysUserAvatarUpdateParam;
import com.elitesland.yst.system.service.param.SysUserPagingParam;
import com.elitesland.yst.system.service.param.SysVerifyCodeParam;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.service.vo.SysUserPagingVO;
import com.elitesland.yst.system.spi.SysUserLoginSpi;
import com.elitesland.yst.system.spi.SysUserServiceSpi;
import com.elitesland.yst.system.vo.SysPermissionWithRoleVO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.elitesland.yst.system.vo.SysUserDetailsVO;
import com.elitesland.yst.system.vo.SysUserRoleVO;
import com.elitesland.yst.system.vo.SysUserVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class SysUserServiceImpl
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    private static final Long FIXED_ROOT_ID = 0L;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    @Autowired
    private CustomSecurityProperties securityProperties;
    @Autowired
    private SysUserCompanyRepo userCompanyRepo;
    @Autowired
    private SysUserCompanyRepoProc userCompanyRepoProc;
    @Autowired
    private SysUserRepo sysUserRepo;
    @Autowired
    private SysRoleRepo sysRoleRepo;
    @Autowired
    private SysUserRepoProc sysUserRepoProc;
    @Autowired
    private SysUserRpcRepoProc sysUserRpcRepoProc;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserDataRoleService sysUserDataRoleService;
    @Autowired
    private ISysUserFlowRoleService sysUserFlowRoleService;
    @Autowired
    private ISysRolePermissionService sysRolePermissionService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ISysSettingService sysSettingService;
    @Autowired
    private PermissionWithRoleCacheService permissionWithRoleCacheService;
    @Autowired
    private UserPermissionManager userPermissionManager;
    private AtomicBoolean userLoginSpiLoaded = new AtomicBoolean(false);
    private List<SysUserLoginSpi> userLoginSpiList = new ArrayList<SysUserLoginSpi>();
    private AtomicBoolean userServiceSpiLoaded = new AtomicBoolean(false);
    private List<SysUserServiceSpi> userServiceSpiList = new ArrayList<SysUserServiceSpi>();
    @Autowired
    private SysUserProxyService sysUserProxyService;
    @Autowired(required=false)
    private FileService fileService;
    @Lazy
    @Autowired
    private SysUserTerminalService userTerminalService;
    @DubboReference
    private MsgCarrierDubboService msgCarrierDubboService;
    @Autowired
    private VerifyCodeManager verifyCodeManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysDataRoleService dataRoleService;
    @Autowired
    private ISysFlowRoleService flowRoleService;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    private static final Logger logger = LoggerFactory.getLogger(SysUserServiceImpl.class);

    public PagingVO<SysUserVO> search(SysUserQueryParam param) {
        PagingVO<SysUserDO> users = this.sysUserRepoProc.selectSysUser(param);
        List records = users.getRecords();
        if (records == null || records.isEmpty()) {
            return PagingVO.builder().build();
        }
        List userIds = records.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map userRoles = this.sysUserRoleService.listRolesByUserIds(userIds);
        List userVos = users.getRecords().stream().map(u -> {
            SysUserVO userVo = SysUserConvert.INSTANCE.doToVo((SysUserDO)u);
            if (userRoles.containsKey(u.getId())) {
                userVo.setRoleNames(((Set)userRoles.get(u.getId())).stream().map(SysRoleVO::getName).collect(Collectors.joining(",")));
            }
            return userVo;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(users.getTotal()).records(userVos).build();
    }

    public PagingVO<SysUserPagingVO> findPaging(SysUserPagingParam param) {
        PagingVO<SysUserPagingVO> result;
        List userIds;
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
        }
        ArrayList roleUserIds = null;
        if (StringUtils.isNotBlank((CharSequence)param.getRoleCodeName())) {
            roleUserIds = this.sysUserRoleService.findUserIdsByRoleLike(param.getRoleCodeName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getDataRoleCodeName())) {
            userIds = this.sysUserDataRoleService.findUserIdsByDataRoleLike(param.getDataRoleCodeName());
            if (roleUserIds == null) {
                roleUserIds = new ArrayList(userIds);
            } else {
                roleUserIds.retainAll(userIds);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getFlowRoleCodeName())) {
            userIds = this.sysUserFlowRoleService.findUserIdsByFlowRoleLike(param.getFlowRoleCodeName());
            if (roleUserIds == null) {
                roleUserIds = new ArrayList(userIds);
            } else {
                roleUserIds.retainAll(userIds);
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(result = this.sysUserRepoProc.findPaging(param, roleUserIds)).getRecords())) {
            List userIds2 = result.getRecords().stream().map(SysUserPagingVO::getId).collect(Collectors.toList());
            Map<Long, List<SysUserRoleDTO>> userRoleDtoMap = this.sysUserRoleService.findUserRoleDtoByUserIds(userIds2).stream().collect(Collectors.groupingBy(SysUserRoleDTO::getUserId));
            Map<Long, List<SysUserDataRoleDTO>> userDataRoleDtoMap = this.sysUserDataRoleService.findUserDataRoleDtoByUserIds(userIds2).stream().collect(Collectors.groupingBy(SysUserDataRoleDTO::getUserId));
            Map<Long, List<SysUserFlowRoleDTO>> userFlowRoleDtoMap = this.sysUserFlowRoleService.findUserFlowRoleDtoByUserIds(userIds2).stream().collect(Collectors.groupingBy(SysUserFlowRoleDTO::getUserId));
            Map userCompanyMap = (Map)this.tenantDataIsolateProvider.byTenant(() -> this.userCompanyRepoProc.queryByUserIds(new HashSet<Long>(userIds2)).stream().collect(Collectors.toMap(SysUserCompanyDO::getSysUserId, t -> t, (t1, t2) -> t1)), currentUser.getUser());
            result.getRecords().forEach(vo -> {
                SysUserCompanyDO company;
                if (userRoleDtoMap.containsKey(vo.getId())) {
                    vo.setRoleNames(((List)userRoleDtoMap.get(vo.getId())).stream().map(SysUserRoleDTO::getRoleName).collect(Collectors.joining(",")));
                }
                if (userDataRoleDtoMap.containsKey(vo.getId())) {
                    vo.setDataRoleNames(((List)userDataRoleDtoMap.get(vo.getId())).stream().map(SysUserDataRoleDTO::getDataRoleName).collect(Collectors.joining(",")));
                }
                if (userFlowRoleDtoMap.containsKey(vo.getId())) {
                    vo.setFlowRoleNames(((List)userFlowRoleDtoMap.get(vo.getId())).stream().map(SysUserFlowRoleDTO::getFlowRoleName).collect(Collectors.joining(",")));
                }
                if ((company = (SysUserCompanyDO)((Object)((Object)userCompanyMap.get(vo.getId())))) != null) {
                    vo.setOuId(company.getOuId());
                    vo.setOuCode(company.getOuCode());
                    vo.setOuName(company.getOuName());
                }
            });
        }
        return result;
    }

    public SysUserDetailsVO findDetailsById(Long id) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
        }
        SysUserDetailsVO detailsVO = this.sysUserRepoProc.findDetailsById(id);
        if (detailsVO != null) {
            this.tenantDataIsolateProvider.byTenant(() -> {
                SysUserCompanyDO userCompany;
                detailsVO.setRoleIds(this.sysUserRoleService.findUserRoleDtoByUserIds(Collections.singletonList(id)).stream().map(role -> role.getRoleId().toString()).collect(Collectors.toList()));
                detailsVO.setDataRoleIds(this.sysUserDataRoleService.findUserDataRoleDtoByUserIds(Collections.singletonList(id)).stream().map(dataRole -> dataRole.getDataRoleId().toString()).collect(Collectors.toList()));
                detailsVO.setFlowRoleIds(this.sysUserFlowRoleService.findUserFlowRoleDtoByUserIds(Collections.singletonList(id)).stream().map(flowRole -> flowRole.getFlowRoleId().toString()).collect(Collectors.toList()));
                ApiResult userTerminal = this.userTerminalService.getByUser(id);
                if (CollUtil.isNotEmpty((Collection)((Collection)userTerminal.getData()))) {
                    detailsVO.setTerminals((List)userTerminal.getData());
                }
                if ((userCompany = this.userCompanyRepoProc.queryByUserId(id)) != null) {
                    detailsVO.setOuId(userCompany.getOuId());
                    detailsVO.setOuCode(userCompany.getOuCode());
                    detailsVO.setOuName(userCompany.getOuName());
                }
                return null;
            }, currentUser.getUser());
        }
        return detailsVO;
    }

    public SysUserDTO getById(Long id) {
        return this.sysUserRepo.findById(id).map(u -> {
            SysUserDTO userDto = SysUserConvert.INSTANCE.doToDto((SysUserDO)u);
            Set roles = this.sysUserRoleService.listRolesByUserId(u.getId());
            List roleIds = roles.stream().map(SysRoleVO::getId).collect(Collectors.toList());
            Map permissions = this.sysRolePermissionService.listPermissionsByRoleIds(roleIds);
            userDto.setRoles(roles).setPermissions(permissions);
            return userDto;
        }).orElse(null);
    }

    public List<SysUserVO> getByIds(List<Long> ids) {
        return this.sysUserRepo.findAllByIdIn(ids).stream().map(SysUserConvert.INSTANCE::doToVo).collect(Collectors.toList());
    }

    public SysUserDTO getUserByUsername(String username) {
        return this.queryUserDtoOne(() -> this.sysUserRepo.findByUsername(username).map(List::of).orElse(Collections.emptyList()), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237\u540d");
        });
    }

    public SysUserDTO getUserByMobile(String mobile) {
        return this.queryUserDtoOne(() -> this.sysUserRepo.findByMobile(mobile), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u624b\u673a\u53f7");
        });
    }

    public SysUserDTO getUserByEmail(String email) {
        return this.queryUserDtoOne(() -> this.sysUserRepoProc.queryByEmail(email), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u90ae\u7bb1");
        });
    }

    public SysUserDTO getUserById(Long id) {
        return this.queryUserDtoOne(() -> this.sysUserRepo.findById(id).map(List::of).orElse(Collections.emptyList()), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237ID");
        });
    }

    public SysUserDTO getUserByAccount(String account) {
        return this.queryUserDtoOne(() -> this.sysUserRepoProc.queryByAccount(account), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u8d26\u53f7");
        });
    }

    public SysUserDTO getUserByWechatOpenid(String wechatOpenid) {
        return this.queryUserDtoOne(() -> this.sysUserRepo.findByWxOpenid(wechatOpenid), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u5fae\u4fe1\u7ed1\u5b9a");
        });
    }

    private SysUserDTO queryUserDtoOne(Supplier<List<SysUserDO>> usersSupplier, Function<List<SysUserDO>, SysUserDO> duplicateStrategy) {
        List users = usersSupplier.get().stream().filter(p -> p.getDeleteFlag() == null || p.getDeleteFlag() == 0).collect(Collectors.toList());
        if (users.isEmpty()) {
            return null;
        }
        if (users.size() == 1) {
            return this.wrapUserDetail((SysUserDO)users.get(0));
        }
        SysUserDO userDto = duplicateStrategy.apply(users);
        return this.wrapUserDetail(userDto);
    }

    private SysUserDTO wrapUserDetail(SysUserDO sysUserDO) {
        if (sysUserDO == null) {
            return null;
        }
        SysUserDTO user = SysUserConvert.INSTANCE.doToDto(sysUserDO);
        this.expendUserInfoBySpi(user);
        this.tenantDataIsolateProvider.byTenantUser(() -> {
            this.wrapIsolatedData(user);
            return null;
        }, user);
        return user;
    }

    private void wrapIsolatedData(SysUserDTO user) {
        SysUserCompanyDO userCompany;
        List userIds = this.sysUserProxyService.findUserIdsByProxyUserId(user.getId());
        userIds.add(0, user.getId());
        this.userPermissionManager.fillRoleForUser(user, userIds);
        ApiResult userTerminal = this.userTerminalService.getByUser(user.getId());
        if (CollUtil.isNotEmpty((Collection)((Collection)userTerminal.getData()))) {
            user.setTerminals((List)userTerminal.getData());
        }
        if ((userCompany = this.userCompanyRepoProc.queryByUserId(user.getId())) != null) {
            user.setOuId(userCompany.getOuId());
            user.setOuCode(userCompany.getOuCode());
            user.setOuName(userCompany.getOuName());
        }
    }

    private void expendUserInfoBySpi(SysUserDTO userDetails) {
        if (this.userLoginSpiLoaded.compareAndSet(false, true)) {
            this.userLoginSpiList = ServiceProviderLoader.loadProviderInstances(SysUserLoginSpi.class);
        }
        if (this.userLoginSpiList.isEmpty()) {
            log.info("\u6682\u65e0\u767b\u5f55\u6269\u5c55\u5b9e\u73b0");
            return;
        }
        for (SysUserLoginSpi spi : this.userLoginSpiList) {
            log.info("\u3010{}\u3011SPI\u8c03\u7528...", (Object)spi.getServiceName());
            spi.expendLoginUserInfo(userDetails);
        }
    }

    private void expendUserServiceSpi(Consumer<SysUserServiceSpi> userServiceSpiConsumer) {
        if (this.userServiceSpiLoaded.compareAndSet(false, true)) {
            this.userServiceSpiList = ServiceProviderLoader.loadProviderInstances(SysUserServiceSpi.class);
        }
        if (this.userServiceSpiList.isEmpty()) {
            log.info("\u7528\u6237\u7ba1\u7406SysUserServiceSpi\u65e0\u6269\u5c55\u5b9e\u73b0");
            return;
        }
        for (SysUserServiceSpi spi : this.userServiceSpiList) {
            log.info("\u3010{}\u3011SPI\u8c03\u7528...", (Object)spi.getServiceName());
            userServiceSpiConsumer.accept(spi);
        }
    }

    public Long getUserIdByUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        return this.sysUserRepoProc.getIdByUsername(username);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long create(SysUserNewParam userNewParam, String password) throws BusinessException {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        this.checkForAdd(userNewParam, currentUser);
        SysUserDO sysUser = SysUserConvert.INSTANCE.newToDo(userNewParam);
        List notifySettings = this.sysSettingService.findSettingsBySettingNo("SYS_PWD_NOTIFY_TYPE");
        String rawPassword = StringUtils.isNotBlank((CharSequence)password) ? password : (org.springframework.util.CollectionUtils.isEmpty((Collection)notifySettings) ? this.generateDefaultPwd() : this.generateRandomPwd());
        sysUser.setPassword(this.passwordEncoder.encode((CharSequence)rawPassword));
        sysUser.setSecOuId(sysUser.getOuId());
        sysUser.setSecBuId(sysUser.getBuId());
        sysUser.setTransFlag(Integer.valueOf(1));
        SysUserDO newUser = (SysUserDO)this.sysUserRepo.save(sysUser);
        Long id = newUser.getId();
        SysTenantDTO tenantDTO = null;
        if (userNewParam.getTenantId() != null && (tenantDTO = this.tenantDataIsolateProvider.getTenant(userNewParam.getTenantId())) == null) {
            throw new BusinessException("\u79df\u6237\u4e0d\u5b58\u5728");
        }
        tenantDTO = (SysTenantDTO)ObjectUtil.defaultIfNull(tenantDTO, (Object)this.obtainCurrentTenantForCreateUser(currentUser));
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userNewParam.getRoleIds())) {
                Optional.of(userNewParam.getRoleIds()).ifPresent(roleIds -> {
                    List userRoles = roleIds.stream().map(roleId -> new SysUserRoleVO().setUserId(id).setRoleId(roleId)).collect(Collectors.toList());
                    this.sysUserRoleService.saveAll(userRoles);
                });
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userNewParam.getDataRoleIds())) {
                this.sysUserDataRoleService.userDataRoleHardSave(id, userNewParam.getDataRoleIds());
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userNewParam.getFlowRoleIds())) {
                this.sysUserFlowRoleService.userFlowRoleHardSave(id, userNewParam.getFlowRoleIds());
            }
            this.saveOrUpdateUserTerminal(id, userNewParam);
            this.saveOrUpdateUserCompany(newUser);
            return null;
        }, tenantDTO);
        if (StringUtils.isBlank((CharSequence)password) && !org.springframework.util.CollectionUtils.isEmpty((Collection)notifySettings)) {
            SysSettingDTO notifySetting = (SysSettingDTO)notifySettings.get(0);
            this.sendPwdSmsNotify(sysUser.getMobile(), rawPassword, notifySetting.getSettingVal(), "sms-init-pwd");
        }
        this.expendUserServiceSpi(spi -> spi.afterUserAdd(userNewParam, id));
        return id;
    }

    private void checkForAdd(SysUserNewParam userNewParam, GeneralUserDetails currentUser) {
        if (userNewParam.getEnabled() == null) {
            userNewParam.setEnabled(Boolean.valueOf(false));
        }
        this.expendUserServiceSpi(spi -> spi.beforeUserAdd(userNewParam));
        if (this.sysUserRepo.existsByUsername(userNewParam.getUsername())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\uff1a" + userNewParam.getUsername() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)userNewParam.getMobile())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u624b\u673a\u53f7\u5fc5\u586b");
        }
        if (this.sysUserRepo.existsByMobile(userNewParam.getMobile())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u76f8\u540c\u7684\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)userNewParam.getEmail()) && this.sysUserRepo.existsByEmail(userNewParam.getEmail())) {
            throw new BusinessException("\u76f8\u540c\u7684\u90ae\u7bb1\u5730\u5740\u5df2\u7ecf\u5b58\u5728");
        }
        this.checkUserPermission(currentUser, userNewParam.getRoleIds());
        this.checkUserDataPermission(currentUser, userNewParam.getDataRoleIds());
        this.checkUserFlowPermission(currentUser, userNewParam.getFlowRoleIds());
    }

    private SysTenantDTO obtainCurrentTenantForCreateUser(GeneralUserDetails currentUser) {
        if (currentUser != null) {
            if (currentUser.isSystemAdmin() || currentUser.isOperation()) {
                return null;
            }
            return currentUser.getTenant();
        }
        return this.tenantDataIsolateProvider.getCurrentTenant();
    }

    private void checkUserPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return;
        }
        if (currentUser == null || currentUser.isSystemAdmin()) {
            return;
        }
        Set noPermissionRoleCodes = this.sysRoleService.rolesOfNoPermission(currentUser.getUser());
        if (noPermissionRoleCodes.isEmpty()) {
            return;
        }
        Collection noPermissionRoleIds = this.sysRoleService.getIdByCode(noPermissionRoleCodes).values();
        for (Long roleId : roleIds) {
            if (!noPermissionRoleIds.contains(roleId)) continue;
            throw new BusinessException("\u90e8\u5206\u5e94\u7528\u89d2\u8272\u65e0\u6743\u9650\u64cd\u4f5c");
        }
    }

    private void checkUserDataPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return;
        }
        if (currentUser == null || currentUser.isSystemAdmin()) {
            return;
        }
        Set noPermissionRoleCodes = this.dataRoleService.rolesOfNoPermission(currentUser.getUser());
        if (noPermissionRoleCodes.isEmpty()) {
            return;
        }
        Collection noPermissionRoleIds = this.dataRoleService.getIdByCode(noPermissionRoleCodes).values();
        for (Long roleId : roleIds) {
            if (!noPermissionRoleIds.contains(roleId)) continue;
            throw new BusinessException("\u90e8\u5206\u6570\u636e\u89d2\u8272\u65e0\u6743\u9650\u64cd\u4f5c");
        }
    }

    private void checkUserFlowPermission(GeneralUserDetails currentUser, List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return;
        }
        if (currentUser == null || currentUser.isSystemAdmin()) {
            return;
        }
        Set noPermissionRoleCodes = this.flowRoleService.rolesOfNoPermission(currentUser.getUser());
        if (noPermissionRoleCodes.isEmpty()) {
            return;
        }
        Collection noPermissionRoleIds = this.flowRoleService.getIdByCode(noPermissionRoleCodes).values();
        for (Long roleId : roleIds) {
            if (!noPermissionRoleIds.contains(roleId)) continue;
            throw new BusinessException("\u90e8\u5206\u6d41\u7a0b\u89d2\u8272\u65e0\u6743\u9650\u64cd\u4f5c");
        }
    }

    private void saveOrUpdateUserTerminal(Long id, SysUserNewParam userNewParam) {
        HashSet<Terminal> terminals = new HashSet<Terminal>(4);
        if (CollUtil.isNotEmpty((Collection)userNewParam.getTerminals())) {
            terminals.addAll(userNewParam.getTerminals());
        }
        if (CharSequenceUtil.equals((CharSequence)userNewParam.getSourceType(), (CharSequence)"sys")) {
            terminals.add(Terminal.BACKEND);
        } else if (CharSequenceUtil.equals((CharSequence)userNewParam.getSourceType(), (CharSequence)"wec")) {
            terminals.add(Terminal.APP);
        }
        if (!terminals.isEmpty()) {
            this.userTerminalService.saveForAdd(id, terminals);
            userNewParam.setTerminals(terminals);
        }
    }

    private void saveOrUpdateUserCompany(SysUserDO user) {
        if (user.getOuId() == null) {
            this.userCompanyRepoProc.deleteByUserId(user.getId());
            return;
        }
        List<Long> ouIds = this.userCompanyRepoProc.getOuIdOfUser(user.getId());
        if (ouIds.contains(user.getOuId())) {
            return;
        }
        this.userCompanyRepoProc.deleteByUserId(user.getId());
        SysUserCompanyDO userCompanyDO = new SysUserCompanyDO();
        userCompanyDO.setSysUserId(user.getId());
        userCompanyDO.setOuId(user.getOuId());
        userCompanyDO.setOuCode(user.getOuCode());
        userCompanyDO.setOuName(user.getOuName());
        userCompanyDO.setBindTime(LocalDateTime.now());
        this.userCompanyRepo.save((Object)userCompanyDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(SysUserUpdateParam userUpdateParam, boolean updateRoles) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        Optional userOpt = this.sysUserRepo.findById(userUpdateParam.getId());
        if (userOpt.isEmpty()) {
            throw new BusinessException("ID\u4e3a\uff1a" + userUpdateParam.getId() + "\uff0c \u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SysUserDO sysUserDO = (SysUserDO)userOpt.get();
        if (StringUtils.isNotBlank((CharSequence)userUpdateParam.getMobile()) && this.sysUserRepo.existsByMobileAndIdNot(userUpdateParam.getMobile(), userUpdateParam.getId())) {
            throw new BusinessException("\u624b\u673a\u53f7\u7801\uff1a" + userUpdateParam.getMobile() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)userUpdateParam.getEmail()) && this.sysUserRepo.existsByEmailAndIdNot(userUpdateParam.getEmail(), userUpdateParam.getId())) {
            throw new BusinessException("\u7535\u5b50\u90ae\u7bb1\uff1a" + userUpdateParam.getEmail() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        SysUserConvert.INSTANCE.updateToDo(userUpdateParam, sysUserDO);
        sysUserDO.setSecOuId(sysUserDO.getOuId());
        sysUserDO.setSecBuId(sysUserDO.getBuId());
        sysUserDO.setTransFlag(Integer.valueOf(1));
        this.sysUserRepo.save(sysUserDO);
        if (updateRoles) {
            this.tenantDataIsolateProvider.byTenantDirectly(() -> {
                this.sysUserRoleService.removeRolesByUserIds(Collections.singletonList(sysUserDO.getId()));
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userUpdateParam.getRoleIds())) {
                    List userRoles = userUpdateParam.getRoleIds().stream().map(rid -> new SysUserRoleVO().setUserId(sysUserDO.getId()).setRoleId(rid)).collect(Collectors.toList());
                    this.sysUserRoleService.saveAll(userRoles);
                }
                this.sysUserDataRoleService.userDataRoleHardSave(sysUserDO.getId(), userUpdateParam.getDataRoleIds());
                this.sysUserFlowRoleService.userFlowRoleHardSave(sysUserDO.getId(), userUpdateParam.getFlowRoleIds());
                if (CollUtil.isNotEmpty((Collection)userUpdateParam.getTerminals())) {
                    this.userTerminalService.save(sysUserDO.getId(), userUpdateParam.getTerminals());
                }
                this.saveOrUpdateUserCompany(sysUserDO);
                return null;
            }, this.obtainCurrentTenantForCreateUser(currentUser));
        }
        this.expendUserServiceSpi(spi -> spi.afterUserUpdate(sysUserDO.getId()));
        return sysUserDO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void resetPasswordByUserId(Long userId) {
        Optional optional = this.sysUserRepo.findById(userId);
        if (optional.isPresent()) {
            SysUserDO user = (SysUserDO)optional.get();
            List settings = this.sysSettingService.findSettingsBySettingNo("SYS_PWD_NOTIFY_TYPE");
            String newPassword = StringUtils.isBlank((CharSequence)user.getMobile()) || org.springframework.util.CollectionUtils.isEmpty((Collection)settings) ? this.generateDefaultPwd() : this.generateRandomPwd();
            user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
            user.setNeedReset(Boolean.valueOf(true));
            this.sysUserRepo.save(user);
            if (StringUtils.isNotBlank((CharSequence)user.getMobile()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)settings)) {
                SysSettingDTO setting = (SysSettingDTO)settings.get(0);
                this.sendPwdSmsNotify(user.getMobile(), newPassword, setting.getSettingVal(), "sms-reset-pwd");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean switchUserStatus(Long id) {
        SysUserDO user;
        Optional userOpt = this.sysUserRepo.findById(id);
        if (userOpt.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "ID\u4e3a\uff1a" + id + "\uff0c\u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        user.setEnabled(Boolean.valueOf((user = (SysUserDO)userOpt.get()).getEnabled() == false));
        this.sysUserRepo.save(user);
        return user.getEnabled();
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSwitchUserStatus(SysUserBatchSwitchParam param) {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)param.getUserIds())) {
            this.sysUserRepoProc.updateStatusByIds(param);
        }
    }

    public Set<SysRoleVO> listRolesByUsername(String username) {
        Optional<SysUserDO> user = this.sysUserRepo.findByUsername(username);
        if (user.isEmpty()) {
            return Collections.emptySet();
        }
        return this.sysUserRoleService.listRolesByUserId(user.get().getId());
    }

    public SysUserDTO current() {
        Object details = SecurityUtil.currentUser();
        if (details instanceof GeneralUserDetails) {
            return ((GeneralUserDetails)details).getUser();
        }
        return null;
    }

    public List<SysCurrentUserPermissions> currentMenu() {
        List<SysPermissionWithRoleVO> currentPermissions = this.getCurrentUserPermissions();
        return currentPermissions.stream().filter(perm -> SysPermTypeEnum.MENU.getValue().equals(perm.getPermType())).map(SysRolePermissionConvert.INSTANCE::permWithRoleToPermissions).collect(Collectors.toList());
    }

    public List<SysCurrentUserPermissions> currentMenuTrees(Long nodeId) {
        SysUserDTO user = this.current();
        if (Objects.isNull(user) || org.springframework.util.CollectionUtils.isEmpty((Collection)user.getRoles())) {
            return Collections.emptyList();
        }
        List rolePerms = this.permissionWithRoleCacheService.getPermissionWithRole();
        if (CollUtil.isEmpty((Collection)rolePerms)) {
            return Collections.emptyList();
        }
        List<Object> roleVOList = rolePerms.stream().filter(v -> v.getPermType() != null && v.getPermType().equals(0)).collect(Collectors.toList());
        Set roleCodes = user.getRoles().stream().map(SysRoleVO::getCode).collect(Collectors.toSet());
        if (!org.springframework.util.CollectionUtils.isEmpty(roleCodes) && !roleCodes.contains("ROLE_ADMIN")) {
            roleVOList = this.getSysPermissionWithRoleVOS(user, rolePerms);
        } else {
            HashSet longs = new HashSet();
            List adminSysPermission = roleVOList.stream().filter(v -> {
                if (!longs.contains(v.getId())) {
                    longs.add(v.getId());
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            roleVOList = adminSysPermission;
        }
        List<SysCurrentUserPermissions> collect = roleVOList.stream().filter(perm -> SysPermTypeEnum.MENU.getValue().equals(perm.getPermType())).map(SysRolePermissionConvert.INSTANCE::permWithRoleToPermissions).collect(Collectors.toList());
        return this.createMenuTree(collect, nodeId);
    }

    public boolean existsUsername(String username, Long id) {
        if (!org.springframework.util.StringUtils.hasText((String)username)) {
            return false;
        }
        return this.sysUserRepoProc.existsUsername(username, id);
    }

    public boolean existsMobile(String mobile, Long id) {
        if (!org.springframework.util.StringUtils.hasText((String)mobile)) {
            return false;
        }
        return this.sysUserRepoProc.existsMobile(mobile, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateTenantId(Long id, Long tenantId) {
        this.sysUserRepoProc.updateTenantId(id, tenantId);
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateUserWechatOpenid(String userName, String openid) {
        List<SysUserDO> users = this.sysUserRepo.findByWxOpenid(openid);
        if (users == null || users.isEmpty()) {
            this.sysUserRepoProc.updateOpenidByUserName(openid, userName);
            return ApiResult.ok((Object)userName);
        }
        return ApiResult.fail((String)"openid\u5df2\u7ecf\u88ab\u7ed1\u5b9a");
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {
        if (CollectionUtils.isNotEmpty((Collection)param.getRoleIds())) {
            List<Long> filterIds = param.getRoleIds().stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
            List<Long> userIds = this.sysUserRpcRepoProc.findUserIdsByRoleIds(filterIds);
            if (param.getUserIds() == null) {
                param.setUserIds(userIds);
            } else {
                param.getUserIds().addAll(userIds);
            }
        }
        return (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.sysUserRpcRepoProc.findRpcDtoByParam(param));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateReole(SysUserUpdateParam userUpdateParam) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        ArrayList roles = new ArrayList();
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)roles)) {
                Long selectname = this.sysRoleRepo.selectname(userUpdateParam.getRoleName());
                roles.add(selectname);
                userUpdateParam.setRoleIds(roles);
            }
            this.sysUserRoleService.removeRolesByUserIds(Collections.singletonList(userUpdateParam.getId()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userUpdateParam.getRoleIds())) {
                List userRoles = userUpdateParam.getRoleIds().stream().map(rid -> new SysUserRoleVO().setUserId(userUpdateParam.getId()).setRoleId(rid)).collect(Collectors.toList());
                this.sysUserRoleService.saveAll(userRoles);
            }
            return null;
        }, this.obtainCurrentTenantForCreateUser(currentUser));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateReoleDubbo(SysUserUpdateParam userUpdateParam) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        ArrayList<Long> roles = new ArrayList<Long>();
        if (org.springframework.util.CollectionUtils.isEmpty(roles)) {
            Long selectname = this.sysRoleRepo.selectname(userUpdateParam.getRoleName());
            roles.add(selectname);
            userUpdateParam.setRoleIds(roles);
        }
        this.sysUserRoleService.removeRolesByUserIds(Collections.singletonList(userUpdateParam.getId()));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)userUpdateParam.getRoleIds())) {
            List userRoles = userUpdateParam.getRoleIds().stream().map(rid -> new SysUserRoleVO().setUserId(userUpdateParam.getId()).setRoleId(rid)).collect(Collectors.toList());
            this.sysUserRoleService.saveAll(userRoles);
        }
    }

    @Transactional
    public void updateusernameandphone(SysUserUpdateParam user) {
        if (StringUtils.isNotBlank((CharSequence)user.getMobile()) && this.sysUserRepo.existsByMobileAndIdNot(user.getMobile(), user.getId())) {
            throw new BusinessException("\u624b\u673a\u53f7\u7801\uff1a" + user.getMobile() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)user.getMobile()) && this.sysUserRepo.existsByUsernameAndIdNot(user.getUserName(), user.getId())) {
            throw new BusinessException("\u8d26\u53f7\uff1a" + user.getUserName() + ", \u5df2\u7ecf\u5b58\u5728");
        }
        QSysUserDO SYS_USER = QSysUserDO.sysUserDO;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)SYS_USER).set((Path)SYS_USER.deleteFlag, (Object)0).where(new Predicate[]{SYS_USER.id.eq((Object)user.getId())});
        if (ObjectUtil.isNotEmpty((Object)user.getUserName())) {
            update.set((Path)SYS_USER.username, (Object)user.getUserName());
        }
        if (ObjectUtil.isNotEmpty((Object)user.getMobile())) {
            update.set((Path)SYS_USER.mobile, (Object)user.getMobile());
        }
        update.execute();
    }

    public ApiResult<Object> testMobile(Long id, String mobile) {
        if (this.sysUserRepo.existsByMobileAndIdNot(mobile, id)) {
            throw new BusinessException("\u8d26\u53f7\u624b\u673a\u53f7\u7801\uff1a" + mobile + ", \u5df2\u7ecf\u5b58\u5728");
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> testUserName(Long id, String userName) {
        if (this.sysUserRepo.existsByUsernameAndIdNot(userName, id)) {
            throw new BusinessException("\u8d26\u53f7\uff1a" + userName + ", \u5df2\u7ecf\u5b58\u5728");
        }
        return ApiResult.ok();
    }

    private List<SysCurrentUserPermissions> createMenuTree(List<SysCurrentUserPermissions> sysCurrentUserPermissions, Long rootKey) {
        Map<Long, List<SysCurrentUserPermissions>> keyMaps = sysCurrentUserPermissions.stream().filter(node -> node.getParentId() != null).collect(Collectors.groupingBy(SysCurrentUserPermissions::getParentId));
        List<Object> sysCurrentUserPermissionsList = null;
        sysCurrentUserPermissionsList = rootKey == null || FIXED_ROOT_ID.equals(rootKey) ? keyMaps.get(FIXED_ROOT_ID) : sysCurrentUserPermissions.stream().filter(v -> rootKey.equals(v.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isNotEmpty(sysCurrentUserPermissionsList)) {
            return Collections.emptyList();
        }
        Collections.sort(sysCurrentUserPermissionsList);
        sysCurrentUserPermissionsList.forEach(node -> this.buildChildNodes((SysCurrentUserPermissions)node, keyMaps));
        return sysCurrentUserPermissionsList;
    }

    private void buildChildNodes(SysCurrentUserPermissions rootNode, Map<Long, List<SysCurrentUserPermissions>> collect) {
        if (!collect.containsKey(rootNode.getId())) {
            return;
        }
        List<SysCurrentUserPermissions> childNodes = collect.get(rootNode.getId());
        if (CollectionUtils.isNotEmpty(childNodes)) {
            Collections.sort(childNodes);
            childNodes.forEach(v -> this.buildChildNodes((SysCurrentUserPermissions)v, collect));
        }
        rootNode.setChildNodes(childNodes);
    }

    public Set<SysCurrentUserPermissions> currentMenuActions(Long menuId) {
        List<SysPermissionWithRoleVO> currentPermissions = this.getCurrentUserPermissions();
        return currentPermissions.stream().filter(perm -> menuId.equals(perm.getParentId()) && SysPermTypeEnum.ACTION.getValue().equals(perm.getPermType())).map(SysRolePermissionConvert.INSTANCE::permWithRoleToPermissions).collect(Collectors.toSet());
    }

    public Set<SysCurrentUserPermissions> currentActions() {
        List<SysPermissionWithRoleVO> currentPermissions = this.getCurrentUserPermissions();
        return currentPermissions.stream().filter(perm -> SysPermTypeEnum.ACTION.getValue().equals(perm.getPermType())).map(SysRolePermissionConvert.INSTANCE::permWithRoleToPermissions).collect(Collectors.toSet());
    }

    private List<SysPermissionWithRoleVO> getCurrentUserPermissions() {
        SysUserDTO user = this.current();
        if (Objects.isNull(user) || org.springframework.util.CollectionUtils.isEmpty((Collection)user.getRoles())) {
            return Collections.emptyList();
        }
        List rolePerms = this.permissionWithRoleCacheService.getPermissionWithRole();
        return this.getSysPermissionWithRoleVOS(user, rolePerms);
    }

    private List<SysPermissionWithRoleVO> getSysPermissionWithRoleVOS(SysUserDTO user, List<SysPermissionWithRoleVO> rolePerms) {
        if (!org.springframework.util.CollectionUtils.isEmpty(rolePerms)) {
            Set roleCodes = user.getRoles().stream().map(SysRoleVO::getCode).collect(Collectors.toSet());
            if (!org.springframework.util.CollectionUtils.isEmpty(roleCodes)) {
                return rolePerms.stream().filter(rolePerm -> StringUtils.isNotBlank((CharSequence)rolePerm.getRoleCode()) && roleCodes.contains(this.securityProperties.getRolePrefix() + rolePerm.getRoleCode())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        this.sysUserRepoProc.delete(idList);
        for (Long id : idList) {
            this.expendUserServiceSpi(spi -> spi.afterUserDelete(id));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePassword(SysPasswordUpdate update) {
        this.sysUserRepo.findById(update.getUserId()).ifPresent(sysUserDO -> {
            String currentPassword = update.getCurrentPassword();
            try {
                currentPassword = EncryptUtils.decodeBase64((String)currentPassword);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new BusinessException("\u539f\u59cb\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u52a0\u5bc6\u9519\u8bef");
            }
            if (!this.passwordEncoder.matches((CharSequence)currentPassword, sysUserDO.getPassword())) {
                throw new BusinessException("\u539f\u59cb\u5bc6\u7801\u4e0d\u6b63\u786e");
            }
            if (update.getCurrentPassword().equals(update.getNewPassword())) {
                throw new BusinessException("\u65b0\u5bc6\u7801\u548c\u65e7\u5bc6\u7801\u76f8\u540c,\u8bf7\u76f4\u63a5\u767b\u5f55");
            }
            String newPassword = update.getNewPassword();
            try {
                newPassword = EncryptUtils.decodeBase64((String)newPassword);
            }
            catch (UnsupportedEncodingException e) {
                throw new BusinessException("\u65b0\u5bc6\u7801\u52a0\u5bc6\u9519\u8bef");
            }
            sysUserDO.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
            sysUserDO.setNeedReset(Boolean.valueOf(false));
            this.sysUserRepo.save(sysUserDO);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePassword2(SysPasswordUpdate update) {
        this.sysUserRepo.findById(update.getUserId()).ifPresent(sysUserDO -> {
            String newPassword = update.getNewPassword();
            try {
                newPassword = EncryptUtils.decodeBase64((String)newPassword);
            }
            catch (UnsupportedEncodingException e) {
                throw new BusinessException("\u65b0\u5bc6\u7801\u52a0\u5bc6\u9519\u8bef");
            }
            sysUserDO.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
            sysUserDO.setNeedReset(Boolean.valueOf(false));
            this.sysUserRepo.save(sysUserDO);
        });
    }

    public PagingVO<SysUserVO> searchForJdy(SysUserQueryParam param) {
        Page users = this.sysUserRepo.findAll(this.sysUserRepoProc.where(param), (Pageable)param.getPageRequest());
        List userIds = users.map(BaseModel::getId).stream().collect(Collectors.toList());
        Map userRoles = this.sysUserRoleService.listRolesByUserIds(userIds);
        List userVos = users.getContent().stream().map(u -> {
            SysUserVO userVo = SysUserConvert.INSTANCE.doToVo((SysUserDO)u);
            if (userRoles.containsKey(u.getId())) {
                userVo.setRoleNames(((Set)userRoles.get(u.getId())).stream().map(SysRoleVO::getName).collect(Collectors.joining(",")));
                List roleIds = ((Set)userRoles.get(u.getId())).stream().map(SysRoleVO::getId).collect(Collectors.toList());
                Object roleStr = "";
                if (roleIds != null && !roleIds.isEmpty()) {
                    for (Long roleid : roleIds) {
                        if ("".equals(roleStr)) {
                            roleStr = roleid.toString();
                            continue;
                        }
                        roleStr = (String)roleStr + "," + roleid.toString();
                    }
                }
                userVo.setRoleIds((String)roleStr);
            }
            return userVo;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(users.getTotalElements())).records(userVos).build();
    }

    public void saveAllByQuery(SysUserQueryParam param) {
        Page users = this.sysUserRepo.findAll(this.sysUserRepoProc.where(param), (Pageable)param.getPageRequest());
        List userDOList = users.getContent();
        for (SysUserDO sysUserDO : userDOList) {
            sysUserDO.setTransFlag(Integer.valueOf(1));
        }
        this.sysUserRepo.saveAll(userDOList);
    }

    public List<SysUserVO> findAllUser() {
        List users = this.sysUserRepo.findAll();
        List userIds = users.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map userRoles = this.sysUserRoleService.listRolesByUserIds(userIds);
        List<SysUserVO> userVos = users.stream().map(u -> {
            SysUserVO userVo = SysUserConvert.INSTANCE.doToVo((SysUserDO)u);
            if (userRoles.containsKey(u.getId())) {
                userVo.setRoleNames(((Set)userRoles.get(u.getId())).stream().map(SysRoleVO::getName).collect(Collectors.joining(",")));
                List roleIds = ((Set)userRoles.get(u.getId())).stream().map(SysRoleVO::getId).collect(Collectors.toList());
                Object roleStr = "";
                if (roleIds != null && !roleIds.isEmpty()) {
                    for (Long roleid : roleIds) {
                        if ("".equals(roleStr)) {
                            roleStr = roleid.toString();
                            continue;
                        }
                        roleStr = (String)roleStr + "," + roleid.toString();
                    }
                }
                userVo.setRoleIds((String)roleStr);
            }
            return userVo;
        }).collect(Collectors.toList());
        return userVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAvatar(SysUserAvatarUpdateParam updateParam) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return ApiResult.fail((String)"\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (this.fileService == null) {
            return ApiResult.fail((String)"\u672a\u542f\u7528\u6587\u4ef6\u670d\u52a1");
        }
        if (StringUtils.isNotBlank((CharSequence)updateParam.getAvatarCode()) && !this.fileService.existsAll(updateParam.getAvatarCode()).isSuccess()) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5934\u50cf\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        Long userId = currentUser.getUser().getId();
        this.sysUserRepoProc.updateAvatar(userId, updateParam.getAvatarUrl(), updateParam.getAvatarCode());
        this.eventPublisher.publishEvent((ApplicationEvent)new OnlineUserInfoChangeEvent(this, userId));
        return ApiResult.ok((Object)userId);
    }

    public ApiResult<Boolean> sendVerifyCodeForUpdatePassword(SysSendVerifyCodeParam verifyCodeParam) {
        String verifyCode = this.verifyCodeManager.send("yst_system_update_pwd", verifyCodeParam);
        if (StringUtils.isNotBlank((CharSequence)verifyCode)) {
            return ApiResult.ok((Object)true);
        }
        return ApiResult.fail((String)"\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updatePasswordByVerifyCode(SysPasswordUpdateParam updateParam) {
        String verifyMsg = this.verifyCodeManager.verify("yst_system_update_pwd", updateParam.getAccount(), updateParam.getVerifyCode());
        if (verifyMsg != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        Long userId = this.sysUserRepoProc.getIdByMobile(updateParam.getAccount());
        if (userId == null) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u624b\u673a\u53f7\u8f93\u5165\u6b63\u786e");
        }
        this.sysUserRepoProc.updatePassword(userId, this.passwordEncoder.encode((CharSequence)updateParam.getPassword()));
        return ApiResult.ok((Object)userId);
    }

    public ApiResult<Boolean> sendVerifyCodeForUpdateAccount(SysSendVerifyCodeParam verifyCodeParam) {
        String verifyCode = this.verifyCodeManager.send("yst_system_update_mobile", verifyCodeParam);
        if (StringUtils.isNotBlank((CharSequence)verifyCode)) {
            return ApiResult.ok((Object)true);
        }
        return ApiResult.fail((String)"\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25");
    }

    public ApiResult<String> verifyCodeForUpdateAccount(SysVerifyCodeParam codeParam) {
        String verifyMsg = this.verifyCodeManager.verify("yst_system_update_mobile", codeParam.getAccount(), codeParam.getVerifyCode());
        if (verifyMsg != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        String verifyId = UUID.fastUUID().toString();
        this.redisUtils.set(verifyId, (Object)verifyId, 30L, TimeUnit.MINUTES);
        return ApiResult.ok((Object)verifyId);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAccountByVerifyCode(SysAccountUpdateParam updateParam) {
        Long userId;
        String verifyMsg = this.verifyCodeManager.verify("yst_system_update_mobile", updateParam.getAccount(), updateParam.getVerifyCode());
        if (verifyMsg != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        String verifyId = (String)this.redisUtils.get(updateParam.getVerifyId());
        if (!StringUtils.equals((CharSequence)updateParam.getVerifyId(), (CharSequence)verifyId)) {
            return ApiResult.fail((String)"\u6821\u9a8c\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u9a8c\u8bc1\u4e4b\u524d\u7684\u624b\u673a\u53f7");
        }
        GeneralUserDetails user = SecurityUtil.getUser();
        Long l = userId = user == null ? null : user.getUser().getId();
        if (userId == null) {
            return ApiResult.fail((String)"\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        Long existsUserId = this.sysUserRepoProc.getIdByMobile(updateParam.getAccount());
        if (existsUserId != null && existsUserId.longValue() != userId.longValue()) {
            return ApiResult.fail((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a");
        }
        this.sysUserRepoProc.updateMobile(userId, updateParam.getAccount());
        this.eventPublisher.publishEvent((ApplicationEvent)new OnlineUserInfoChangeEvent(this, userId));
        return ApiResult.ok((Object)userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAccountPhone(SysPhoneUpdate updateParam) {
        logger.info("\u4fee\u6539\u624b\u673a\u53f7\u5165\u53c2,userId:{},phone:{}", (Object)updateParam.getUserId(), (Object)updateParam.getAccount());
        List<SysUserDO> allByIdIn = this.sysUserRepo.findAllByIdIn(Collections.singletonList(updateParam.getUserId()));
        if (org.springframework.util.CollectionUtils.isEmpty(allByIdIn)) {
            return ApiResult.fail((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Long existsUserId = this.sysUserRepoProc.getIdByMobile(updateParam.getAccount());
        if (existsUserId != null && existsUserId.longValue() != updateParam.getUserId().longValue()) {
            return ApiResult.fail((String)"\u8be5\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a");
        }
        this.sysUserRepoProc.updateMobile(updateParam.getUserId(), updateParam.getAccount());
        this.eventPublisher.publishEvent((ApplicationEvent)new OnlineUserInfoChangeEvent(this, updateParam.getUserId()));
        return ApiResult.ok((Object)updateParam.getUserId());
    }

    private String generateDefaultPwd() {
        String newPassword;
        List defaultPwdSettings = this.sysSettingService.findSettingsBySettingNo("SYS_DEFAULT_USER_PWD");
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)defaultPwdSettings)) {
            newPassword = "123456";
        } else {
            newPassword = ((SysSettingDTO)defaultPwdSettings.get(0)).getSettingVal();
            if (StringUtils.isBlank((CharSequence)newPassword)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7cfb\u7edf\u914d\u7f6e\u7684\u9ed8\u8ba4\u5bc6\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
        }
        return newPassword;
    }

    private String generateRandomPwd() {
        return RandomUtil.randomString((int)8);
    }

    private void sendPwdSmsNotify(String to, String pwd, String transType, String templateCode) {
        HashMap<String, String> templateValues = new HashMap<String, String>(2);
        templateValues.put("pwd", pwd);
        GeneralDubboCarrier carrier = GeneralDubboCarrier.builder().tos(new String[]{to}).isRichContent(Boolean.valueOf(false)).transType(transType).templateCode(templateCode).templateValues(templateValues).build();
        ApiResult response = this.msgCarrierDubboService.generalSend(Collections.singletonList(carrier));
        if (!response.isSuccess()) {
            throw new BusinessException(ApiCode.CLOUD_SERVICE_EXCEPTION, response.getData().toString());
        }
    }
}

