/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import cn.hutool.core.lang.Assert;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.convert.SysWatermarkConfigConvert;
import com.elitesland.yst.system.model.entity.QSysWatermarkConfigDO;
import com.elitesland.yst.system.model.entity.SysWatermarkConfigDO;
import com.elitesland.yst.system.repo.SysWatermarkConfigRepo;
import com.elitesland.yst.system.repo.SysWatermarkConfigRepoProc;
import com.elitesland.yst.system.service.SysWatermarkConfigService;
import com.elitesland.yst.system.service.param.SysWatermarkConfigCreateParam;
import com.elitesland.yst.system.service.param.SysWatermarkConfigQueryParam;
import com.elitesland.yst.system.service.param.SysWatermarkConfigUpdateParam;
import com.elitesland.yst.system.service.vo.SysWatermarkConfigVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysWatermarkConfigService")
public class SysWatermarkConfigServiceImpl
implements SysWatermarkConfigService {
    private final SysWatermarkConfigRepo sysWatermarkConfigRepo;
    private final SysWatermarkConfigRepoProc sysWatermarkConfigRepoProc;

    @SysCodeProc
    public PagingVO<SysWatermarkConfigVO> search(SysWatermarkConfigQueryParam param) {
        Page ret = this.sysWatermarkConfigRepo.findAll(this.sysWatermarkConfigRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(SysWatermarkConfigConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(Long.valueOf(ret.getTotalElements())).records(vos).build();
    }

    @SysCodeProc
    public Optional<SysWatermarkConfigVO> findCodeOne(String itemCode) {
        JPAQuery<SysWatermarkConfigVO> jpaQuery = this.sysWatermarkConfigRepoProc.select(null);
        QSysWatermarkConfigDO jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
        SysWatermarkConfigVO vo = (SysWatermarkConfigVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    public Optional<SysWatermarkConfigVO> findOne() {
        Optional<SysWatermarkConfigDO> byOne = this.sysWatermarkConfigRepoProc.findByOne();
        Optional<SysWatermarkConfigVO> sysWatermarkConfigVO = byOne.map(SysWatermarkConfigConvert.INSTANCE::doToVO);
        if (byOne.isPresent()) {
            String[] split = byOne.get().getDynamicFont().split(",");
            List<String> dynamics = Arrays.asList(split);
            sysWatermarkConfigVO.get().setDynamicField(dynamics);
        }
        return sysWatermarkConfigVO;
    }

    @SysCodeProc
    public Optional<SysWatermarkConfigVO> findIdOne(Long id) {
        return this.sysWatermarkConfigRepo.findById(id).map(SysWatermarkConfigConvert.INSTANCE::doToVO);
    }

    @SysCodeProc
    public List<SysWatermarkConfigVO> findIdBatch(List<Long> idList) {
        return this.sysWatermarkConfigRepo.findAllById(idList).stream().map(SysWatermarkConfigConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Transactional
    public Long createOne(SysWatermarkConfigCreateParam param) {
        Assert.notNull((Object)param.getDynamicField(), (String)"\u8be5\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SysWatermarkConfigDO sysWatermarkConfigDO = SysWatermarkConfigConvert.INSTANCE.creatParamToDo(param);
        List dynamicFields = param.getDynamicField();
        Object dynamicFiled = "";
        for (int i = 0; i <= dynamicFields.size() - 1; ++i) {
            dynamicFiled = (String)dynamicFiled + (String)dynamicFields.get(i);
            if (i == dynamicFields.size() - 1) continue;
            dynamicFiled = (String)dynamicFiled + ",";
        }
        if (dynamicFiled != null) {
            sysWatermarkConfigDO.setDynamicFont((String)dynamicFiled);
        }
        return ((SysWatermarkConfigDO)this.sysWatermarkConfigRepo.save(sysWatermarkConfigDO)).getId();
    }

    @Transactional
    public List<Long> createBatch(List<SysWatermarkConfigCreateParam> list) {
        List dos = list.stream().map(SysWatermarkConfigConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
        return this.sysWatermarkConfigRepo.saveAll(dos).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(SysWatermarkConfigUpdateParam param) {
        SysWatermarkConfigDO objDo = SysWatermarkConfigConvert.INSTANCE.updateParamToDo(param);
        Optional optional = this.sysWatermarkConfigRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore((Object)objDo, (Object)((SysWatermarkConfigDO)optional.get()), (String[])BeanCopyUtil.getNullPropertyNames((Object)objDo));
        this.sysWatermarkConfigRepo.save((SysWatermarkConfigDO)optional.get());
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QSysWatermarkConfigDO jpaQDo = QSysWatermarkConfigDO.sysWatermarkConfigDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.sysWatermarkConfigRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        SysWatermarkConfigDO do1 = (SysWatermarkConfigDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.sysWatermarkConfigRepo.save(do1);
    }

    @Transactional
    public void deleteOne(Long id) {
        this.sysWatermarkConfigRepo.deleteById(id);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.sysWatermarkConfigRepo.deleteById(id));
    }

    public SysWatermarkConfigServiceImpl(SysWatermarkConfigRepo sysWatermarkConfigRepo, SysWatermarkConfigRepoProc sysWatermarkConfigRepoProc) {
        this.sysWatermarkConfigRepo = sysWatermarkConfigRepo;
        this.sysWatermarkConfigRepoProc = sysWatermarkConfigRepoProc;
    }
}

