/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.impl;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.core.security.common.SysPermTypeEnum;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.system.manager.UserPermissionManager;
import com.elitesland.yst.system.service.IUserPermissionService;
import com.elitesland.yst.system.service.vo.SysCurrentUserPermissions;
import com.elitesland.yst.system.vo.AntTreeNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPermissionServiceImpl
implements IUserPermissionService {
    private static final Logger log = LogManager.getLogger(UserPermissionServiceImpl.class);
    @Autowired
    private UserPermissionManager userPermissionManager;

    public ApiResult<List<AntTreeNode>> currentUserPermissionMenuTree(String terminalCode) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTree(currentUser.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        return ApiResult.ok(permissions);
    }

    public ApiResult<List<SysCurrentUserPermissions>> currentUserPermissionMenuTree1(String terminalCode) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<Object> permissions = this.userPermissionManager.queryUserPermissionMenuTree1(currentUser.getUser());
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        return ApiResult.ok(permissions);
    }

    public ApiResult<List<SysCurrentUserPermissions>> currentUserPermissionMenuList(String terminalCode) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<Object> permissions = this.userPermissionManager.queryUserPermissionList(currentUser.getUser(), SysPermTypeEnum.MENU);
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        return ApiResult.ok(permissions);
    }

    public ApiResult<List<SysCurrentUserPermissions>> currentUserPermissionActionList() {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<SysCurrentUserPermissions> permissions = this.userPermissionManager.queryUserPermissionList(currentUser.getUser(), SysPermTypeEnum.ACTION);
        return ApiResult.ok(permissions);
    }

    public ApiResult<List<SysCurrentUserPermissions>> currentUserPermissionActionListOfMenu(Long menuId, String terminalCode) {
        GeneralUserDetails currentUser = SecurityUtil.getUser();
        if (currentUser == null || menuId == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<Object> permissions = this.userPermissionManager.queryUserPermissionActionList(currentUser.getUser(), menuId);
        permissions = permissions.stream().filter(Objects::nonNull).distinct().filter(t -> terminalCode.equals(t.getTerminalCode())).collect(Collectors.toList());
        return ApiResult.ok(permissions);
    }
}

