/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.service.rpc;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.system.entity.SysUserDO;
import com.elitesland.yst.system.param.SysUserNewParam;
import com.elitesland.yst.system.repo.SysUserRepo;
import com.elitesland.yst.system.repo.SysUserRepoProc;
import com.elitesland.yst.system.service.SysUserService;
import com.elitesland.yst.system.service.rpc.SysOauth2RpcService;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
@UnicomTag(value="GENERAL")
public class SysOauth2RpcServiceImpl
implements SysOauth2RpcService {
    private final SysUserRepo sysUserRepo;
    private final SysUserRepoProc sysUserRepoProc;
    private final SysUserService sysUserService;

    public ApiResult<SysUserDTO> sysUserByWxOpenId(String openid) {
        List<SysUserDO> sysUserDOS = this.sysUserRepo.findByWxOpenid(openid);
        if (sysUserDOS == null || sysUserDOS.isEmpty()) {
            return ApiResult.fail((String)"is null");
        }
        if (sysUserDOS.size() > 1) {
            return ApiResult.fail((String)"is multi");
        }
        return ApiResult.ok((Object)this.sysUserDOToDTO(sysUserDOS.get(0)));
    }

    private SysUserDTO sysUserDOToDTO(SysUserDO sysUserDO) {
        SysUserDTO sysUserDTO = new SysUserDTO();
        sysUserDTO.setId(sysUserDO.getId());
        sysUserDTO.setTenantId(sysUserDO.getTenantId());
        sysUserDTO.setRemark(sysUserDO.getRemark());
        sysUserDTO.setDeleteFlag(sysUserDO.getDeleteFlag());
        sysUserDTO.setUsername(sysUserDO.getUsername());
        sysUserDTO.setLastName(sysUserDO.getLastName());
        sysUserDTO.setFirstName(sysUserDO.getFirstName());
        sysUserDTO.setMobile(sysUserDO.getMobile());
        sysUserDTO.setEmail(sysUserDO.getEmail());
        sysUserDTO.setPassword(sysUserDO.getPassword());
        sysUserDTO.setSourceType(sysUserDO.getSourceType());
        sysUserDTO.setEnabled(sysUserDO.getEnabled());
        sysUserDTO.setNeedReset(sysUserDO.getNeedReset());
        return sysUserDTO;
    }

    public ApiResult<SysUserDTO> sysUserByMobile(String mobile) {
        List<SysUserDO> sysUserDOS = this.sysUserRepo.findByMobile(mobile);
        if (sysUserDOS == null || sysUserDOS.isEmpty()) {
            return ApiResult.fail((String)"is null");
        }
        if (sysUserDOS.size() > 1) {
            return ApiResult.fail((String)"is multi");
        }
        return ApiResult.ok((Object)this.sysUserDOToDTO(sysUserDOS.get(0)));
    }

    public ApiResult<SysUserDTO> sysUserByMobile(String mobile, String password) {
        List<SysUserDO> sysUserDOS = this.sysUserRepo.findByMobileAndPassword(mobile, password);
        if (sysUserDOS == null || sysUserDOS.isEmpty()) {
            return ApiResult.fail((String)"is null");
        }
        if (sysUserDOS.size() > 1) {
            return ApiResult.fail((String)"is multi");
        }
        return ApiResult.ok((Object)this.sysUserDOToDTO(sysUserDOS.get(0)));
    }

    public ApiResult<Long> sysUserCreate(SysUserNewParam user, String password) {
        try {
            return ApiResult.ok((Object)this.sysUserService.create(user, password));
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u7cfb\u7edf\u57df\u5f02\u5e38:" + e.getMessage()));
        }
    }

    public Boolean existsByUserName(String UserName) {
        return this.sysUserRepo.existsByUsername(UserName);
    }

    public Boolean existsByUserMobile(String mobile) {
        return this.sysUserRepo.existsByMobile(mobile);
    }

    public ApiResult<String> sysUserBindingWx(String userName, String openid) {
        try {
            List<SysUserDO> sysUserDOS = this.sysUserRepo.findByWxOpenid(openid);
            if (sysUserDOS == null || sysUserDOS.isEmpty()) {
                this.sysUserRepoProc.updateOpenidByUserName(openid, userName);
                return ApiResult.ok();
            }
            return ApiResult.fail((String)"openid\u5df2\u7ecf\u88ab\u7ed1\u5b9a");
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u7cfb\u7edf\u57df\u5f02\u5e38:" + e.getMessage()));
        }
    }

    public SysOauth2RpcServiceImpl(SysUserRepo sysUserRepo, SysUserRepoProc sysUserRepoProc, SysUserService sysUserService) {
        this.sysUserRepo = sysUserRepo;
        this.sysUserRepoProc = sysUserRepoProc;
        this.sysUserService = sysUserService;
    }
}

