/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BeanUtil {
    public static final String FORMAT_CST = "EEE MMM dd HH:mm:ss Z yyyy";
    public static final String FORMAT_YYYY_MM_DD_HHMMSS = "yyyy-MM-dd HH:mm:ss";

    public static Map<String, String> ConvertObjToMapString(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                Object value;
                String key = property.getName();
                String type = property.getPropertyType().getName();
                if (key.equals("class") || (value = (getter = property.getReadMethod()).invoke(obj, new Object[0])) == null) continue;
                String v = value.toString();
                switch (type) {
                    case "java.util.Date": {
                        v = BeanUtil.convertToString(BeanUtil.paserCSTToDate(v), FORMAT_YYYY_MM_DD_HHMMSS);
                        break;
                    }
                }
                map.put(key, v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> ConvertObjToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                Object value;
                String key = property.getName();
                if (key.equals("class") || (value = (getter = property.getReadMethod()).invoke(obj, new Object[0])) == null) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Date paserCSTToDate(String strDate) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_CST, Locale.UK);
        Date date = null;
        date = sdf.parse(strDate);
        return date;
    }

    public static String convertToString(Date date, String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(str);
        return sdf.format(date);
    }
}

