/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.system.util;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.yst.system.util.BeanUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    private static Logger log = LoggerFactory.getLogger(HttpRequestUtil.class);
    private CloseableHttpClient httpClient;
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final Map<String, String> DEFAULT_HEADERS_FORM_UTF8 = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_HEADERS_JSON_UTF8;

    public static HttpRequestUtil createDefault() {
        return new HttpRequestUtil(20000, 20000, 20000, DEFAULT_ENCODING);
    }

    public HttpRequestUtil(int connectionRequestTimeout, int connectionTimeout, int socketTimeout, String defaultCharset) {
        this.init(connectionRequestTimeout, connectionTimeout, socketTimeout, defaultCharset, null);
    }

    public HttpRequestUtil(int connectionRequestTimeout, int connectionTimeout, int socketTimeout, String defaultCharset, String proxyServer) {
        this.init(connectionRequestTimeout, connectionTimeout, socketTimeout, defaultCharset, proxyServer);
    }

    private void init(int connectionRequestTimeout, int connectionTimeout, int socketTimeout, String defaultCharset, String proxyServer) {
        this.httpClient = HttpClients.createDefault();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder.setConnectionRequestTimeout(connectionRequestTimeout);
        requestBuilder.setConnectTimeout(connectionTimeout);
        requestBuilder.setSocketTimeout(socketTimeout);
        if (StringUtils.isNotEmpty((CharSequence)proxyServer)) {
            requestBuilder.setProxy(HttpHost.create((String)proxyServer));
        }
        requestBuilder.build();
    }

    private String execute(HttpUriRequest request) {
        CloseableHttpResponse response = null;
        request.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        String content = null;
        try {
            response = this.httpClient.execute(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_ENCODING);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                response = null;
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        response = null;
        System.out.println(content);
        return content;
    }

    public String doGet(String url) {
        return this.execute((HttpUriRequest)new HttpGet(url));
    }

    public String doGet(String url, Map<String, String> param) {
        UrlBuilder s = new UrlBuilder(url);
        try {
            s.parameter(param);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.execute((HttpUriRequest)new HttpGet(s.build()));
    }

    public String doGetObject(String url, Object param) {
        Map<String, String> map = BeanUtil.ConvertObjToMapString(param);
        return this.doGet(url, map);
    }

    public JSONObject doGetToJsonObject(String url) {
        String responseStr = this.doGet(url);
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        return JSONObject.parseObject((String)responseStr);
    }

    public String doPost(String url, Map<String, String> param) {
        HttpPost request = new HttpPost(url);
        if (param != null) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : param.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                list.add(pair);
            }
            try {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(list, DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.execute((HttpUriRequest)request);
    }

    public String doPostObject(String url, Object param) {
        Map<String, String> map = BeanUtil.ConvertObjToMapString(param);
        return this.doPost(url, map);
    }

    public JSONObject doPostObjectToJsonObject(String url, Object param) {
        String responseStr = this.doPostObject(url, param);
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        return JSONObject.parseObject((String)responseStr);
    }

    public JSONObject doPostMapToJsonObject(String url, Map<String, String> param) {
        String responseStr = this.doPost(url, param);
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        return JSONObject.parseObject((String)responseStr);
    }

    public String doPut(String url, Map<String, String> param) {
        HttpPut request = new HttpPut(url);
        if (param != null) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : param.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                list.add(pair);
            }
            try {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(list, DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.execute((HttpUriRequest)request);
    }

    public String doPutObject(String url, Object param) {
        Map<String, String> map = BeanUtil.ConvertObjToMapString(param);
        return this.doPut(url, map);
    }

    public String doDelete(String url) {
        return this.execute((HttpUriRequest)new HttpDelete(url));
    }

    public String doDelete(String url, Map<String, String> param) {
        UrlBuilder s = new UrlBuilder(url);
        try {
            s.parameter(param);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.doDelete(s.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostJson(String url, Map<String, String> param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            if (param != null) {
                StringEntity entity = new StringEntity(JSONObject.toJSONString(param), ContentType.APPLICATION_JSON);
                httpPost.setEntity((HttpEntity)entity);
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("");
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostHeaderJson(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            for (String key : headers.keySet()) {
                httpPost.setHeader(key, headers.get(key));
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(JSONObject.toJSONString(params), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            String string = resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject doPostHeader(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            for (String key : headers.keySet()) {
                httpPost.setHeader(key, headers.get(key));
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(JSONObject.toJSONString(params), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            JSONObject jSONObject = JSONObject.parseObject((String)resultString);
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new JSONObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostObjectHeader(String url, Map<String, String> headers, Object params) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            for (String key : headers.keySet()) {
                httpPost.setHeader(key, headers.get(key));
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(JSONObject.toJSONString((Object)params), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            String string = resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    static {
        DEFAULT_HEADERS_FORM_UTF8.put("Content-Type", "application/x-www-form-urlencoded");
        DEFAULT_HEADERS_FORM_UTF8.put("Content-Encoding", DEFAULT_ENCODING);
        DEFAULT_HEADERS_JSON_UTF8 = new HashMap<String, String>();
        DEFAULT_HEADERS_JSON_UTF8.put("Content-Type", "application/json");
        DEFAULT_HEADERS_JSON_UTF8.put("Content-Encoding", DEFAULT_ENCODING);
    }

    public static final class UrlBuilder {
        private StringBuilder sBuilder;
        private boolean hasParameter = false;

        public UrlBuilder(String url) {
            this.sBuilder = new StringBuilder(url);
        }

        public UrlBuilder parameter(String k, Object v) throws UnsupportedEncodingException {
            if (k != null && v != null) {
                if (this.hasParameter) {
                    this.sBuilder.append('&');
                } else {
                    this.sBuilder.append('?');
                }
                this.sBuilder.append(URLEncoder.encode(k, DEFAULT_ENCODING)).append('=').append(URLEncoder.encode(v.toString(), DEFAULT_ENCODING));
                this.hasParameter = true;
            }
            return this;
        }

        public UrlBuilder parameter(Map<String, String> map) throws UnsupportedEncodingException {
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!StringUtils.isNotEmpty((CharSequence)entry.getKey()) || !StringUtils.isNotEmpty((CharSequence)entry.getValue())) continue;
                    this.parameter(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public String build() {
            return this.sBuilder.toString();
        }
    }
}

