create table COM_CITY_CODE
(
    ID                 NUMBER(19)    not null
        constraint PK_COM_CITY_CODE
            primary key,
    AREA_NAME          NVARCHAR2(40) not null,
    AREA_CODE          NVARCHAR2(40) not null,
    AREA_TYPE          NVARCHAR2(40),
    SHORT_NAME         NVARCHAR2(40),
    ENGLISH_NAME       NVARCHAR2(40),
    AREA_LEVEL         NVARCHAR2(40),
    PID                NUMBER(19)    not null,
    AREA_STATUS        NVARCHAR2(40),
    AREA_SPELL         NVARCHAR2(40),
    AREA_SHSPELL       NVARCHAR2(40),
    TEL_HEAD           NVARCHAR2(40),
    ZIP_CODE           NVARCHAR2(40),
    AREA_DESC          NVARCHAR2(255),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10)    not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    AREA_TYPE2         VARCHAR2(40)
)
/

comment on table COM_CITY_CODE is '区域定义'
/

comment on column COM_CITY_CODE.ID is '记录唯一ID'
/

comment on column COM_CITY_CODE.AREA_NAME is '区域名称'
/

comment on column COM_CITY_CODE.AREA_CODE is '区域代码'
/

comment on column COM_CITY_CODE.AREA_TYPE is '区域类型'
/

comment on column COM_CITY_CODE.SHORT_NAME is '区域简称'
/

comment on column COM_CITY_CODE.ENGLISH_NAME is '英文名称'
/

comment on column COM_CITY_CODE.AREA_LEVEL is '区域等级'
/

comment on column COM_CITY_CODE.PID is '上级ID'
/

comment on column COM_CITY_CODE.AREA_STATUS is '地址状态'
/

comment on column COM_CITY_CODE.AREA_SPELL is '汉语拼音'
/

comment on column COM_CITY_CODE.AREA_SHSPELL is '拼音首字母'
/

comment on column COM_CITY_CODE.TEL_HEAD is '区号'
/

comment on column COM_CITY_CODE.ZIP_CODE is '邮编'
/

comment on column COM_CITY_CODE.AREA_DESC is '区域描述'
/

comment on column COM_CITY_CODE.TENANT_ID is '租户ID'
/

comment on column COM_CITY_CODE.REMARK is '备注'
/

comment on column COM_CITY_CODE.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_CITY_CODE.CREATOR is '记录创建者'
/

comment on column COM_CITY_CODE.CREATE_TIME is '记录创建时间'
/

comment on column COM_CITY_CODE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_CITY_CODE.UPDATER is '记录最后更新者'
/

comment on column COM_CITY_CODE.MODIFY_TIME is '记录最后更新时间'
/

comment on column COM_CITY_CODE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_CITY_CODE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column COM_CITY_CODE.SEC_BU_ID is 'sec_bu_id'
/

comment on column COM_CITY_CODE.SEC_USER_ID is 'sec_user_id'
/

comment on column COM_CITY_CODE.SEC_OU_ID is 'sec_ou_id'
/

comment on column COM_CITY_CODE.AREA_TYPE2 is '区域类型2'
/

create index IDX_AREA_AREA_NAME
    on COM_CITY_CODE (AREA_NAME)
/

create index IDX_COM_CITY_CODE_CREATE_USER0
    on COM_CITY_CODE (CREATE_USER_ID)
/

create index SEC_USER_ID_INDEX
    on COM_CITY_CODE (SEC_USER_ID)
/

create unique index UK_AREA_AREA_CODE
    on COM_CITY_CODE (AREA_CODE)
/

create index SEC_OU_ID_INDEX
    on COM_CITY_CODE (SEC_OU_ID)
/

create index IDX_AREA_PID
    on COM_CITY_CODE (PID)
/

create index SEC_BU_ID_INDEX
    on COM_CITY_CODE (SEC_BU_ID)
/
