create table COM_CURR_RATE
(
    ID                 NUMBER(19) not null
        constraint PK_COM_CURR_RATE
            primary key,
    OU_ID              NUMBER(10),
    RATE_TYPE          NVARCHAR2(40),
    RATE_TYPE2         NVARCHAR2(40),
    RATE_TYPE3         NVARCHAR2(40),
    RATE_STATUS        NVARCHAR2(40),
    RATE_STATUS2       NVARCHAR2(40),
    RATE_SOURCE        NVARCHAR2(40),
    FROM_CURR          NVARCHAR2(40),
    TO_CURR            NVARCHAR2(40),
    CAL_METHOD         NVARCHAR2(40),
    RATIO              FLOAT(24),
    RATIO2             FLOAT(24),
    RATIO3             FLOAT(24),
    VALID_FROM         DATE,
    VALID_TO           DATE,
    PERIOD_ID          NUMBER(10),
    TENANT_ID          NUMBER(19) default '0',
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19) default '0',
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19) default '0',
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10) default '0',
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table COM_CURR_RATE is '汇率'
/

comment on column COM_CURR_RATE.ID is '唯一编号ID'
/

comment on column COM_CURR_RATE.OU_ID is '公司ID'
/

comment on column COM_CURR_RATE.RATE_TYPE is '汇率类型'
/

comment on column COM_CURR_RATE.RATE_TYPE2 is '汇率类型2'
/

comment on column COM_CURR_RATE.RATE_TYPE3 is '汇率类型3'
/

comment on column COM_CURR_RATE.RATE_STATUS is '汇率状态'
/

comment on column COM_CURR_RATE.RATE_STATUS2 is '汇率状态2'
/

comment on column COM_CURR_RATE.RATE_SOURCE is '汇率来源'
/

comment on column COM_CURR_RATE.FROM_CURR is '从币种'
/

comment on column COM_CURR_RATE.TO_CURR is '到币种'
/

comment on column COM_CURR_RATE.CAL_METHOD is '计算方法'
/

comment on column COM_CURR_RATE.RATIO is '汇率'
/

comment on column COM_CURR_RATE.RATIO2 is '汇率2'
/

comment on column COM_CURR_RATE.RATIO3 is '汇率3'
/

comment on column COM_CURR_RATE.VALID_FROM is '生效日期'
/

comment on column COM_CURR_RATE.VALID_TO is '失效日期'
/

comment on column COM_CURR_RATE.PERIOD_ID is '期间ID'
/

comment on column COM_CURR_RATE.TENANT_ID is '租户ID'
/

comment on column COM_CURR_RATE.REMARK is '备注'
/

comment on column COM_CURR_RATE.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_CURR_RATE.CREATE_TIME is '记录创建时间'
/

comment on column COM_CURR_RATE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_CURR_RATE.MODIFY_TIME is '记录最后更新时间'
/

comment on column COM_CURR_RATE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_CURR_RATE.AUDIT_DATA_VERSION is '版本信息，前端不用传'
/

comment on column COM_CURR_RATE.CREATOR is '记录创建者'
/

comment on column COM_CURR_RATE.UPDATER is '记录最后更新者'
/

comment on column COM_CURR_RATE.SEC_BU_ID is 'sec_bu_id'
/

comment on column COM_CURR_RATE.SEC_USER_ID is 'sec_user_id'
/

comment on column COM_CURR_RATE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_COM_CURR_RATE_CREATE_USER0
    on COM_CURR_RATE (CREATE_USER_ID)
/

create index IDX_COM_CURR_RATE_SEC_USER_ID
    on COM_CURR_RATE (SEC_USER_ID)
/

create index IDX_COM_CURR_RATE_SEC_OU_ID
    on COM_CURR_RATE (SEC_OU_ID)
/

create index IDX_COM_CURR_RATE_SEC_BU_ID
    on COM_CURR_RATE (SEC_BU_ID)
/

