create table COM_CURR
(
    ID                 NUMBER(19) not null
        constraint PK_COM_CURR
            primary key,
    CURR_CODE          NVARCHAR2(40),
    CURR_NAME          NVARCHAR2(40),
    DISP_DECIMAL       NUMBER(10),
    ENABLE_FLAG        NUMBER(10),
    TENANT_ID          NUMBER(19) default '0',
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19) default '0',
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19) default '0',
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10) default '0',
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    OU_ID              NUMBER(19),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table COM_CURR is '币种'
/

comment on column COM_CURR.ID is '唯一编号ID'
/

comment on column COM_CURR.CURR_CODE is '币种代码'
/

comment on column COM_CURR.CURR_NAME is '币种名称'
/

comment on column COM_CURR.DISP_DECIMAL is '显示小数位数'
/

comment on column COM_CURR.ENABLE_FLAG is '是否有效'
/

comment on column COM_CURR.TENANT_ID is '租户ID'
/

comment on column COM_CURR.REMARK is '备注'
/

comment on column COM_CURR.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_CURR.CREATE_TIME is 'create_time'
/

comment on column COM_CURR.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_CURR.MODIFY_TIME is 'modify_time'
/

comment on column COM_CURR.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_CURR.AUDIT_DATA_VERSION is '版本信息，前端不用传'
/

comment on column COM_CURR.CREATOR is '记录创建者'
/

comment on column COM_CURR.UPDATER is '记录最后更新者'
/

comment on column COM_CURR.OU_ID is '公司ID'
/

comment on column COM_CURR.SEC_BU_ID is 'sec_bu_id'
/

comment on column COM_CURR.SEC_USER_ID is 'sec_user_id'
/

comment on column COM_CURR.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_COM_CURR_CREATE_USER_ID
    on COM_CURR (CREATE_USER_ID)
/

create unique index UK_CURR_CODE
    on COM_CURR (CURR_CODE)
/

create index IDX_COM_CURR_SEC_USER_ID
    on COM_CURR (SEC_USER_ID)
/

create index IDX_COM_CURR_SEC_OU_ID
    on COM_CURR (SEC_OU_ID)
/

create index IDX_COM_CURR_SEC_BU_ID
    on COM_CURR (SEC_BU_ID)
/
