create table COM_DISTRICT
(
    ID                 NUMBER(19)    not null
        constraint PK_COM_DISTRICT
            primary key,
    DIST_CODE          NVARCHAR2(32) not null,
    DIST_NAME          NVARCHAR2(64) not null,
    DIST_NAME2         NVARCHAR2(64),
    DIST_TYPE          NVARCHAR2(32),
    DIST_TYPE2         NVARCHAR2(32),
    DIST_TYPE3         NVARCHAR2(32),
    ABBR_NAME          NVARCHAR2(32),
    COUNTRY            NVARCHAR2(32),
    PROVINCE           NVARCHAR2(32),
    CITY               NVARCHAR2(32),
    COUNTY             NVARCHAR2(32),
    STREET             NVARCHAR2(128),
    DIST_LEVEL         NVARCHAR2(32),
    DIST_LEVEL_NUM     NUMBER(10) default '0',
    PARENT_ID          NUMBER(19) default '0',
    PARENT_CODE        NVARCHAR2(32),
    PATH               NVARCHAR2(1024),
    DIST_STATUS        NVARCHAR2(32),
    DIST_PINYIN        NVARCHAR2(256),
    DIST_PINYIN_CAPS   NVARCHAR2(32),
    TEL_HEAD           NVARCHAR2(32),
    ZIP_CODE           NVARCHAR2(16),
    DIST_DESC          NVARCHAR2(256),
    ES1                NVARCHAR2(64),
    ES2                NVARCHAR2(64),
    ES3                NVARCHAR2(64),
    TENANT_ID          NUMBER(19) default '0',
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19) default '0',
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19) default '0',
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10) default '0',
    P_ID               NUMBER(19) default '0',
    P_CODE             NVARCHAR2(32),
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table COM_DISTRICT is '行政区划'
/

comment on column COM_DISTRICT.ID is '唯一编号ID'
/

comment on column COM_DISTRICT.DIST_CODE is '区划代码'
/

comment on column COM_DISTRICT.DIST_NAME is '区划名称'
/

comment on column COM_DISTRICT.DIST_NAME2 is '区划名称2'
/

comment on column COM_DISTRICT.DIST_TYPE is '区划类型'
/

comment on column COM_DISTRICT.DIST_TYPE2 is '区划类型2'
/

comment on column COM_DISTRICT.DIST_TYPE3 is '区划类型33'
/

comment on column COM_DISTRICT.ABBR_NAME is '区划简称'
/

comment on column COM_DISTRICT.COUNTRY is '国家码: COM:COUNTRY'
/

comment on column COM_DISTRICT.PROVINCE is '省份、州码：COM:STATE'
/

comment on column COM_DISTRICT.CITY is '城市码：COM:CITY'
/

comment on column COM_DISTRICT.COUNTY is '区县码: COM:COUNTY'
/

comment on column COM_DISTRICT.STREET is '乡镇街道'
/

comment on column COM_DISTRICT.DIST_LEVEL is '区域等级'
/

comment on column COM_DISTRICT.DIST_LEVEL_NUM is '区域等级数值'
/

comment on column COM_DISTRICT.PARENT_ID is '上级ID'
/

comment on column COM_DISTRICT.PARENT_CODE is '上级代码'
/

comment on column COM_DISTRICT.PATH is '路径'
/

comment on column COM_DISTRICT.DIST_STATUS is '地址状态'
/

comment on column COM_DISTRICT.DIST_PINYIN is '汉语拼音'
/

comment on column COM_DISTRICT.DIST_PINYIN_CAPS is '拼音首字母'
/

comment on column COM_DISTRICT.TEL_HEAD is '电话区号'
/

comment on column COM_DISTRICT.ZIP_CODE is '邮编'
/

comment on column COM_DISTRICT.DIST_DESC is '区域描述'
/

comment on column COM_DISTRICT.ES1 is '扩展字符串1'
/

comment on column COM_DISTRICT.ES2 is '扩展字符串2'
/

comment on column COM_DISTRICT.ES3 is '扩展字符串3'
/

comment on column COM_DISTRICT.TENANT_ID is '租户ID'
/

comment on column COM_DISTRICT.REMARK is '备注'
/

comment on column COM_DISTRICT.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_DISTRICT.CREATE_TIME is 'create_time'
/

comment on column COM_DISTRICT.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_DISTRICT.MODIFY_TIME is 'modify_time'
/

comment on column COM_DISTRICT.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_DISTRICT.AUDIT_DATA_VERSION is '版本信息，前端不用传'
/

comment on column COM_DISTRICT.P_ID is '上级ID'
/

comment on column COM_DISTRICT.P_CODE is '上级代码'
/

comment on column COM_DISTRICT.CREATOR is '记录创建者'
/

comment on column COM_DISTRICT.UPDATER is '记录最后更新者'
/

comment on column COM_DISTRICT.SEC_BU_ID is 'sec_bu_id'
/

comment on column COM_DISTRICT.SEC_USER_ID is 'sec_user_id'
/

comment on column COM_DISTRICT.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_COM_DISTRICT_CREATE_USER_0
    on COM_DISTRICT (CREATE_USER_ID)
/

create index DIST_CODE_2
    on COM_DISTRICT (DIST_CODE, DIST_LEVEL_NUM)
/

create index IDX_COM_DISTRICT_SEC_USER_ID
    on COM_DISTRICT (SEC_USER_ID)
/

create index DIST_CODE
    on COM_DISTRICT (DIST_CODE)
/

create index IDX_COM_DISTRICT_SEC_OU_ID
    on COM_DISTRICT (SEC_OU_ID)
/

create index IDX_COM_DISTRICT_SEC_BU_ID
    on COM_DISTRICT (SEC_BU_ID)
/

