create table COM_PAYMENT_TERM
(
    ID                 NUMBER(19) not null
        constraint PK_COM_PAYMENT_TERM
            primary key,
    PT_CODE            NVARCHAR2(40),
    PT_NAME            NVARCHAR2(40),
    DAYS               NUMBER(10),
    BASE_DAY_TYPE      NVARCHAR2(40),
    DAY_CALC_METHOD    NVARCHAR2(40),
    DUE_DAY            DATE,
    ENABLE_FLAG        NUMBER(10) default '0',
    TENANT_ID          NUMBER(19) default '0',
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19) default '0',
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19) default '0',
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10) default '0',
    VALID_FROM         DATE,
    VALID_TO           DATE,
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    ACCOUNT_CODE       NVARCHAR2(40)
)
/

comment on table COM_PAYMENT_TERM is '支付条款 币种 此表使用CODE来引用，不使用ID。'
/

comment on column COM_PAYMENT_TERM.ID is '唯一编号ID'
/

comment on column COM_PAYMENT_TERM.PT_CODE is '代码'
/

comment on column COM_PAYMENT_TERM.PT_NAME is '名称'
/

comment on column COM_PAYMENT_TERM.DAYS is '天数'
/

comment on column COM_PAYMENT_TERM.BASE_DAY_TYPE is '基于日期类型'
/

comment on column COM_PAYMENT_TERM.DAY_CALC_METHOD is '日期计算方式 是否含工作日'
/

comment on column COM_PAYMENT_TERM.DUE_DAY is '到期日期'
/

comment on column COM_PAYMENT_TERM.ENABLE_FLAG is '是否有效'
/

comment on column COM_PAYMENT_TERM.TENANT_ID is '租户ID'
/

comment on column COM_PAYMENT_TERM.REMARK is '备注'
/

comment on column COM_PAYMENT_TERM.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_PAYMENT_TERM.CREATE_TIME is '记录创建时间'
/

comment on column COM_PAYMENT_TERM.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_PAYMENT_TERM.MODIFY_TIME is '记录最后更新时间'
/

comment on column COM_PAYMENT_TERM.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_PAYMENT_TERM.AUDIT_DATA_VERSION is '版本信息，前端不用传'
/

comment on column COM_PAYMENT_TERM.VALID_FROM is '生效日期'
/

comment on column COM_PAYMENT_TERM.VALID_TO is '失效日期'
/

comment on column COM_PAYMENT_TERM.CREATOR is '记录创建者'
/

comment on column COM_PAYMENT_TERM.UPDATER is '记录最后更新者'
/

comment on column COM_PAYMENT_TERM.SEC_BU_ID is 'sec_bu_id'
/

comment on column COM_PAYMENT_TERM.SEC_USER_ID is 'sec_user_id'
/

comment on column COM_PAYMENT_TERM.SEC_OU_ID is 'sec_ou_id'
/

comment on column COM_PAYMENT_TERM.ACCOUNT_CODE is '对账报账编码'
/

create index IDX_COM_PAYMENT_TERM_CREATE_U0
    on COM_PAYMENT_TERM (CREATE_USER_ID)
/

create index IDX_COM_PAYMENT_TERM_SEC_USER0
    on COM_PAYMENT_TERM (SEC_USER_ID)
/

create index IDX_COM_PAYMENT_TERM_SEC_OU_ID
    on COM_PAYMENT_TERM (SEC_OU_ID)
/

create index IDX_COM_PAYMENT_TERM_SEC_BU_ID
    on COM_PAYMENT_TERM (SEC_BU_ID)
/

create index PT_CODE
    on COM_PAYMENT_TERM (PT_CODE)
/
