create table COM_TAX_CODE
(
    ID                 NUMBER(19) not null
        constraint PK_COM_TAX_CODE
            primary key,
    TAX_NAME           NVARCHAR2(40),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    TAX_TYPE           NVARCHAR2(40),
    TAX_CODE           NVARCHAR2(40)
)
/

comment on table COM_TAX_CODE is '税码'
/

comment on column COM_TAX_CODE.ID is '记录唯一ID'
/

comment on column COM_TAX_CODE.TAX_NAME is '税区/税码'
/

comment on column COM_TAX_CODE.TENANT_ID is '租户ID'
/

comment on column COM_TAX_CODE.REMARK is '备注'
/

comment on column COM_TAX_CODE.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_TAX_CODE.CREATOR is '记录创建者'
/

comment on column COM_TAX_CODE.CREATE_TIME is '记录创建时间'
/

comment on column COM_TAX_CODE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_TAX_CODE.UPDATER is '记录最后更新者'
/

comment on column COM_TAX_CODE.MODIFY_TIME is '记录最后更新时间'
/

comment on column COM_TAX_CODE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_TAX_CODE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column COM_TAX_CODE.TAX_TYPE is '税区'
/

comment on column COM_TAX_CODE.TAX_CODE is '税码'
/

create index IDX_COM_TAX_CODE_CREATE_USER_0
    on COM_TAX_CODE (CREATE_USER_ID)
/

