create table COM_TAX_RATE
(
    ID                 NUMBER(19) not null
        constraint PK_COM_TAX_RATE
            primary key,
    OU_ID              NUMBER(19),
    TAX_RATE_NO        NVARCHAR2(40),
    TAX_RATE_DESC      NVARCHAR2(40),
    VALID_FROM         DATE,
    VALID_TO           DATE,
    TAX_RATE_VALUE     FLOAT(24),
    TENANT_ID          NUMBER(19) default '0',
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19) default '0',
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19) default '0',
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) default '0',
    AUDIT_DATA_VERSION NUMBER(10) default '0',
    TAX_RATE_INDEX     NVARCHAR2(40),
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table COM_TAX_RATE is '税率'
/

comment on column COM_TAX_RATE.ID is '唯一编号ID'
/

comment on column COM_TAX_RATE.OU_ID is '公司ID'
/

comment on column COM_TAX_RATE.TAX_RATE_NO is '税率编号'
/

comment on column COM_TAX_RATE.TAX_RATE_DESC is '税率说明'
/

comment on column COM_TAX_RATE.VALID_FROM is '生效日期'
/

comment on column COM_TAX_RATE.VALID_TO is '失效日期'
/

comment on column COM_TAX_RATE.TAX_RATE_VALUE is '税率值'
/

comment on column COM_TAX_RATE.TENANT_ID is '租户ID'
/

comment on column COM_TAX_RATE.REMARK is '备注'
/

comment on column COM_TAX_RATE.CREATE_USER_ID is '记录创建者ID'
/

comment on column COM_TAX_RATE.CREATE_TIME is '记录创建时间'
/

comment on column COM_TAX_RATE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COM_TAX_RATE.MODIFY_TIME is '记录最后更新时间'
/

comment on column COM_TAX_RATE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COM_TAX_RATE.AUDIT_DATA_VERSION is '版本信息，前端不用传'
/

comment on column COM_TAX_RATE.TAX_RATE_INDEX is '税率索引 [UOM]COM:TAX_RATE_INDEX'
/

comment on column COM_TAX_RATE.CREATOR is '记录创建者'
/

comment on column COM_TAX_RATE.UPDATER is '记录最后更新者'
/

comment on column COM_TAX_RATE.SEC_BU_ID is 'sec_bu_id'
/

comment on column COM_TAX_RATE.SEC_USER_ID is 'sec_user_id'
/

comment on column COM_TAX_RATE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_COM_TAX_RATE_CREATE_USER_0
    on COM_TAX_RATE (CREATE_USER_ID)
/

create index IDX_COM_TAX_RATE_SEC_USER_ID
    on COM_TAX_RATE (SEC_USER_ID)
/

create index IDX_COM_TAX_RATE_SEC_OU_ID
    on COM_TAX_RATE (SEC_OU_ID)
/

create index TAX_RATE_NO
    on COM_TAX_RATE (TAX_RATE_NO)
/

create index IDX_COM_TAX_RATE_SEC_BU_ID
    on COM_TAX_RATE (SEC_BU_ID)
/
