create table COMMON_ORG_BU_TREED
(
    ID                 NUMBER(19) not null
        constraint PK_COMMON_ORG_BU_TREED
            primary key,
    PID                NUMBER(19) not null,
    SORT_NO            NUMBER(10),
    GRADE              NUMBER(10),
    CODE_PATH          NVARCHAR2(255),
    BU_TREE_ID         NUMBER(19),
    BU_ID              NUMBER(19),
    BU_CODE            NVARCHAR2(40),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table COMMON_ORG_BU_TREED is '组织树明细'
/

comment on column COMMON_ORG_BU_TREED.ID is '记录唯一ID'
/

comment on column COMMON_ORG_BU_TREED.PID is '上级ID'
/

comment on column COMMON_ORG_BU_TREED.SORT_NO is '排序号'
/

comment on column COMMON_ORG_BU_TREED.GRADE is '层级'
/

comment on column COMMON_ORG_BU_TREED.CODE_PATH is '树型结构编号全路径，使用/隔离'
/

comment on column COMMON_ORG_BU_TREED.BU_TREE_ID is '组织树ID'
/

comment on column COMMON_ORG_BU_TREED.BU_ID is '组织ID'
/

comment on column COMMON_ORG_BU_TREED.BU_CODE is 'bu_code'
/

comment on column COMMON_ORG_BU_TREED.TENANT_ID is '租户ID'
/

comment on column COMMON_ORG_BU_TREED.REMARK is '备注'
/

comment on column COMMON_ORG_BU_TREED.CREATE_USER_ID is '记录创建者ID'
/

comment on column COMMON_ORG_BU_TREED.CREATOR is '记录创建者'
/

comment on column COMMON_ORG_BU_TREED.CREATE_TIME is '记录创建时间'
/

comment on column COMMON_ORG_BU_TREED.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COMMON_ORG_BU_TREED.UPDATER is '记录最后更新者'
/

comment on column COMMON_ORG_BU_TREED.MODIFY_TIME is '记录最后更新时间'
/

comment on column COMMON_ORG_BU_TREED.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COMMON_ORG_BU_TREED.AUDIT_DATA_VERSION is '锁版本'
/

comment on column COMMON_ORG_BU_TREED.SEC_BU_ID is 'sec_bu_id'
/

comment on column COMMON_ORG_BU_TREED.SEC_USER_ID is 'sec_user_id'
/

comment on column COMMON_ORG_BU_TREED.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_BU_TREE_CODE_PATH
    on COMMON_ORG_BU_TREED (CODE_PATH)
/

create index IDX_BU_TREE_PID
    on COMMON_ORG_BU_TREED (PID)
/

