create table COMMON_ORG_EMP
(
    ID                 NUMBER(19) not null
        constraint PK_COMMON_ORG_EMP
            primary key,
    PID                NUMBER(19) not null,
    SORT_NO            NUMBER(10),
    GRADE              NUMBER(10),
    CODE_PATH          NVARCHAR2(255),
    OU_ID              NUMBER(19),
    OU_CODE            NVARCHAR2(40),
    OU_NAME            NVARCHAR2(40),
    BU_ID              NUMBER(19),
    BU_CODE            NVARCHAR2(40),
    BU_NAME            NVARCHAR2(40),
    EMP_BU_ID          NUMBER(19),
    EMP_BU_TREE_ID     NUMBER(19),
    EMP_BU_TREEDID     NUMBER(19),
    USER_ID            NUMBER(19),
    USER_NAME          NVARCHAR2(40),
    EMP_CODE           NVARCHAR2(40),
    EMP_NAME           NVARCHAR2(40),
    EMP_TYPE           NVARCHAR2(255),
    EMP_TYPE2          NVARCHAR2(40),
    EMP_TYPE3          NVARCHAR2(40),
    EMP_STATUS         NVARCHAR2(40),
    FOREIGN_NAME       NVARCHAR2(40),
    ADDR_NO            NUMBER(19),
    EMP_GENDER         NVARCHAR2(40),
    BIRTH_DATE         DATE,
    EMAIL              NVARCHAR2(40),
    MOBILE             NVARCHAR2(40),
    ID_TYPE            NVARCHAR2(40),
    ID_NO              NVARCHAR2(255),
    EMP_LEVEL          NVARCHAR2(40),
    TITLE              NVARCHAR2(40),
    JOIN_DATE          DATE,
    JDY_FLAG           NUMBER(10) default '1',
    LEAVE_DATE         DATE,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table COMMON_ORG_EMP is '员工'
/

comment on column COMMON_ORG_EMP.ID is '记录唯一ID'
/

comment on column COMMON_ORG_EMP.PID is '上级ID'
/

comment on column COMMON_ORG_EMP.SORT_NO is '排序号'
/

comment on column COMMON_ORG_EMP.GRADE is '层级'
/

comment on column COMMON_ORG_EMP.CODE_PATH is '树型结构编号全路径，使用/隔离'
/

comment on column COMMON_ORG_EMP.OU_ID is '公司ID'
/

comment on column COMMON_ORG_EMP.OU_CODE is '公司编号'
/

comment on column COMMON_ORG_EMP.OU_NAME is '公司名称'
/

comment on column COMMON_ORG_EMP.BU_ID is 'BU ID'
/

comment on column COMMON_ORG_EMP.BU_CODE is 'BU编号'
/

comment on column COMMON_ORG_EMP.BU_NAME is 'BU名称'
/

comment on column COMMON_ORG_EMP.EMP_BU_ID is '员工所属 BU ID'
/

comment on column COMMON_ORG_EMP.EMP_BU_TREE_ID is '员工所属BU树ID'
/

comment on column COMMON_ORG_EMP.EMP_BU_TREEDID is '员工所属BU树详情ID'
/

comment on column COMMON_ORG_EMP.USER_ID is '用户id'
/

comment on column COMMON_ORG_EMP.USER_NAME is '用户名'
/

comment on column COMMON_ORG_EMP.EMP_CODE is '雇员编号'
/

comment on column COMMON_ORG_EMP.EMP_NAME is '雇员姓名'
/

comment on column COMMON_ORG_EMP.EMP_TYPE is '员工类型 [UDC]ORG:EMP_TYPE'
/

comment on column COMMON_ORG_EMP.EMP_TYPE2 is '员工类型2'
/

comment on column COMMON_ORG_EMP.EMP_TYPE3 is '员工类型3'
/

comment on column COMMON_ORG_EMP.EMP_STATUS is '员工状态 [UDC]ORG:EMP_STATUS'
/

comment on column COMMON_ORG_EMP.FOREIGN_NAME is '雇员外文名'
/

comment on column COMMON_ORG_EMP.ADDR_NO is '地址号'
/

comment on column COMMON_ORG_EMP.EMP_GENDER is '员工性别'
/

comment on column COMMON_ORG_EMP.BIRTH_DATE is '出生日期'
/

comment on column COMMON_ORG_EMP.EMAIL is '工作邮箱'
/

comment on column COMMON_ORG_EMP.MOBILE is '工作手机号'
/

comment on column COMMON_ORG_EMP.ID_TYPE is '证件类型'
/

comment on column COMMON_ORG_EMP.ID_NO is '证件号码'
/

comment on column COMMON_ORG_EMP.EMP_LEVEL is '职级'
/

comment on column COMMON_ORG_EMP.TITLE is '行政职位, [UDC]ORG:TITLE'
/

comment on column COMMON_ORG_EMP.JOIN_DATE is '入职日期'
/

comment on column COMMON_ORG_EMP.JDY_FLAG is '是否同步激荡云,默认 1 '
/

comment on column COMMON_ORG_EMP.LEAVE_DATE is '离职日期'
/

comment on column COMMON_ORG_EMP.TENANT_ID is '租户ID'
/

comment on column COMMON_ORG_EMP.REMARK is '备注'
/

comment on column COMMON_ORG_EMP.CREATE_USER_ID is '记录创建者ID'
/

comment on column COMMON_ORG_EMP.CREATOR is '记录创建者'
/

comment on column COMMON_ORG_EMP.CREATE_TIME is '记录创建时间'
/

comment on column COMMON_ORG_EMP.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column COMMON_ORG_EMP.UPDATER is '记录最后更新者'
/

comment on column COMMON_ORG_EMP.MODIFY_TIME is '记录最后更新时间'
/

comment on column COMMON_ORG_EMP.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column COMMON_ORG_EMP.AUDIT_DATA_VERSION is '锁版本'
/

comment on column COMMON_ORG_EMP.SEC_BU_ID is 'sec_bu_id'
/

comment on column COMMON_ORG_EMP.SEC_USER_ID is 'sec_user_id'
/

comment on column COMMON_ORG_EMP.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_EMP_CODE_PATH
    on COMMON_ORG_EMP (CODE_PATH)
/

create index IDX_EMP_PID
    on COMMON_ORG_EMP (PID)
/

