create table ROCKET_TRANSACTION_LOG
(
    ID             NUMBER(19)     not null
        constraint PK_ROCKET_TRANSACTION_LOG
            primary key,
    TRANSACTION_ID NVARCHAR2(100) not null,
    DOC_CODE       NVARCHAR2(100),
    PROJECT        NVARCHAR2(200),
    BUSINESS       NVARCHAR2(200),
    EXTEND_JSON    NVARCHAR2(200)
)
/

comment on table ROCKET_TRANSACTION_LOG is 'rocketmnq事务日志'
/

comment on column ROCKET_TRANSACTION_LOG.ID is 'id'
/

comment on column ROCKET_TRANSACTION_LOG.TRANSACTION_ID is '事务id'
/

comment on column ROCKET_TRANSACTION_LOG.DOC_CODE is '文件编号标识'
/

comment on column ROCKET_TRANSACTION_LOG.PROJECT is '项目标识'
/

comment on column ROCKET_TRANSACTION_LOG.BUSINESS is '业务标识'
/

comment on column ROCKET_TRANSACTION_LOG.EXTEND_JSON is '扩展信息'
/

create unique index UK_T6H3PD6FIJDUX5E1FVVRTX99G
    on ROCKET_TRANSACTION_LOG (TRANSACTION_ID)
/

