create table SYS_BIZ_CONSTRAINT
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_BIZ_CONSTRAINT
            primary key,
    DATA_ROLE_CODE     NVARCHAR2(255),
    DATA_ROLE_NAME     NVARCHAR2(255),
    DOMAIN_CODE        NVARCHAR2(255),
    DOMAIN_NAME        NVARCHAR2(255),
    TABLE_CODE         NVARCHAR2(255),
    TABLE_NAME         NVARCHAR2(255),
    FIELD_CODE         NVARCHAR2(255),
    FIELD_CAPTION      NVARCHAR2(255),
    FIELD_TYPE         NVARCHAR2(255),
    UDC_DOMAIN_CODE    NVARCHAR2(255),
    UDC_CODE           NVARCHAR2(255),
    DEFAULT_VALUE      NVARCHAR2(255),
    COMPARE_OP_CODE    NVARCHAR2(255),
    COMPARE_OP_NAME    NVARCHAR2(255),
    CONSTRAINT_VALUES  NVARCHAR2(255),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    FIELD_UDC_TYPE     NVARCHAR2(255),
    META_COLUMN_ID     NUMBER(19)
)
/

comment on table SYS_BIZ_CONSTRAINT is '业务数据权限约束'
/

comment on column SYS_BIZ_CONSTRAINT.ID is '记录唯一ID'
/

comment on column SYS_BIZ_CONSTRAINT.DATA_ROLE_CODE is '数据角色编码'
/

comment on column SYS_BIZ_CONSTRAINT.DATA_ROLE_NAME is '数据角色名称'
/

comment on column SYS_BIZ_CONSTRAINT.DOMAIN_CODE is '领域编码'
/

comment on column SYS_BIZ_CONSTRAINT.DOMAIN_NAME is '领域名称'
/

comment on column SYS_BIZ_CONSTRAINT.TABLE_CODE is '表编码'
/

comment on column SYS_BIZ_CONSTRAINT.TABLE_NAME is '表名称'
/

comment on column SYS_BIZ_CONSTRAINT.FIELD_CODE is '表字段编码'
/

comment on column SYS_BIZ_CONSTRAINT.FIELD_CAPTION is '字段名称'
/

comment on column SYS_BIZ_CONSTRAINT.FIELD_TYPE is '字段类型'
/

comment on column SYS_BIZ_CONSTRAINT.UDC_DOMAIN_CODE is 'UDC的Domain Code'
/

comment on column SYS_BIZ_CONSTRAINT.UDC_CODE is 'UDC的UDC Code'
/

comment on column SYS_BIZ_CONSTRAINT.DEFAULT_VALUE is '默认值'
/

comment on column SYS_BIZ_CONSTRAINT.COMPARE_OP_CODE is '比较符编码'
/

comment on column SYS_BIZ_CONSTRAINT.COMPARE_OP_NAME is '比较符名称'
/

comment on column SYS_BIZ_CONSTRAINT.CONSTRAINT_VALUES is '约束值, 多值采用逗号分隔'
/

comment on column SYS_BIZ_CONSTRAINT.TENANT_ID is '租户ID'
/

comment on column SYS_BIZ_CONSTRAINT.REMARK is '备注'
/

comment on column SYS_BIZ_CONSTRAINT.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_BIZ_CONSTRAINT.CREATOR is '记录创建者'
/

comment on column SYS_BIZ_CONSTRAINT.CREATE_TIME is '记录创建时间'
/

comment on column SYS_BIZ_CONSTRAINT.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_BIZ_CONSTRAINT.UPDATER is '记录最后更新者'
/

comment on column SYS_BIZ_CONSTRAINT.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_BIZ_CONSTRAINT.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_BIZ_CONSTRAINT.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_BIZ_CONSTRAINT.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_BIZ_CONSTRAINT.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_BIZ_CONSTRAINT.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_BIZ_CONSTRAINT.FIELD_UDC_TYPE is '逻辑UDC字段类型META:FLDTYPE'
/

comment on column SYS_BIZ_CONSTRAINT.META_COLUMN_ID is '元数据列的记录ID'
/

