create table SYS_DATA_ROLE_AUTH_CUSTOMIZE
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_DATA_ROLE_AUTH_CUSTOMIZ
            primary key,
    DATA_ROLE_AUTH_ID  NUMBER(19),
    CUSTOMIZE_TYPE     NVARCHAR2(40),
    SEC_ID             NUMBER(19),
    SEC_CODE           NVARCHAR2(40),
    SEC_NAME           NVARCHAR2(40),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_DATA_ROLE_AUTH_CUSTOMIZE is '系统数据角色自定义授权表'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.ID is '记录唯一ID'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.DATA_ROLE_AUTH_ID is '数据角色授权信息ID'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.CUSTOMIZE_TYPE is '自定义类型：人员还是组织'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.SEC_ID is '自定义授权数据ID'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.SEC_CODE is '自定义授权数据CODE'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.SEC_NAME is '自定义授权数据名称'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.TENANT_ID is '租户ID'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.REMARK is '备注'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.CREATOR is '记录创建者'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.UPDATER is '记录最后更新者'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_DATA_ROLE_AUTH_CUSTOMIZE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_DATA_ROLE_AUTH_CUSTOM0
    on SYS_DATA_ROLE_AUTH_CUSTOMIZE (CREATE_USER_ID)
/

create index IDX_SYS_DATA_ROLE_AUTH_CUSTOM1
    on SYS_DATA_ROLE_AUTH_CUSTOMIZE (SEC_USER_ID)
/

create index IDX_SYS_DATA_ROLE_AUTH_CUSTOM2
    on SYS_DATA_ROLE_AUTH_CUSTOMIZE (SEC_OU_ID)
/

create index IDX_SYS_DATA_ROLE_AUTH_CUSTOM3
    on SYS_DATA_ROLE_AUTH_CUSTOMIZE (SEC_BU_ID)
/

