create table SYS_DATA_ROLE_AUTH
(
    ID                   NUMBER(19) not null
        constraint PK_SYS_DATA_ROLE_AUTH
            primary key,
    DATA_ROLE_ID         NUMBER(19),
    IS_BASIC             NUMBER(10),
    PERMISSION_ID        NUMBER(19),
    PERMISSION_CODE      NVARCHAR2(255),
    IS_PERMIT_ALL        NUMBER(10) not null,
    EMP_AUTH_ENABLE      NUMBER(10),
    EMP_AUTH_SCOPE       NVARCHAR2(40),
    EMP_CUSTOMIZE_ENABLE NUMBER(10),
    BU_AUTH_ENABLE       NUMBER(10),
    BU_AUTH_SCOPE        NVARCHAR2(40),
    BU_CUSTOMIZE_ENABLE  NUMBER(10),
    TENANT_ID            NUMBER(19),
    REMARK               NVARCHAR2(255),
    CREATE_USER_ID       NUMBER(19),
    CREATOR              NVARCHAR2(255),
    CREATE_TIME          DATE,
    MODIFY_USER_ID       NUMBER(19),
    UPDATER              NVARCHAR2(255),
    MODIFY_TIME          DATE,
    DELETE_FLAG          NUMBER(10) not null,
    AUDIT_DATA_VERSION   NUMBER(10),
    SEC_BU_ID            NUMBER(19),
    SEC_USER_ID          NUMBER(19),
    SEC_OU_ID            NUMBER(19),
    OU_AUTH_ENABLE       NUMBER(10),
    OU_AUTH_SCOPE        NVARCHAR2(40),
    OU_CUSTOMIZE_ENABLE  NUMBER(10)
)
/

comment on table SYS_DATA_ROLE_AUTH is '系统数据角色授权表'
/

comment on column SYS_DATA_ROLE_AUTH.ID is '记录唯一ID'
/

comment on column SYS_DATA_ROLE_AUTH.DATA_ROLE_ID is '关联的数据角色ID'
/

comment on column SYS_DATA_ROLE_AUTH.IS_BASIC is '是否基础数据授权：1 是，0 否'
/

comment on column SYS_DATA_ROLE_AUTH.PERMISSION_ID is '高级授权应用ID'
/

comment on column SYS_DATA_ROLE_AUTH.PERMISSION_CODE is '高级授权应用Code'
/

comment on column SYS_DATA_ROLE_AUTH.IS_PERMIT_ALL is '是否全部授权全部数据'
/

comment on column SYS_DATA_ROLE_AUTH.EMP_AUTH_ENABLE is '是否启用员工授权'
/

comment on column SYS_DATA_ROLE_AUTH.EMP_AUTH_SCOPE is '员工数据权限授权范围'
/

comment on column SYS_DATA_ROLE_AUTH.EMP_CUSTOMIZE_ENABLE is '员工是否启用自定义授权'
/

comment on column SYS_DATA_ROLE_AUTH.BU_AUTH_ENABLE is '是否启用组织授权'
/

comment on column SYS_DATA_ROLE_AUTH.BU_AUTH_SCOPE is '组织数据权限授权范围'
/

comment on column SYS_DATA_ROLE_AUTH.BU_CUSTOMIZE_ENABLE is '组织是否启用自定义授权'
/

comment on column SYS_DATA_ROLE_AUTH.TENANT_ID is '租户ID'
/

comment on column SYS_DATA_ROLE_AUTH.REMARK is '备注'
/

comment on column SYS_DATA_ROLE_AUTH.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_DATA_ROLE_AUTH.CREATOR is '记录创建者'
/

comment on column SYS_DATA_ROLE_AUTH.CREATE_TIME is '记录创建时间'
/

comment on column SYS_DATA_ROLE_AUTH.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_DATA_ROLE_AUTH.UPDATER is '记录最后更新者'
/

comment on column SYS_DATA_ROLE_AUTH.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_DATA_ROLE_AUTH.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_DATA_ROLE_AUTH.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_DATA_ROLE_AUTH.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_DATA_ROLE_AUTH.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_DATA_ROLE_AUTH.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_DATA_ROLE_AUTH.OU_AUTH_ENABLE is '是否启用公司授权'
/

comment on column SYS_DATA_ROLE_AUTH.OU_AUTH_SCOPE is '公司数据权限授权范围'
/

comment on column SYS_DATA_ROLE_AUTH.OU_CUSTOMIZE_ENABLE is '公司是否启用自定义授权'
/

create index IDX_SYS_DATA_ROLE_AUTH_CREATE0
    on SYS_DATA_ROLE_AUTH (CREATE_USER_ID)
/

create index IDX_SYS_DATA_ROLE_AUTH_SEC_US0
    on SYS_DATA_ROLE_AUTH (SEC_USER_ID)
/

create index IDX_SYS_DATA_ROLE_AUTH_SEC_OU0
    on SYS_DATA_ROLE_AUTH (SEC_OU_ID)
/

create index IDX_SYS_DATA_ROLE_AUTH_SEC_BU0
    on SYS_DATA_ROLE_AUTH (SEC_BU_ID)
/

