create table SYS_DATABASE_SOURCE
(
    ID                 NUMBER(19)     not null
        constraint PK_SYS_DATABASE_SOURCE
            primary key,
    DBS_NAME           NVARCHAR2(64)  not null,
    DBS_DRIVER_CLASS   NVARCHAR2(64)  not null,
    DBS_URL            NVARCHAR2(256) not null,
    DBS_USERNAME       NVARCHAR2(64)  not null,
    DBS_PASSWORD       NVARCHAR2(64)  not null,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10)     not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_DATABASE_SOURCE is '数据源表'
/

comment on column SYS_DATABASE_SOURCE.ID is '记录唯一ID'
/

comment on column SYS_DATABASE_SOURCE.DBS_NAME is '数据源名称'
/

comment on column SYS_DATABASE_SOURCE.DBS_DRIVER_CLASS is '驱动类'
/

comment on column SYS_DATABASE_SOURCE.DBS_URL is '连接地址'
/

comment on column SYS_DATABASE_SOURCE.DBS_USERNAME is '驱动类'
/

comment on column SYS_DATABASE_SOURCE.DBS_PASSWORD is '驱动类'
/

comment on column SYS_DATABASE_SOURCE.TENANT_ID is '租户ID'
/

comment on column SYS_DATABASE_SOURCE.REMARK is '备注'
/

comment on column SYS_DATABASE_SOURCE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_DATABASE_SOURCE.CREATOR is '记录创建者'
/

comment on column SYS_DATABASE_SOURCE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_DATABASE_SOURCE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_DATABASE_SOURCE.UPDATER is '记录最后更新者'
/

comment on column SYS_DATABASE_SOURCE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_DATABASE_SOURCE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_DATABASE_SOURCE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_DATABASE_SOURCE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_DATABASE_SOURCE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_DATABASE_SOURCE.SEC_OU_ID is 'sec_ou_id'
/

create unique index UK_QRMQNS00NX8P2JGK46JK79YSL
    on SYS_DATABASE_SOURCE (DBS_NAME)
/

create unique index UK_5MH7YIBGT1Q5TLOVW1MT6ISW1
    on SYS_DATABASE_SOURCE (DBS_URL)
/

