create table SYS_FLOW_ROLE
(
    ID                 NUMBER(19)    not null
        constraint PK_SYS_FLOW_ROLE
            primary key,
    CODE               NVARCHAR2(16) not null,
    NAME               NVARCHAR2(32) not null,
    ENABLED            NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10)    not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_FLOW_ROLE is '流程角色表'
/

comment on column SYS_FLOW_ROLE.ID is '记录唯一ID'
/

comment on column SYS_FLOW_ROLE.CODE is '角色代码'
/

comment on column SYS_FLOW_ROLE.NAME is '角色名称'
/

comment on column SYS_FLOW_ROLE.ENABLED is '是否启用'
/

comment on column SYS_FLOW_ROLE.TENANT_ID is '租户ID'
/

comment on column SYS_FLOW_ROLE.REMARK is '备注'
/

comment on column SYS_FLOW_ROLE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_FLOW_ROLE.CREATOR is '记录创建者'
/

comment on column SYS_FLOW_ROLE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_FLOW_ROLE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_FLOW_ROLE.UPDATER is '记录最后更新者'
/

comment on column SYS_FLOW_ROLE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_FLOW_ROLE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_FLOW_ROLE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_FLOW_ROLE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_FLOW_ROLE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_FLOW_ROLE.SEC_OU_ID is 'sec_ou_id'
/

create unique index UK_K7IIM1LYHUYR06XN6JDJ8VEI1
    on SYS_FLOW_ROLE (CODE)
/

