create table SYS_FRONT_CONFIG
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_FRONT_CONFIG
            primary key,
    ROLE_ID            NUMBER(19),
    PERMISSION_ID      NUMBER(19),
    CONFIG_CODE        NVARCHAR2(40),
    CONFIG_CONTEXT     CLOB,
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10) not null,
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_FRONT_CONFIG is '前端表单，表格动态配置'
/

comment on column SYS_FRONT_CONFIG.ID is '记录唯一ID'
/

comment on column SYS_FRONT_CONFIG.ROLE_ID is '绑定的应用角色ID'
/

comment on column SYS_FRONT_CONFIG.PERMISSION_ID is '绑定的权限ID'
/

comment on column SYS_FRONT_CONFIG.CONFIG_CODE is '配置编号'
/

comment on column SYS_FRONT_CONFIG.CONFIG_CONTEXT is '配置内容'
/

comment on column SYS_FRONT_CONFIG.TENANT_ID is '租户ID'
/

comment on column SYS_FRONT_CONFIG.REMARK is '备注'
/

comment on column SYS_FRONT_CONFIG.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_FRONT_CONFIG.CREATOR is '记录创建者'
/

comment on column SYS_FRONT_CONFIG.CREATE_TIME is '记录创建时间'
/

comment on column SYS_FRONT_CONFIG.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_FRONT_CONFIG.UPDATER is '记录最后更新者'
/

comment on column SYS_FRONT_CONFIG.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_FRONT_CONFIG.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_FRONT_CONFIG.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_FRONT_CONFIG.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_FRONT_CONFIG.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_FRONT_CONFIG.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_CONFIG_CODE
    on SYS_FRONT_CONFIG (CONFIG_CODE)
/

