create table SYS_NEXT_NUMBER
(
    ID                 NUMBER(19)     not null
        constraint PK_SYS_NEXT_NUMBER
            primary key,
    CODE               NVARCHAR2(255) not null,
    NAME               NVARCHAR2(255) not null,
    NUMBER_CLASS       NVARCHAR2(255),
    STEP               NUMBER(10),
    NEXT_NUMBER        NUMBER(19),
    NN_PERIOD          NVARCHAR2(255),
    NN_TIME            DATE,
    VERSION            NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_NEXT_NUMBER is '取号下一编号表'
/

comment on column SYS_NEXT_NUMBER.ID is '记录唯一ID'
/

comment on column SYS_NEXT_NUMBER.CODE is '下一编号代码'
/

comment on column SYS_NEXT_NUMBER.NAME is '下一编号名称'
/

comment on column SYS_NEXT_NUMBER.NUMBER_CLASS is '下一编号分类'
/

comment on column SYS_NEXT_NUMBER.STEP is '下一编号步长'
/

comment on column SYS_NEXT_NUMBER.NEXT_NUMBER is '下一编号取值'
/

comment on column SYS_NEXT_NUMBER.NN_PERIOD is '下一编号周期'
/

comment on column SYS_NEXT_NUMBER.NN_TIME is '发号时间'
/

comment on column SYS_NEXT_NUMBER.VERSION is '乐观锁标记'
/

comment on column SYS_NEXT_NUMBER.TENANT_ID is '租户ID'
/

comment on column SYS_NEXT_NUMBER.REMARK is '备注'
/

comment on column SYS_NEXT_NUMBER.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_NEXT_NUMBER.CREATOR is '记录创建者'
/

comment on column SYS_NEXT_NUMBER.CREATE_TIME is '记录创建时间'
/

comment on column SYS_NEXT_NUMBER.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_NEXT_NUMBER.UPDATER is '记录最后更新者'
/

comment on column SYS_NEXT_NUMBER.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_NEXT_NUMBER.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_NEXT_NUMBER.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_NEXT_NUMBER.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_NEXT_NUMBER.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_NEXT_NUMBER.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_NEXT_NUMBER_CREATE_US0
    on SYS_NEXT_NUMBER (CREATE_USER_ID)
/

create unique index UK_S6XDFQU3P37TC3A6GPSC23MQ8
    on SYS_NEXT_NUMBER (CODE)
/

create index IDX_SYS_NEXT_NUMBER_SEC_USER_0
    on SYS_NEXT_NUMBER (SEC_USER_ID)
/

create index IDX_SYS_NEXT_NUMBER_SEC_OU_ID
    on SYS_NEXT_NUMBER (SEC_OU_ID)
/

create index IDX_SYS_NEXT_NUMBER_SEC_BU_ID
    on SYS_NEXT_NUMBER (SEC_BU_ID)
/
