create table SYS_NUMBER_RULE
(
    ID                 NUMBER(19)     not null
        constraint PK_SYS_NUMBER_RULE
            primary key,
    RULE_CODE          NVARCHAR2(255) not null,
    RULE_NAME          NVARCHAR2(64),
    RULE_CLASS         NVARCHAR2(32),
    SAMPLE_CODE        NVARCHAR2(255),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_NUMBER_RULE is '发号器规则'
/

comment on column SYS_NUMBER_RULE.ID is '记录唯一ID'
/

comment on column SYS_NUMBER_RULE.RULE_CODE is '规则编号'
/

comment on column SYS_NUMBER_RULE.RULE_NAME is '规则名称'
/

comment on column SYS_NUMBER_RULE.RULE_CLASS is '规则分类码：sys:numrulcls'
/

comment on column SYS_NUMBER_RULE.SAMPLE_CODE is '取号示例'
/

comment on column SYS_NUMBER_RULE.TENANT_ID is '租户ID'
/

comment on column SYS_NUMBER_RULE.REMARK is '备注'
/

comment on column SYS_NUMBER_RULE.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_NUMBER_RULE.CREATOR is '记录创建者'
/

comment on column SYS_NUMBER_RULE.CREATE_TIME is '记录创建时间'
/

comment on column SYS_NUMBER_RULE.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_NUMBER_RULE.UPDATER is '记录最后更新者'
/

comment on column SYS_NUMBER_RULE.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_NUMBER_RULE.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_NUMBER_RULE.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_NUMBER_RULE.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_NUMBER_RULE.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_NUMBER_RULE.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_NUMBER_RULE_CREATE_US0
    on SYS_NUMBER_RULE (CREATE_USER_ID)
/

create index IDX_SYS_NUMBER_RULE_SEC_USER_0
    on SYS_NUMBER_RULE (SEC_USER_ID)
/

create unique index UK_3904PUGPU38VQWLG4AUSSVGR1
    on SYS_NUMBER_RULE (RULE_CODE)
/

create index IDX_SYS_NUMBER_RULE_SEC_OU_ID
    on SYS_NUMBER_RULE (SEC_OU_ID)
/

create index IDX_SYS_NUMBER_RULE_SEC_BU_ID
    on SYS_NUMBER_RULE (SEC_BU_ID)
/
