create table SYS_NUMBER_RULEDTL
(
    ID                 NUMBER(19) not null
        constraint PK_SYS_NUMBER_RULEDTL
            primary key,
    RULE_ID            NUMBER(19),
    SEQ                NUMBER(10),
    NUMBER_TYPE        NVARCHAR2(255),
    NUMBER_PATTERN     NVARCHAR2(255),
    NN_LEN             NUMBER(10),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATOR            NVARCHAR2(255),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    UPDATER            NVARCHAR2(255),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19)
)
/

comment on table SYS_NUMBER_RULEDTL is '发号器规则明细'
/

comment on column SYS_NUMBER_RULEDTL.ID is '记录唯一ID'
/

comment on column SYS_NUMBER_RULEDTL.RULE_ID is '发号器规则ID'
/

comment on column SYS_NUMBER_RULEDTL.SEQ is '排序号'
/

comment on column SYS_NUMBER_RULEDTL.NUMBER_TYPE is '取号类型：sys:numbertype'
/

comment on column SYS_NUMBER_RULEDTL.NUMBER_PATTERN is '取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码'
/

comment on column SYS_NUMBER_RULEDTL.NN_LEN is '自增序号宽度，默认左补零'
/

comment on column SYS_NUMBER_RULEDTL.TENANT_ID is '租户ID'
/

comment on column SYS_NUMBER_RULEDTL.REMARK is '备注'
/

comment on column SYS_NUMBER_RULEDTL.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_NUMBER_RULEDTL.CREATOR is '记录创建者'
/

comment on column SYS_NUMBER_RULEDTL.CREATE_TIME is '记录创建时间'
/

comment on column SYS_NUMBER_RULEDTL.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_NUMBER_RULEDTL.UPDATER is '记录最后更新者'
/

comment on column SYS_NUMBER_RULEDTL.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_NUMBER_RULEDTL.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_NUMBER_RULEDTL.AUDIT_DATA_VERSION is '锁版本'
/

comment on column SYS_NUMBER_RULEDTL.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_NUMBER_RULEDTL.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_NUMBER_RULEDTL.SEC_OU_ID is 'sec_ou_id'
/

create index IDX_SYS_NUMBER_RULEDTL_RULE_ID
    on SYS_NUMBER_RULEDTL (RULE_ID)
/

create index IDX_SYS_NUMBER_RULEDTL_CREATE0
    on SYS_NUMBER_RULEDTL (CREATE_USER_ID)
/

create index IDX_SYS_NUMBER_RULEDTL_SEC_US0
    on SYS_NUMBER_RULEDTL (SEC_USER_ID)
/

create index IDX_SYS_NUMBER_RULEDTL_SEC_OU0
    on SYS_NUMBER_RULEDTL (SEC_OU_ID)
/

create index IDX_SYS_NUMBER_RULEDTL_SEC_BU0
    on SYS_NUMBER_RULEDTL (SEC_BU_ID)
/
