create table SYS_PERMISSION
(
    ID                 NUMBER(19)     not null
        constraint PK_SYS_PERMISSION
            primary key,
    CODE               NVARCHAR2(128) not null,
    NAME               NVARCHAR2(64)  not null,
    PERM_TYPE          NUMBER(10),
    PARENT_ID          NUMBER(19),
    PATH               NVARCHAR2(255),
    PERM_LEVEL         NUMBER(10),
    SORT_NO            NUMBER(10),
    PATTERN            NVARCHAR2(255),
    HTTP_METHOD        NVARCHAR2(32),
    TENANT_ID          NUMBER(19),
    REMARK             NVARCHAR2(255),
    CREATE_USER_ID     NUMBER(19),
    CREATE_TIME        DATE,
    MODIFY_USER_ID     NUMBER(19),
    MODIFY_TIME        DATE,
    DELETE_FLAG        NUMBER(10),
    AUDIT_DATA_VERSION NUMBER(10),
    CREATOR            NVARCHAR2(255),
    UPDATER            NVARCHAR2(255),
    ICON               NVARCHAR2(255),
    IS_HIDDEN          NUMBER(10),
    SEC_BU_ID          NUMBER(19),
    SEC_USER_ID        NUMBER(19),
    SEC_OU_ID          NUMBER(19),
    TERMINAL_CODE      NVARCHAR2(20),
    IS_QUICK           NUMBER(11)
)
/

comment on table SYS_PERMISSION is '系统权限表，包括URL、操作'
/

comment on column SYS_PERMISSION.ID is '账号唯一ID'
/

comment on column SYS_PERMISSION.CODE is '权限代码'
/

comment on column SYS_PERMISSION.NAME is '权限名称'
/

comment on column SYS_PERMISSION.PERM_TYPE is '权限类型'
/

comment on column SYS_PERMISSION.PARENT_ID is '父权限ID'
/

comment on column SYS_PERMISSION.PATH is '权限层级路径'
/

comment on column SYS_PERMISSION.PERM_LEVEL is '权限层级'
/

comment on column SYS_PERMISSION.SORT_NO is '排列顺序'
/

comment on column SYS_PERMISSION.PATTERN is 'URL路径模式'
/

comment on column SYS_PERMISSION.HTTP_METHOD is 'URL的HTTP方法[COM:HTTP_METH]'
/

comment on column SYS_PERMISSION.TENANT_ID is '租户ID'
/

comment on column SYS_PERMISSION.REMARK is '备注'
/

comment on column SYS_PERMISSION.CREATE_USER_ID is '记录创建者ID'
/

comment on column SYS_PERMISSION.CREATE_TIME is '记录创建时间'
/

comment on column SYS_PERMISSION.MODIFY_USER_ID is '记录最后更新者ID'
/

comment on column SYS_PERMISSION.MODIFY_TIME is '记录最后更新时间'
/

comment on column SYS_PERMISSION.DELETE_FLAG is '逻辑删除，0：未删除，1：已删除'
/

comment on column SYS_PERMISSION.AUDIT_DATA_VERSION is '版本'
/

comment on column SYS_PERMISSION.CREATOR is '记录创建者'
/

comment on column SYS_PERMISSION.UPDATER is '记录最后更新者'
/

comment on column SYS_PERMISSION.ICON is '菜单图标'
/

comment on column SYS_PERMISSION.IS_HIDDEN is '菜单是否隐藏'
/

comment on column SYS_PERMISSION.SEC_BU_ID is 'sec_bu_id'
/

comment on column SYS_PERMISSION.SEC_USER_ID is 'sec_user_id'
/

comment on column SYS_PERMISSION.SEC_OU_ID is 'sec_ou_id'
/

comment on column SYS_PERMISSION.TERMINAL_CODE is '登录多端'
/

comment on column SYS_PERMISSION.IS_QUICK is '是否是快捷'
/

create index IDX_SYS_PERMISSION_CREATE_USE0
    on SYS_PERMISSION (CREATE_USER_ID)
/

create index IDX_SYS_PERMISSION_SEC_USER_ID
    on SYS_PERMISSION (SEC_USER_ID)
/

create index IDX_SYS_PERMISSION_PID
    on SYS_PERMISSION (PARENT_ID)
/

create index IDX_SYS_PERMISSION_SEC_OU_ID
    on SYS_PERMISSION (SEC_OU_ID)
/

create index IDX_SYS_PERMISSION_SEC_BU_ID
    on SYS_PERMISSION (SEC_BU_ID)
/